/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.ConsumerFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.datepicker.DatePickerDOMElement;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.listbox.MultiValueDOMElement;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.listbox.MultiValueSingletonDOMElementFactory;
import org.gwtbootstrap3.client.ui.ListBox;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.widgets.common.client.common.DatePicker;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.CellSelectionStrategy;

@RunWith(value=GwtMockitoTestRunner.class)
public class ConsumerFactoryTest {
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String TEST_DATE_FORMAT = "MM-dd-yyyy HH:mm:ss Z";
    @Mock
    private MultiValueSingletonDOMElementFactory factory;
    @Mock
    private MultiValueDOMElement multiValueDOMElement;
    @Mock
    private ListBox multiValueWidget;
    @Mock
    private GridCell cell;
    private Map<String, String> enumLookups;

    @BeforeClass
    public static void setupStatic() {
        System.setProperty("user.timezone", "Europe/Vilnius");
        ApplicationPreferences.setUp((Map)new HashMap<String, String>(){
            {
                this.put("kie_timezone_offset", "10800000");
                this.put("drools.dateformat", ConsumerFactoryTest.TEST_DATE_FORMAT);
            }
        });
    }

    @Before
    public void setup() {
        this.enumLookups = new HashMap<String, String>();
        Mockito.when((Object)this.multiValueDOMElement.getWidget()).thenReturn((Object)this.multiValueWidget);
    }

    @Test
    public void makeOnCreationCallbackListBoxSingleSelect() {
        this.setupMultipleSelectTest(10, false);
        Consumer callback = ConsumerFactory.makeOnCreationCallback((MultiValueSingletonDOMElementFactory)this.factory, (GridCell)this.cell, this.enumLookups);
        callback.accept(this.multiValueDOMElement);
        this.verifyMultipleSelectTest(10);
        ((ListBox)Mockito.verify((Object)this.multiValueWidget, (VerificationMode)Mockito.never())).setVisibleItemCount(Mockito.anyInt());
    }

    @Test
    public void makeOnCreationCallbackListBoxMultipleSelect() {
        this.setupMultipleSelectTest(10, true);
        Consumer callback = ConsumerFactory.makeOnCreationCallback((MultiValueSingletonDOMElementFactory)this.factory, (GridCell)this.cell, this.enumLookups);
        callback.accept(this.multiValueDOMElement);
        this.verifyMultipleSelectTest(10);
        ((ListBox)Mockito.verify((Object)this.multiValueWidget)).setVisibleItemCount(Mockito.eq((int)10));
    }

    @Test
    public void makeOnCreationCallbackListBoxMultipleSelectMoreThanMaximum() {
        this.setupMultipleSelectTest(11, true);
        Consumer callback = ConsumerFactory.makeOnCreationCallback((MultiValueSingletonDOMElementFactory)this.factory, (GridCell)this.cell, this.enumLookups);
        callback.accept(this.multiValueDOMElement);
        ((ListBox)Mockito.verify((Object)this.multiValueWidget)).setVisibleItemCount(Mockito.eq((int)10));
        this.verifyMultipleSelectTest(11);
    }

    @Test
    public void testMakeOnCreationCallback() {
        DatePickerDOMElement datePickerDomElement = (DatePickerDOMElement)Mockito.mock(DatePickerDOMElement.class);
        DatePicker datePickerWidget = (DatePicker)Mockito.mock(DatePicker.class);
        String serverDate = "05-01-2018 06:00:00 +0300";
        String dateConvertedFromServerTimezone = "05-01-2018 00:00:00 -0300";
        Consumer callback = ConsumerFactory.makeOnCreationCallback(this.makeGridCell(this.asDate("05-01-2018 06:00:00 +0300")));
        Mockito.when((Object)datePickerDomElement.getWidget()).thenReturn((Object)datePickerWidget);
        callback.accept(datePickerDomElement);
        ((DatePicker)Mockito.verify((Object)datePickerWidget)).setValue(this.asDate("05-01-2018 00:00:00 -0300"));
    }

    private void setupMultipleSelectTest(int enumLookupSize, boolean isMultipleSelect) {
        IntStream.rangeClosed(1, enumLookupSize).forEach(i -> this.enumLookups.put(KEY + i, VALUE + i));
        Mockito.when((Object)this.multiValueWidget.isMultipleSelect()).thenReturn((Object)isMultipleSelect);
    }

    private void verifyMultipleSelectTest(int enumLookupSize) {
        IntStream.range(1, enumLookupSize).forEach(i -> ((ListBox)Mockito.verify((Object)this.multiValueWidget)).addItem((String)Mockito.eq((Object)(VALUE + i)), (String)Mockito.eq((Object)(KEY + i))));
        ((MultiValueSingletonDOMElementFactory)Mockito.verify((Object)this.factory)).toWidget((GridCell)Mockito.eq((Object)this.cell), (ListBox)Mockito.eq((Object)this.multiValueWidget));
    }

    private Date asDate(String dateString) {
        return this.format().parse(dateString);
    }

    private DateTimeFormat format() {
        return DateTimeFormat.getFormat((String)TEST_DATE_FORMAT);
    }

    private GridCell<Date> makeGridCell(final Date date) {
        return new GridCell<Date>(){

            public GridCellValue<Date> getValue() {
                return () -> date;
            }

            public boolean isMerged() {
                return false;
            }

            public int getMergedCellCount() {
                return 0;
            }

            public boolean isCollapsed() {
                return false;
            }

            public void collapse() {
            }

            public void expand() {
            }

            public void reset() {
            }

            public CellSelectionStrategy getSelectionStrategy() {
                return null;
            }

            public void setSelectionStrategy(CellSelectionStrategy selectionStrategy) {
            }
        };
    }
}

