/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.listbox;

import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.function.Consumer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.listbox.ListBoxSingletonDOMElementFactory;
import org.gwtbootstrap3.client.ui.ListBox;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;

@RunWith(value=GwtMockitoTestRunner.class)
public class ListBoxSingletonDOMElementFactoryTest {
    @Mock
    private ListBox listBox;
    @Mock
    private Element listBoxElement;
    @Mock
    private AbsolutePanel domElementContainer;
    @Mock
    private GridLienzoPanel gridLienzoPanel;
    @Mock
    private GridLayer gridLayer;
    @Mock
    private GuidedDecisionTableView gridWidget;
    @Mock
    private GridBodyCellRenderContext cellRenderContext;
    private ListBoxSingletonDOMElementFactory<String, ListBox> factory;

    @Before
    public void setup() {
        Mockito.when((Object)this.listBox.getElement()).thenReturn((Object)this.listBoxElement);
        Mockito.when((Object)this.listBoxElement.getStyle()).thenReturn(Mockito.mock(Style.class));
        Mockito.when((Object)this.domElementContainer.iterator()).thenReturn(Collections.emptyList().iterator());
        Mockito.when((Object)this.gridLayer.getDomElementContainer()).thenReturn((Object)this.domElementContainer);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)new BaseGridData());
        ((GridLayer)Mockito.doAnswer(i -> {
            GridLayerRedrawManager.PrioritizedCommand command = (GridLayerRedrawManager.PrioritizedCommand)i.getArguments()[0];
            command.execute();
            return null;
        }).when((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)Matchers.any(GridLayerRedrawManager.PrioritizedCommand.class));
        this.factory = (ListBoxSingletonDOMElementFactory)Mockito.spy((Object)((Object)new ListBoxSingletonDOMElementFactoryMock(this.gridLienzoPanel, this.gridLayer, this.gridWidget)));
    }

    @Test
    public void checkDOMElementCreationChecksListBoxIsMultipleSelect() {
        this.factory.createDomElement(this.gridLayer, (GridWidget)this.gridWidget, this.cellRenderContext);
        ((ListBox)Mockito.verify((Object)this.listBox)).addMouseDownHandler((MouseDownHandler)Matchers.any(MouseDownHandler.class));
        ((ListBox)Mockito.verify((Object)this.listBox)).addKeyDownHandler((KeyDownHandler)Matchers.any(KeyDownHandler.class));
        ((ListBox)Mockito.verify((Object)this.listBox)).addBlurHandler((BlurHandler)Matchers.any(BlurHandler.class));
        ((ListBox)Mockito.verify((Object)this.listBox)).isMultipleSelect();
    }

    @Test
    public void checkDOMElementCreationMouseDownHandler() {
        this.factory.createDomElement(this.gridLayer, (GridWidget)this.gridWidget, this.cellRenderContext);
        ArgumentCaptor mouseDownHandlerCaptor = ArgumentCaptor.forClass(MouseDownHandler.class);
        ((ListBox)Mockito.verify((Object)this.listBox)).addMouseDownHandler((MouseDownHandler)mouseDownHandlerCaptor.capture());
        MouseDownEvent e = (MouseDownEvent)Mockito.mock(MouseDownEvent.class);
        MouseDownHandler mouseDownHandler = (MouseDownHandler)mouseDownHandlerCaptor.getValue();
        mouseDownHandler.onMouseDown(e);
        ((MouseDownEvent)Mockito.verify((Object)e)).stopPropagation();
    }

    @Test
    public void checkDOMElementCreationBlurHandler() {
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.factory});
        GridBodyCellRenderContext context = (GridBodyCellRenderContext)Mockito.mock(GridBodyCellRenderContext.class);
        Consumer onCreation = (Consumer)Mockito.mock(Consumer.class);
        Consumer onDisplay = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)context.getTransform()).thenReturn(Mockito.mock(Transform.class));
        this.factory.attachDomElement(context, onCreation, onDisplay);
        ArgumentCaptor blurHandlerCaptor = ArgumentCaptor.forClass(BlurHandler.class);
        ((ListBox)Mockito.verify((Object)this.listBox)).addBlurHandler((BlurHandler)blurHandlerCaptor.capture());
        BlurEvent e = (BlurEvent)Mockito.mock(BlurEvent.class);
        BlurHandler blurHandler = (BlurHandler)blurHandlerCaptor.getValue();
        blurHandler.onBlur(e);
        ((ListBoxSingletonDOMElementFactory)order.verify(this.factory)).flush();
        ((ListBoxSingletonDOMElementFactory)order.verify(this.factory)).destroyResources();
        ((GridLayer)Mockito.verify((Object)this.gridLayer)).batch();
        ((GridLienzoPanel)Mockito.verify((Object)this.gridLienzoPanel)).setFocus(Matchers.eq((boolean)true));
    }

    private class ListBoxSingletonDOMElementFactoryMock
    extends ListBoxSingletonDOMElementFactory<String, ListBox> {
        public ListBoxSingletonDOMElementFactoryMock(GridLienzoPanel gridPanel, GridLayer gridLayer, GuidedDecisionTableView gridWidget) {
            super(gridPanel, gridLayer, gridWidget);
        }

        public String convert(String value) {
            return "";
        }

        public ListBox createWidget() {
            return ListBoxSingletonDOMElementFactoryTest.this.listBox;
        }
    }
}

