/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.stream.IntStream;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl.BaseColumnConverterUtilities;
import org.gwtbootstrap3.client.ui.ListBox;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;

@RunWith(value=GwtMockitoTestRunner.class)
public class BaseColumnConverterUtilitiesTest {
    @GwtMock
    private ListBox listBox;
    @Mock
    private GridCell<String> cell;
    @Mock
    private GridCellValue<String> cellValue;

    @Test
    public void checkToWidgetNoValue() {
        BaseColumnConverterUtilities.toWidget((boolean)false, this.cell, (ListBox)this.listBox);
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.never())).addItem(Mockito.anyString());
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.never())).addItem(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void checkToWidgetNoValueValue() {
        Mockito.when((Object)this.cell.getValue()).thenReturn(this.cellValue);
        BaseColumnConverterUtilities.toWidget((boolean)false, this.cell, (ListBox)this.listBox);
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.never())).addItem(Mockito.anyString());
        ((ListBox)Mockito.verify((Object)this.listBox, (VerificationMode)Mockito.never())).addItem(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void checkToWidgetNoValueWithListBoxValues() {
        Mockito.when((Object)this.listBox.getItemCount()).thenReturn((Object)1);
        BaseColumnConverterUtilities.toWidget((boolean)false, this.cell, (ListBox)this.listBox);
        ((ListBox)Mockito.verify((Object)this.listBox)).setSelectedIndex(Mockito.eq((int)0));
    }

    @Test
    public void checkToWidgetWithValueWithSingleSelectListBoxWithValues() {
        Mockito.when((Object)this.cell.getValue()).thenReturn(this.cellValue);
        Mockito.when((Object)this.cellValue.getValue()).thenReturn((Object)"value1");
        this.checkToWidget(new String[]{"value0", "value1"}, new ToWidget[]{new ToWidget(1, true)}, false);
    }

    @Test
    public void checkToWidgetWithValueWithMultipleSelectSingleValueListBoxWithValues() {
        Mockito.when((Object)this.cell.getValue()).thenReturn(this.cellValue);
        Mockito.when((Object)this.cellValue.getValue()).thenReturn((Object)"value1");
        this.checkToWidget(new String[]{"value0", "value1"}, new ToWidget[]{new ToWidget(0, false), new ToWidget(1, true)}, true);
    }

    @Test
    public void checkToWidgetWithValueWithMultipleSelectMultipleValuesListBoxWithValues() {
        Mockito.when((Object)this.cell.getValue()).thenReturn(this.cellValue);
        Mockito.when((Object)this.cellValue.getValue()).thenReturn((Object)"value0,value1");
        this.checkToWidget(new String[]{"value0", "value1"}, new ToWidget[]{new ToWidget(0, true), new ToWidget(1, true)}, true);
    }

    @Test
    public void checkFromWidgetWhenSingleSelect() {
        Mockito.when((Object)this.listBox.getSelectedIndex()).thenReturn((Object)0);
        this.checkFromWidget(new FromWidget[]{new FromWidget("value", true)}, "value", false);
    }

    @Test
    public void checkFromWidgetWhenMultipleSelectWithSingleValueSelected() {
        this.checkFromWidget(new FromWidget[]{new FromWidget("value0", true), new FromWidget("value1", false)}, "value0", true);
    }

    @Test
    public void checkFromWidgetWhenMultipleSelectWithMultipleValuesSelected() {
        this.checkFromWidget(new FromWidget[]{new FromWidget("value0", true), new FromWidget("value1", true)}, "value0,value1", true);
    }

    @Test
    public void checkFromWidgetWhenMultipleSelectWithNoValuesSelected() {
        this.checkFromWidget(new FromWidget[]{new FromWidget("value0", false), new FromWidget("value1", false)}, "", true);
    }

    private void checkToWidget(String[] items, ToWidget[] expected, boolean isMultipleSelect) {
        Mockito.when((Object)this.listBox.getItemCount()).thenReturn((Object)items.length);
        IntStream.range(0, items.length).forEach(i -> Mockito.when((Object)this.listBox.getValue(Mockito.eq((int)i))).thenReturn((Object)items[i]));
        BaseColumnConverterUtilities.toWidget((boolean)isMultipleSelect, this.cell, (ListBox)this.listBox);
        if (expected.length == 0) {
            Assert.fail((String)"There are no assertions to be made!");
        } else if (expected.length == 1) {
            ((ListBox)Mockito.verify((Object)this.listBox)).setSelectedIndex(((Integer)Mockito.eq((Object)expected[0].index)).intValue());
        } else {
            IntStream.range(0, expected.length).forEach(i -> ((ListBox)Mockito.verify((Object)this.listBox)).setItemSelected(((Integer)Mockito.eq((Object)expected[i].index)).intValue(), ((Boolean)Mockito.eq((Object)expected[i].selected)).booleanValue()));
        }
    }

    private void checkFromWidget(FromWidget[] items, String expected, boolean isMultipleSelect) {
        Mockito.when((Object)this.listBox.getItemCount()).thenReturn((Object)items.length);
        IntStream.range(0, items.length).forEach(i -> {
            Mockito.when((Object)this.listBox.getValue(Mockito.eq((int)i))).thenReturn((Object)items[i].value);
            Mockito.when((Object)this.listBox.isItemSelected(Mockito.eq((int)i))).thenReturn((Object)items[i].selected);
        });
        Assert.assertEquals((Object)expected, (Object)BaseColumnConverterUtilities.fromWidget((boolean)isMultipleSelect, (ListBox)this.listBox));
    }

    private static class FromWidget
    implements Pair<String, Boolean> {
        final String value;
        final Boolean selected;

        FromWidget(String value, Boolean selected) {
            this.value = value;
            this.selected = selected;
        }
    }

    private static class ToWidget
    implements Pair<Integer, Boolean> {
        final Integer index;
        final Boolean selected;

        ToWidget(Integer index, Boolean selected) {
            this.index = index;
            this.selected = selected;
        }
    }

    private static interface Pair<V1, V2> {
    }
}

