/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.utilities;

import com.google.gwtmockito.GwtMockito;
import java.util.Arrays;
import java.util.HashMap;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class ColumnUtilitiesGetValueListTest {
    private static final String DATE_CONVERSION_VALUE_LIST = "a,10-10-2010,b, d";
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private AsyncPackageDataModelOracle oracle;
    private Pattern52 pattern;
    private ConditionCol52 column;
    private ColumnUtilities utilities;
    @Parameterized.Parameter(value=0)
    public String valueList;
    @Parameterized.Parameter(value=1)
    public String fieldDataType;
    @Parameterized.Parameter(value=2)
    public int validValuesCount;
    @Parameterized.Parameter(value=3)
    public String[] validValues;

    @Parameterized.Parameters(name="valueList:{0} dataType:{1} validValuesCount:{2} validValues:{3}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"a,b,c", "String", 3, new String[]{"a", "b", "c"}}, {"a, ' b b b ' ,c", "String", 3, new String[]{"a", " b b b ", "c"}}, {"a,1,b", "String", 3, new String[]{"a", "1", "b"}}, {"@,#,$", "String", 3, new String[]{"@", "#", "$"}}, {",a", "String", 2, new String[]{"", "a"}}, {"a,,b", "String", 3, new String[]{"a", "", "b"}}, {"'a, 123',b", "String", 2, new String[]{"a, 123", "b"}}, {"a,10-10-2010,b", "Date", 3, new String[]{"a", "10-10-2010", "b"}}, {DATE_CONVERSION_VALUE_LIST, "Date", 1, new String[]{"10-10-2010"}}, {"1,1.0,a", "BigDecimal", 2, new String[]{"1", "1.0"}}, {"1,1.0,a", "BigInteger", 1, new String[]{"1"}}, {"1,1.0,a", "Byte", 1, new String[]{"1"}}, {"1,1.0,a,1d", "Double", 3, new String[]{"1", "1.0", "1d"}}, {"1,1.0,a,1f", "Float", 3, new String[]{"1", "1.0", "1f"}}, {"1,1.0,a", "Integer", 1, new String[]{"1"}}, {"1,1.0,a", "Long", 1, new String[]{"1"}}, {"1,1.0,a", "Short", 1, new String[]{"1"}}, {"1,true,false", "Boolean", 2, new String[]{"true", "false"}});
    }

    @Before
    public void setUp() {
        GwtMockito.initMocks((Object)this);
        this.utilities = new ColumnUtilities(this.model, this.oracle);
        this.pattern = new Pattern52();
        this.column = new ConditionCol52();
        Mockito.when((Object)this.model.getPattern(this.column)).thenReturn((Object)this.pattern);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.valueList.compareTo(DATE_CONVERSION_VALUE_LIST) == 0) {
            properties.put("drools.dateformat", "dd-MM-yyyy");
        } else {
            properties.put("drools.dateformat", null);
        }
        ApplicationPreferences.setUp(properties);
    }

    @Test
    public void testGetValueList() {
        this.column.setValueList(this.valueList);
        this.column.setFieldType(this.fieldDataType);
        String[] values = this.utilities.getValueList((BaseColumn)this.column);
        Assert.assertEquals((long)this.validValuesCount, (long)values.length);
        for (int i = 0; i < this.validValuesCount; ++i) {
            Assert.assertEquals((Object)this.validValues[i], (Object)values[i]);
        }
    }
}

