/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPageView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTablePopoverUtils;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class AdditionalInfoPageViewTest {
    public static final String HIDE_TRANSLATION = "hide translation";
    public static final String UPDATE_ENGINE_TRANSLATION = "update engine translation";
    public static final String LOGICALLY_INSERT_TRANSLATION = "logically insert translation";
    public static final String HEADER_TRANSLATION = "header translation";
    @Mock
    private Input input;
    @Mock
    private Div headerFormItem;
    @Mock
    private TranslationService translationService;
    @Mock
    private DecisionTablePopoverUtils popoverUtils;
    @Mock
    private AdditionalInfoPage page;
    @Spy
    @InjectMocks
    private AdditionalInfoPageView view;

    @Before
    public void setUp() throws Exception {
        ((TranslationService)Mockito.doReturn((Object)HEADER_TRANSLATION).when((Object)this.translationService)).format("AdditionalInfoPage.HeaderColumnDescription", new Object[0]);
        ((TranslationService)Mockito.doReturn((Object)HIDE_TRANSLATION).when((Object)this.translationService)).format("AdditionalInfoPage.HideColumnDescription", new Object[0]);
        ((TranslationService)Mockito.doReturn((Object)UPDATE_ENGINE_TRANSLATION).when((Object)this.translationService)).format("AdditionalInfoPage.UpdateEngineDescription", new Object[0]);
        ((TranslationService)Mockito.doReturn((Object)LOGICALLY_INSERT_TRANSLATION).when((Object)this.translationService)).format("AdditionalInfoPage.LogicalInsertDescription", new Object[0]);
        this.view.init(this.page);
    }

    @Test
    public void testInitPopovers() throws Exception {
        this.view.initPopovers();
        ((Input)Mockito.verify((Object)this.input, (VerificationMode)Mockito.times((int)1))).setAttribute("type", "textbox");
        ((Input)Mockito.verify((Object)this.input, (VerificationMode)Mockito.times((int)4))).setAttribute("class", "form-control");
        ((Input)Mockito.verify((Object)this.input, (VerificationMode)Mockito.times((int)3))).setAttribute("type", "checkbox");
        ((Input)Mockito.verify((Object)this.input, (VerificationMode)Mockito.times((int)4))).setAttribute("data-toggle", "popover");
        ((DecisionTablePopoverUtils)Mockito.verify((Object)this.popoverUtils)).setupAndRegisterPopover((HTMLElement)Matchers.eq((Object)this.input), (String)Matchers.eq((Object)HEADER_TRANSLATION));
        ((DecisionTablePopoverUtils)Mockito.verify((Object)this.popoverUtils)).setupAndRegisterPopover((HTMLElement)Matchers.eq((Object)this.input), (String)Matchers.eq((Object)HIDE_TRANSLATION));
        ((DecisionTablePopoverUtils)Mockito.verify((Object)this.popoverUtils)).setupAndRegisterPopover((HTMLElement)Matchers.eq((Object)this.input), (String)Matchers.eq((Object)UPDATE_ENGINE_TRANSLATION));
        ((DecisionTablePopoverUtils)Mockito.verify((Object)this.popoverUtils)).setupAndRegisterPopover((HTMLElement)Matchers.eq((Object)this.input), (String)Matchers.eq((Object)LOGICALLY_INSERT_TRANSLATION));
    }

    @Test
    public void testShowHeaderEmpty() throws Exception {
        this.view.showHeader();
        ((Input)Mockito.verify((Object)this.input)).setValue("");
        ((Div)Mockito.verify((Object)this.headerFormItem)).setHidden(false);
    }

    @Test
    public void testShowHeaderNotEmpty() throws Exception {
        String headerContent = "header content";
        ((AdditionalInfoPage)Mockito.doReturn((Object)"header content").when((Object)this.page)).getHeader();
        this.view.showHeader();
        ((Input)Mockito.verify((Object)this.input)).setValue("header content");
        ((Div)Mockito.verify((Object)this.headerFormItem)).setHidden(false);
    }
}

