/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import elemental2.dom.Node;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPageView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTablePopoverUtils;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class FieldPageViewTest {
    @Mock
    private ListBox fieldList;
    @Mock
    private TextBox fieldTextBox;
    @Mock
    private HTMLDivElement fieldListDescription;
    @Mock
    private HTMLDivElement predicateFieldDescription;
    @Mock
    private HTMLDivElement patternWarning;
    @Mock
    private HTMLDivElement fieldWarning;
    @Mock
    private HTMLDivElement info;
    @Mock
    private HTMLDivElement bindingContainer;
    @Mock
    private HTMLDivElement bindingFieldContainer;
    @Mock
    private HTMLDivElement fieldBindingWarning;
    @Mock
    private HTMLDivElement predicateBindingInfo;
    @Mock
    private Elemental2DomUtil elemental2DomUtil;
    @Mock
    private DecisionTablePopoverUtils popoverUtils;
    @Mock
    private TranslationService translationService;
    @Mock
    private FieldPage page;
    private FieldPageView view;

    @Before
    public void setup() {
        this.view = new FieldPageView(this.fieldList, this.fieldTextBox, this.fieldWarning, this.patternWarning, this.fieldListDescription, this.predicateFieldDescription, this.bindingContainer, this.bindingFieldContainer, this.fieldBindingWarning, this.predicateBindingInfo, this.translationService, this.elemental2DomUtil, this.popoverUtils);
        this.view.init(this.page);
    }

    @Test
    public void testEnableFieldList() {
        this.view.enableListFieldView();
        ((ListBox)Mockito.verify((Object)this.fieldList)).setVisible(true);
        ((TextBox)Mockito.verify((Object)this.fieldTextBox)).setVisible(false);
        Assert.assertFalse((boolean)this.fieldListDescription.hidden);
        Assert.assertTrue((boolean)this.predicateFieldDescription.hidden);
    }

    @Test
    public void testEnableTextField() {
        this.view.enablePredicateFieldView();
        ((ListBox)Mockito.verify((Object)this.fieldList)).setVisible(false);
        ((TextBox)Mockito.verify((Object)this.fieldTextBox)).setVisible(true);
        Assert.assertTrue((boolean)this.fieldListDescription.hidden);
        Assert.assertFalse((boolean)this.predicateFieldDescription.hidden);
    }

    @Test
    public void testSetField() {
        String field = "field";
        this.view.setField("field");
        ((TextBox)Mockito.verify((Object)this.fieldTextBox)).setText("field");
    }

    @Test
    public void testOnFieldTextBoxChange() {
        String field = "field";
        KeyUpEvent event = (KeyUpEvent)Mockito.mock(KeyUpEvent.class);
        ((TextBox)Mockito.doReturn((Object)"field").when((Object)this.fieldTextBox)).getText();
        this.view.onFieldTextBoxChange(event);
        ((FieldPage)Mockito.verify((Object)this.page)).setEditingCol("field");
    }

    @Test
    public void testSetupBinding() {
        IsWidget isWidget = (IsWidget)Mockito.mock(IsWidget.class);
        Widget widget = (Widget)Mockito.mock(Widget.class);
        ((IsWidget)Mockito.doReturn((Object)widget).when((Object)isWidget)).asWidget();
        this.view.setupBinding(isWidget);
        ((Elemental2DomUtil)Mockito.verify((Object)this.elemental2DomUtil)).removeAllElementChildren((Node)this.bindingFieldContainer);
        ((Elemental2DomUtil)Mockito.verify((Object)this.elemental2DomUtil)).appendWidgetToElement((HTMLElement)this.bindingFieldContainer, widget);
    }

    @Test
    public void testShowFieldBindingWarning() {
        this.view.showFieldBindingWarning();
        Assert.assertFalse((boolean)this.fieldBindingWarning.hidden);
    }

    @Test
    public void testHideFieldBindingWarning() {
        this.view.hideFieldBindingWarning();
        Assert.assertTrue((boolean)this.fieldBindingWarning.hidden);
    }

    @Test
    public void testShowPredicateBindingInfo() {
        this.view.showPredicateBindingInfo();
        Assert.assertFalse((boolean)this.predicateBindingInfo.hidden);
    }

    @Test
    public void testHidePredicateBindingInfo() {
        this.view.hidePredicateBindingInfo();
        Assert.assertTrue((boolean)this.predicateBindingInfo.hidden);
    }

    @Test
    public void testBindingToggleWhenItIsVisible() {
        boolean isVisible = true;
        this.view.bindingToggle(true);
        Assert.assertFalse((boolean)this.bindingContainer.hidden);
    }

    @Test
    public void testBindingToggleWhenItIsNotVisible() {
        boolean isVisible = false;
        this.view.bindingToggle(false);
        Assert.assertTrue((boolean)this.bindingContainer.hidden);
    }
}

