/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashMap;
import java.util.Map;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.MetaDataColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.MetaDataColumnPlugin;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class MetaDataColumnPageTest {
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private MetaDataColumnPlugin plugin;
    @Mock
    private TranslationService translationService;
    private Caller<ValidationService> validationServiceCaller;
    @Mock
    private ValidationService validationService;
    @Mock
    private MetaDataColumnPage.View view;
    @Mock
    private SimplePanel content;
    @InjectMocks
    private MetaDataColumnPage page;
    private static Map<String, Boolean> validationResult;

    public MetaDataColumnPageTest() {
        this.page = new MetaDataColumnPage(this.view, this.translationService, this.validationServiceCaller);
    }

    @BeforeClass
    public static void setupPreferences() {
        HashMap<String, String> preferences = new HashMap<String, String>(){
            {
                this.put("drools.dateformat", "dd/mm/yyyy");
            }
        };
        ApplicationPreferences.setUp((Map)preferences);
        GWTMockUtilities.disarm();
        validationResult = new HashMap<String, Boolean>();
        validationResult.put("metaData", true);
        validationResult.put("*", false);
    }

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.translationService.format("MetaDataColumnPage.MetadataNameEmpty", new Object[0])).thenReturn((Object)"empty");
        Mockito.when((Object)this.translationService.format("MetaDataColumnPage.ThatColumnNameIsAlreadyInUsePleasePickAnother", new Object[0])).thenReturn((Object)"alreadyUsed");
        Mockito.when((Object)this.translationService.format("MetaDataColumnPage.IsNotValidIdentifier", new Object[0])).thenReturn((Object)"isNotValid");
        this.validationServiceCaller = new CallerMock((Object)this.validationService);
        this.page.validationService = this.validationServiceCaller;
        Mockito.when((Object)this.validationService.evaluateJavaIdentifiers((String[])Mockito.any())).thenReturn(validationResult);
    }

    @Test
    public void testIsCompleteWhenMetaDataIsNull() throws Exception {
        Mockito.when((Object)this.plugin.getMetaData()).thenReturn(null);
        this.page.isComplete(Assert::assertFalse);
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view)).showError("empty");
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideError();
    }

    @Test
    public void testIsCompleteWhenMetaDataIsBlank() throws Exception {
        Mockito.when((Object)this.plugin.getMetaData()).thenReturn((Object)"");
        this.page.isComplete(Assert::assertFalse);
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view)).showError("empty");
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideError();
    }

    @Test
    public void testIsCompleteWhenMetaDataIsNotNull() throws Exception {
        Mockito.when((Object)this.plugin.getMetaData()).thenReturn((Object)"metaData");
        Mockito.when((Object)this.presenter.isMetaDataUnique("metaData")).thenReturn((Object)true);
        this.page.isComplete(Assert::assertTrue);
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showError(Mockito.anyString());
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view)).hideError();
    }

    @Test
    public void testGetMetadata() throws Exception {
        this.page.getMetadata();
        ((MetaDataColumnPlugin)Mockito.verify((Object)this.plugin)).getMetaData();
    }

    @Test
    public void testColumnNameIsAlreadyInUseError() throws Exception {
        Mockito.when((Object)this.plugin.getMetaData()).thenReturn((Object)"metaData");
        Mockito.when((Object)this.presenter.isMetaDataUnique("metaData")).thenReturn((Object)false);
        this.page.isComplete(Assert::assertFalse);
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view)).showError("alreadyUsed");
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideError();
    }

    @Test
    public void testShowJustOneErrorEmptyAndNotUnique() throws Exception {
        Mockito.when((Object)this.plugin.getMetaData()).thenReturn((Object)"");
        Mockito.when((Object)this.presenter.isMetaDataUnique("")).thenReturn((Object)false);
        this.page.isComplete(Assert::assertFalse);
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view)).showError("empty");
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showError("isNotValid");
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showError("alreadyUsed");
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideError();
    }

    @Test
    public void testShowJustOneErrorNotEmptyNotUnique() throws Exception {
        Mockito.when((Object)this.plugin.getMetaData()).thenReturn((Object)"a");
        Mockito.when((Object)this.presenter.isMetaDataUnique("a")).thenReturn((Object)false);
        this.page.isComplete(Assert::assertFalse);
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showError("empty");
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showError("isNotValid");
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view)).showError("alreadyUsed");
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideError();
    }

    @Test
    public void testInvalidIdentifier() throws Exception {
        Mockito.when((Object)this.plugin.getMetaData()).thenReturn((Object)"*");
        Mockito.when((Object)this.presenter.isMetaDataUnique("*")).thenReturn((Object)true);
        this.page.isComplete(Assert::assertFalse);
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view)).showError("isNotValid");
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).hideError();
    }

    @Test
    public void testSetMetadata() throws Exception {
        String metaData = "metaData";
        this.page.setMetadata("metaData");
        ((MetaDataColumnPlugin)Mockito.verify((Object)this.plugin)).setMetaData("metaData");
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "MetaDataColumnPage.AddNewMetadata";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("MetaDataColumnPage.AddNewMetadata", new Object[0])).thenReturn((Object)"Title");
        String title = this.page.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testPrepareView() throws Exception {
        this.page.prepareView();
        ((MetaDataColumnPage.View)Mockito.verify((Object)this.view)).init((Object)this.page);
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.page.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }
}

