/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.junit.GWTMockUtilities;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import com.google.gwtmockito.WithClassesToStub;
import java.util.Collections;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.RuleModellerPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.BRLActionColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.BRLConditionColumnPlugin;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModeller;
import org.drools.workbench.screens.guided.rule.client.editor.RuleModellerConfiguration;
import org.drools.workbench.screens.guided.rule.client.editor.plugin.RuleModellerActionPlugin;
import org.drools.workbench.screens.guided.rule.client.resources.images.GuidedRuleEditorImages508;
import org.drools.workbench.screens.guided.template.client.editor.TemplateModellerWidgetFactory;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
@WithClassesToStub(value={GuidedRuleEditorImages508.class, FlexTable.class})
public class RuleModellerPageTest {
    @Mock
    private BRLActionColumnPlugin brlActionPlugin;
    @Mock
    private BRLConditionColumnPlugin brlConditionPlugin;
    @Mock
    private RuleModellerPage.View view;
    @Mock
    private SimplePanel content;
    @Mock
    private TranslationService translationService;
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private RuleModellerActionPlugin ruleModellerActionPlugin;
    @InjectMocks
    private RuleModellerPage<BRLActionColumnPlugin> brlActionPage;
    @InjectMocks
    private RuleModellerPage<BRLConditionColumnPlugin> brlConditionPage;

    public RuleModellerPageTest() {
        this.brlActionPage = (RuleModellerPage)Mockito.spy((Object)new RuleModellerPage(this.view, this.translationService));
        this.brlConditionPage = (RuleModellerPage)Mockito.spy((Object)new RuleModellerPage(this.view, this.translationService));
    }

    @BeforeClass
    public static void setupPreferences() {
        GWTMockUtilities.disarm();
    }

    @Before
    public void setup() {
        Mockito.when((Object)this.brlActionPage.plugin()).thenReturn((Object)this.brlActionPlugin);
        Mockito.when((Object)this.brlConditionPage.plugin()).thenReturn((Object)this.brlConditionPlugin);
    }

    @Test
    public void testIsCompleteWhenRuleModellerPageIsCompleted() throws Exception {
        Mockito.when((Object)this.brlActionPlugin.isRuleModellerPageCompleted()).thenReturn((Object)true);
        this.brlActionPage.isComplete(Assert::assertTrue);
    }

    @Test
    public void testIsCompleteWhenRuleModellerPageIsNotCompleted() throws Exception {
        Mockito.when((Object)this.brlActionPlugin.isRuleModellerPageCompleted()).thenReturn((Object)false);
        this.brlActionPage.isComplete(Assert::assertFalse);
    }

    @Test
    public void testRuleModeller() throws Exception {
        Mockito.when((Object)this.brlActionPlugin.getRuleModel()).thenReturn((Object)new RuleModel());
        Mockito.when((Object)this.brlActionPlugin.tableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        Mockito.when((Object)this.brlActionPlugin.getRuleModellerActionPlugins()).thenReturn(Collections.singletonList(this.ruleModellerActionPlugin));
        Mockito.when((Object)this.brlActionPlugin.getRuleModellerConfiguration()).thenReturn(Mockito.mock(RuleModellerConfiguration.class));
        Mockito.when((Object)this.presenter.getDataModelOracle()).thenReturn(Mockito.mock(AsyncPackageDataModelOracle.class));
        RuleModeller ruleModeller = this.brlActionPage.ruleModeller();
        Assert.assertNotNull((Object)ruleModeller);
        Assert.assertEquals((Object)this.brlActionPlugin.getRuleModel(), (Object)ruleModeller.getModel());
        Assert.assertEquals(Collections.singletonList(this.ruleModellerActionPlugin), (Object)ruleModeller.getActionPlugins());
        Assert.assertEquals((Object)this.presenter.getDataModelOracle(), (Object)ruleModeller.getDataModelOracle());
        Assert.assertTrue((boolean)(ruleModeller.getWidgetFactory() instanceof TemplateModellerWidgetFactory));
        Assert.assertFalse((boolean)ruleModeller.isReadOnly());
    }

    @Test
    public void testGetTitle() throws Exception {
        String errorKey = "RuleModellerPage.RuleModeller";
        String errorMessage = "Title";
        Mockito.when((Object)this.translationService.format("RuleModellerPage.RuleModeller", new Object[0])).thenReturn((Object)"Title");
        String title = this.brlActionPage.getTitle();
        Assert.assertEquals((Object)"Title", (Object)title);
    }

    @Test
    public void testPrepareViewBrlAction() throws Exception {
        Mockito.when((Object)this.brlActionPlugin.getRuleModel()).thenReturn((Object)new RuleModel());
        Mockito.when((Object)this.brlActionPlugin.tableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        Mockito.when((Object)this.brlActionPlugin.getRuleModellerConfiguration()).thenReturn(Mockito.mock(RuleModellerConfiguration.class));
        this.brlActionPage.prepareView();
        ((RuleModellerPage.View)Mockito.verify((Object)this.view)).init(this.brlActionPage);
        ((RuleModellerPage.View)Mockito.verify((Object)this.view)).setupRuleModellerWidget((RuleModeller)Mockito.any(RuleModeller.class));
        ((RuleModellerPage)Mockito.verify(this.brlActionPage)).markAsViewed();
        ((BRLActionColumnPlugin)Mockito.verify((Object)this.brlActionPlugin)).getRuleModellerDescription();
    }

    @Test
    public void testPrepareViewBrlCondition() throws Exception {
        Mockito.when((Object)this.brlConditionPlugin.getRuleModel()).thenReturn((Object)new RuleModel());
        Mockito.when((Object)this.brlConditionPlugin.tableFormat()).thenReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY);
        Mockito.when((Object)this.brlConditionPlugin.getRuleModellerConfiguration()).thenReturn(Mockito.mock(RuleModellerConfiguration.class));
        this.brlConditionPage.prepareView();
        ((RuleModellerPage.View)Mockito.verify((Object)this.view)).init(this.brlConditionPage);
        ((RuleModellerPage.View)Mockito.verify((Object)this.view)).setupRuleModellerWidget((RuleModeller)Mockito.any(RuleModeller.class));
        ((RuleModellerPage)Mockito.verify(this.brlConditionPage)).markAsViewed();
        ((BRLConditionColumnPlugin)Mockito.verify((Object)this.brlConditionPlugin)).getRuleModellerDescription();
    }

    @Test
    public void testAsWidget() {
        Widget contentWidget = this.brlActionPage.asWidget();
        Assert.assertEquals((Object)contentWidget, (Object)this.content);
    }
}

