/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryActionInsertFactCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionInsertFactWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.BaseDecisionTableColumnPlugin;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActionInsertFactWrapperTest {
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private BaseDecisionTableColumnPlugin plugin;

    @Before
    public void setup() {
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((BaseDecisionTableColumnPlugin)Mockito.doReturn((Object)this.presenter).when((Object)this.plugin)).getPresenter();
    }

    @Test
    public void testNewActionInsertFactWhenTableFormatIsExtendedEntry() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ActionInsertFactWrapper wrapper = new ActionInsertFactWrapper(this.plugin);
        Assert.assertTrue((boolean)(wrapper.getActionCol52() instanceof ActionInsertFactCol52));
    }

    @Test
    public void testNewActionInsertFactWhenTableFormatIsLimitedEntry() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY).when((Object)this.model)).getTableFormat();
        ActionInsertFactWrapper wrapper = new ActionInsertFactWrapper(this.plugin);
        Assert.assertTrue((boolean)(wrapper.getActionCol52() instanceof LimitedEntryActionInsertFactCol52));
    }

    @Test
    public void testCloneALimitedEntryActionInsert() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY).when((Object)this.model)).getTableFormat();
        LimitedEntryActionInsertFactCol52 column = new LimitedEntryActionInsertFactCol52();
        column.setFactField("factField");
        column.setBoundName("boundName");
        column.setValueList("valueList");
        column.setHeader("header");
        column.setInsertLogical(false);
        column.setDefaultValue(new DTCellValue52("defaultValue"));
        column.setFactType("factType");
        column.setHideColumn(false);
        column.setType("type");
        column.setValue(new DTCellValue52("value"));
        ActionInsertFactWrapper wrapper = new ActionInsertFactWrapper(this.plugin, (ActionInsertFactCol52)column);
        ActionInsertFactCol52 clone = wrapper.getActionCol52();
        Assert.assertEquals((Object)"factField", (Object)column.getFactField());
        Assert.assertEquals((Object)"boundName", (Object)column.getBoundName());
        Assert.assertEquals((Object)"valueList", (Object)column.getValueList());
        Assert.assertEquals((Object)"header", (Object)column.getHeader());
        Assert.assertEquals((Object)false, (Object)column.isInsertLogical());
        Assert.assertEquals((Object)new DTCellValue52("defaultValue"), (Object)column.getDefaultValue());
        Assert.assertEquals((Object)"factType", (Object)column.getFactType());
        Assert.assertEquals((Object)false, (Object)column.isHideColumn());
        Assert.assertEquals((Object)"type", (Object)column.getType());
        Assert.assertEquals((Object)new DTCellValue52("value"), (Object)column.getValue());
        Assert.assertNotSame((Object)column, (Object)clone);
    }

    @Test
    public void testCloneAnActionInsert() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ActionInsertFactCol52 column = new ActionInsertFactCol52();
        column.setFactField("factField");
        column.setBoundName("boundName");
        column.setValueList("valueList");
        column.setHeader("header");
        column.setInsertLogical(false);
        column.setDefaultValue(new DTCellValue52("defaultValue"));
        column.setFactType("factType");
        column.setHideColumn(false);
        column.setType("type");
        ActionInsertFactWrapper wrapper = new ActionInsertFactWrapper(this.plugin, column);
        ActionInsertFactCol52 clone = wrapper.getActionCol52();
        Assert.assertEquals((Object)"factField", (Object)column.getFactField());
        Assert.assertEquals((Object)"boundName", (Object)column.getBoundName());
        Assert.assertEquals((Object)"valueList", (Object)column.getValueList());
        Assert.assertEquals((Object)"header", (Object)column.getHeader());
        Assert.assertEquals((Object)false, (Object)column.isInsertLogical());
        Assert.assertEquals((Object)new DTCellValue52("defaultValue"), (Object)column.getDefaultValue());
        Assert.assertEquals((Object)"factType", (Object)column.getFactType());
        Assert.assertEquals((Object)false, (Object)column.isHideColumn());
        Assert.assertEquals((Object)"type", (Object)column.getType());
        Assert.assertNotSame((Object)column, (Object)clone);
    }
}

