/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryActionSetFieldCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionSetFactWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.BaseDecisionTableColumnPlugin;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActionSetFactWrapperTest {
    @Mock
    private GuidedDecisionTableView.Presenter presenter;
    @Mock
    private GuidedDecisionTable52 model;
    @Mock
    private BaseDecisionTableColumnPlugin plugin;

    @Before
    public void setup() {
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((BaseDecisionTableColumnPlugin)Mockito.doReturn((Object)this.presenter).when((Object)this.plugin)).getPresenter();
    }

    @Test
    public void testNewActionInsertFactWhenTableFormatIsExtendedEntry() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((BaseDecisionTableColumnPlugin)Mockito.doReturn((Object)this.presenter).when((Object)this.plugin)).getPresenter();
        ActionSetFactWrapper wrapper = new ActionSetFactWrapper(this.plugin);
        Assert.assertTrue((boolean)(wrapper.getActionCol52() instanceof ActionSetFieldCol52));
    }

    @Test
    public void testNewActionInsertFactWhenTableFormatIsLimitedEntry() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY).when((Object)this.model)).getTableFormat();
        ((GuidedDecisionTableView.Presenter)Mockito.doReturn((Object)this.model).when((Object)this.presenter)).getModel();
        ((BaseDecisionTableColumnPlugin)Mockito.doReturn((Object)this.presenter).when((Object)this.plugin)).getPresenter();
        ActionSetFactWrapper wrapper = new ActionSetFactWrapper(this.plugin);
        Assert.assertTrue((boolean)(wrapper.getActionCol52() instanceof LimitedEntryActionSetFieldCol52));
    }

    @Test
    public void testCloneALimitedEntryActionInsert() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.LIMITED_ENTRY).when((Object)this.model)).getTableFormat();
        LimitedEntryActionSetFieldCol52 column = new LimitedEntryActionSetFieldCol52();
        column.setFactField("factField");
        column.setBoundName("boundName");
        column.setValueList("valueList");
        column.setHeader("header");
        column.setUpdate(false);
        column.setDefaultValue(new DTCellValue52("defaultValue"));
        column.setHideColumn(false);
        column.setType("type");
        column.setValue(new DTCellValue52("value"));
        ActionSetFactWrapper wrapper = new ActionSetFactWrapper(this.plugin, (ActionSetFieldCol52)column);
        ActionSetFieldCol52 clone = wrapper.getActionCol52();
        Assert.assertEquals((Object)"factField", (Object)column.getFactField());
        Assert.assertEquals((Object)"boundName", (Object)column.getBoundName());
        Assert.assertEquals((Object)"valueList", (Object)column.getValueList());
        Assert.assertEquals((Object)"header", (Object)column.getHeader());
        Assert.assertEquals((Object)false, (Object)column.isUpdate());
        Assert.assertEquals((Object)new DTCellValue52("defaultValue"), (Object)column.getDefaultValue());
        Assert.assertEquals((Object)false, (Object)column.isHideColumn());
        Assert.assertEquals((Object)"type", (Object)column.getType());
        Assert.assertEquals((Object)new DTCellValue52("value"), (Object)column.getValue());
        Assert.assertNotSame((Object)column, (Object)clone);
    }

    @Test
    public void testCloneAnActionInsert() throws Exception {
        ((GuidedDecisionTable52)Mockito.doReturn((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY).when((Object)this.model)).getTableFormat();
        ActionSetFieldCol52 column = new ActionSetFieldCol52();
        column.setFactField("factField");
        column.setBoundName("boundName");
        column.setValueList("valueList");
        column.setHeader("header");
        column.setUpdate(false);
        column.setDefaultValue(new DTCellValue52("defaultValue"));
        column.setHideColumn(false);
        column.setType("type");
        ActionSetFactWrapper wrapper = new ActionSetFactWrapper(this.plugin, column);
        ActionSetFieldCol52 clone = wrapper.getActionCol52();
        Assert.assertEquals((Object)"factField", (Object)column.getFactField());
        Assert.assertEquals((Object)"boundName", (Object)column.getBoundName());
        Assert.assertEquals((Object)"valueList", (Object)column.getValueList());
        Assert.assertEquals((Object)"header", (Object)column.getHeader());
        Assert.assertEquals((Object)false, (Object)column.isUpdate());
        Assert.assertEquals((Object)new DTCellValue52("defaultValue"), (Object)column.getDefaultValue());
        Assert.assertEquals((Object)false, (Object)column.isHideColumn());
        Assert.assertEquals((Object)"type", (Object)column.getType());
        Assert.assertNotSame((Object)column, (Object)clone);
    }
}

