/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.table.pages;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.ActionSetFieldsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.ActionSetFieldsPageView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=GwtMockitoTestRunner.class)
public class ActionSetFieldsPageTest {
    private GuidedDecisionTable52 model;
    @Captor
    private ArgumentCaptor<List<Pattern52>> patternsCaptor;
    @Mock
    private ActionSetFieldsPageView actionSetFieldsPageView;
    @InjectMocks
    private ActionSetFieldsPage actionSetFieldsPage;

    @Before
    public void setUp() throws Exception {
        this.actionSetFieldsPage.model = this.model = new GuidedDecisionTable52();
    }

    @Test
    public void testPrepareViewNoPatterns() throws Exception {
        this.actionSetFieldsPage.prepareView();
        ((ActionSetFieldsPageView)Mockito.verify((Object)this.actionSetFieldsPageView)).setAvailablePatterns(Collections.emptyList());
    }

    @Test
    public void testPrepareViewPatternsAvailableButNoConditionSpecified() throws Exception {
        this.model.setConditionPatterns(Collections.singletonList(new Pattern52()));
        this.actionSetFieldsPage.prepareView();
        ((ActionSetFieldsPageView)Mockito.verify((Object)this.actionSetFieldsPageView)).setAvailablePatterns(Collections.emptyList());
    }

    @Test
    public void testPrepareView() throws Exception {
        Pattern52 pattern = new Pattern52(){
            {
                this.setFactType("Person");
                this.setBoundName("p");
                this.setChildColumns(Collections.singletonList(new ConditionCol52()));
            }
        };
        this.model.setConditionPatterns(Collections.singletonList(pattern));
        this.actionSetFieldsPage.prepareView();
        ((ActionSetFieldsPageView)Mockito.verify((Object)this.actionSetFieldsPageView)).setAvailablePatterns((List)this.patternsCaptor.capture());
        Assert.assertEquals((long)1L, (long)((List)this.patternsCaptor.getValue()).size());
        Assert.assertEquals((Object)pattern, ((List)this.patternsCaptor.getValue()).get(0));
    }
}

