/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.workbench.screens.guided.dtable.client.widget.table;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

@RunWith(MockitoJUnitRunner.class)
public class AccessTest {

    private GuidedDecisionTablePresenter.Access access;

    @Before
    public void setUp() throws Exception {
        access = new GuidedDecisionTablePresenter.Access();
    }

    @Test
    public void testIsEditableNotLocked() throws Exception {
        access.setLock(GuidedDecisionTablePresenter.Access.LockedBy.NOBODY);

        assertTrue(access.isEditable());
    }

    @Test
    public void testIsEditableLockedByCurrentUser() throws Exception {
        access.setLock(GuidedDecisionTablePresenter.Access.LockedBy.CURRENT_USER);

        assertTrue(access.isEditable());
    }

    @Test
    public void testIsEditableLockedByOtherUser() throws Exception {
        access.setLock(GuidedDecisionTablePresenter.Access.LockedBy.OTHER_USER);

        assertFalse(access.isEditable());
    }

    @Test
    public void testIsEditableReadOnlyTableLockedByCurrentUser() throws Exception {
        access.setReadOnly(true);
        access.setLock(GuidedDecisionTablePresenter.Access.LockedBy.CURRENT_USER);

        assertFalse(access.isEditable());
    }
}
