/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns;

import com.ait.lienzo.client.core.shape.Text;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.BaseSingletonDOMElementUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.ConsumerFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.listbox.ListBoxDOMElement;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.listbox.ListBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.DependentEnumsUtilities;
import org.gwtbootstrap3.client.ui.ListBox;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;

public class EnumMultiSelectUiColumn
extends BaseSingletonDOMElementUiColumn<String, ListBox, ListBoxDOMElement<String, ListBox>, ListBoxSingletonDOMElementFactory<String, ListBox>> {
    private final String factType;
    private final String factField;
    private final GuidedDecisionTableView.Presenter presenter;

    public EnumMultiSelectUiColumn(List<GridColumn.HeaderMetaData> headerMetaData, double width, boolean isResizable, boolean isVisible, GuidedDecisionTablePresenter.Access access, ListBoxSingletonDOMElementFactory<String, ListBox> factory, final GuidedDecisionTableView.Presenter presenter, final String factType, final String factField) {
        super(headerMetaData, new BaseSingletonDOMElementUiColumn.CellRenderer<String, ListBox, ListBoxDOMElement<String, ListBox>>(factory){

            @Override
            protected void doRenderCellContent(final Text t, final String value, GridBodyCellRenderContext context) {
                presenter.getEnumLookups(factType, factField, new DependentEnumsUtilities.Context(context.getRowIndex(), context.getColumnIndex()), new Callback<Map<String, String>>(){

                    public void callback(Map<String, String> enumLookups) {
                        t.setText(this.makeLabel(value, enumLookups));
                    }

                    private String makeLabel(String value2, Map<String, String> enumLookups) {
                        List<String> splitValues = Arrays.asList(value2.split(","));
                        StringBuilder sb = new StringBuilder();
                        boolean first = true;
                        for (int i = 0; i < splitValues.size(); ++i) {
                            String splitValue = splitValues.get(i);
                            if (!enumLookups.containsKey(splitValue)) continue;
                            if (first) {
                                sb.append(enumLookups.get(splitValue));
                                first = false;
                                continue;
                            }
                            sb.append(",").append(enumLookups.get(splitValue));
                        }
                        return sb.toString();
                    }
                });
            }
        }, width, isResizable, isVisible, access, factory);
        this.presenter = presenter;
        this.factType = factType;
        this.factField = factField;
    }

    @Override
    public void doEdit(GridCell<String> cell, GridBodyCellRenderContext context, Consumer<GridCellValue<String>> callback) {
        String value = this.extractValue(cell);
        this.presenter.getEnumLookups(this.factType, this.factField, new DependentEnumsUtilities.Context(context.getRowIndex(), context.getColumnIndex()), (Callback<Map<String, String>>)((Callback)enumLookups -> ((ListBoxSingletonDOMElementFactory)this.factory).attachDomElement(context, e -> {
            ListBox widget = (ListBox)e.getWidget();
            for (Map.Entry lookup : enumLookups.entrySet()) {
                widget.addItem((String)lookup.getValue(), (String)lookup.getKey());
            }
            List<String> values = Arrays.asList(value.split(","));
            for (int i = 0; i < widget.getItemCount(); ++i) {
                widget.setItemSelected(i, values.contains(widget.getValue(i)));
            }
            ((ListBoxSingletonDOMElementFactory)this.factory).toWidget(cell, widget);
        }, ConsumerFactory.makeOnDisplayListBoxCallback())));
    }

    private String extractValue(GridCell<String> cell) {
        if (cell == null || cell.getValue() == null || cell.getValue().getValue() == null) {
            return "";
        }
        return (String)cell.getValue().getValue();
    }
}

