/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control;

import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.AttributeColumnConfigRowView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.html.Span;

@Dependent
public class AttributeColumnConfigRow {
    @Inject
    protected AttributeColumnConfigRowView view;
    private CheckBox useRowNumberCheckBox;
    private CheckBox reverseOrderCheckBox;
    private CheckBox hideColumnCheckBox;

    public void init(AttributeCol52 attributeColumn, GuidedDecisionTableModellerView.Presenter presenter) {
        this.view.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.view.addColumnLabel(attributeColumn);
        AttributeCol52 originalColumn = attributeColumn;
        if (attributeColumn.getAttribute().equals("salience")) {
            this.useRowNumberCheckBox = this.view.addUseRowNumberCheckBox(attributeColumn, presenter.isActiveDecisionTableEditable(), event -> {
                AttributeCol52 editedColumn = originalColumn.cloneColumn();
                editedColumn.setUseRowNumber(this.useRowNumberCheckBox.getValue().booleanValue());
                this.reverseOrderCheckBox.setEnabled(this.useRowNumberCheckBox.getValue().booleanValue());
                try {
                    Optional<GuidedDecisionTableView.Presenter> dtPresenter = presenter.getActiveDecisionTable();
                    if (dtPresenter.isPresent()) {
                        dtPresenter.get().updateColumn(originalColumn, editedColumn);
                    }
                }
                catch (ModelSynchronizer.VetoException veto) {
                    presenter.getView().showGenericVetoMessage();
                }
            });
            this.view.add((Widget)new Span("("));
            this.reverseOrderCheckBox = this.view.addReverseOrderCheckBox(attributeColumn, presenter.isActiveDecisionTableEditable(), event -> {
                AttributeCol52 editedColumn = originalColumn.cloneColumn();
                editedColumn.setReverseOrder(this.reverseOrderCheckBox.getValue().booleanValue());
                try {
                    Optional<GuidedDecisionTableView.Presenter> dtPresenter = presenter.getActiveDecisionTable();
                    if (dtPresenter.isPresent()) {
                        dtPresenter.get().updateColumn(originalColumn, editedColumn);
                    }
                }
                catch (ModelSynchronizer.VetoException veto) {
                    presenter.getView().showGenericVetoMessage();
                }
            });
            this.view.add((Widget)new Span(")"));
        }
        this.view.addDefaultValue(attributeColumn, presenter.isActiveDecisionTableEditable(), event -> {
            AttributeCol52 editedColumn = originalColumn.cloneColumn();
            editedColumn.setDefaultValue(event.getEditedDefaultValue());
            try {
                Optional<GuidedDecisionTableView.Presenter> dtPresenter = presenter.getActiveDecisionTable();
                if (dtPresenter.isPresent()) {
                    dtPresenter.get().updateColumn(originalColumn, editedColumn);
                }
            }
            catch (ModelSynchronizer.VetoException veto) {
                presenter.getView().showGenericVetoMessage();
            }
        });
        this.hideColumnCheckBox = this.view.addHideColumnCheckBox(attributeColumn, event -> {
            AttributeCol52 editedColumn = originalColumn.cloneColumn();
            editedColumn.setHideColumn(this.hideColumnCheckBox.getValue().booleanValue());
            try {
                Optional<GuidedDecisionTableView.Presenter> dtPresenter = presenter.getActiveDecisionTable();
                if (dtPresenter.isPresent()) {
                    dtPresenter.get().updateColumn(originalColumn, editedColumn);
                }
            }
            catch (ModelSynchronizer.VetoException veto) {
                presenter.getView().showGenericVetoMessage();
            }
        });
        this.addRemoveAttributeButton(attributeColumn, presenter);
    }

    private void addRemoveAttributeButton(AttributeCol52 attributeColumn, GuidedDecisionTableModellerView.Presenter presenter) {
        boolean isEditable = presenter.isActiveDecisionTableEditable();
        this.view.addRemoveAttributeButton(() -> {
            try {
                Optional<GuidedDecisionTableView.Presenter> dtPresenter = presenter.getActiveDecisionTable();
                if (dtPresenter.isPresent()) {
                    dtPresenter.get().deleteColumn(attributeColumn);
                }
            }
            catch (ModelSynchronizer.VetoException veto) {
                presenter.getView().showGenericVetoMessage();
            }
        }, isEditable);
    }

    public Widget getView() {
        return this.view;
    }
}

