/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.datepicker;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Date;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.datepicker.DatePickerDOMElement;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.dom.textbox.SingleValueSingletonDOMElementFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard.KeyDownHandlerDatePicker;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.util.TimeZoneUtils;
import org.uberfire.ext.widgets.common.client.common.DatePicker;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.HasSingletonDOMElementResource;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;

public class DatePickerSingletonDOMElementFactory
extends SingleValueSingletonDOMElementFactory<Date, DatePicker, DatePickerDOMElement> {
    private static final String droolsDateFormat = ApplicationPreferences.getDroolsDateFormat();
    private static final DateTimeFormat dateTimeFormat = DateTimeFormat.getFormat((String)droolsDateFormat);

    public DatePickerSingletonDOMElementFactory(GridLienzoPanel gridPanel, GridLayer gridLayer, GuidedDecisionTableView gridWidget) {
        super(gridPanel, gridLayer, gridWidget);
    }

    public DatePicker createWidget() {
        return new DatePicker(){

            protected void onLoad() {
                super.onLoad();
                if (this.getElement().getParentElement() != null) {
                    this.getElement().getParentElement().getStyle().setPosition(Style.Position.ABSOLUTE);
                }
            }
        };
    }

    public DatePickerDOMElement createDomElement(GridLayer gridLayer, GridWidget gridWidget, GridBodyCellRenderContext context) {
        this.widget = this.createWidget();
        this.e = new DatePickerDOMElement((DatePicker)this.widget, gridLayer, gridWidget);
        ((DatePicker)this.widget).addChangeDateHandler(e -> this.doValueUpdate());
        ((DatePicker)this.widget).addDomHandler((EventHandler)new KeyDownHandlerDatePicker(this.gridPanel, gridLayer, gridWidget, (HasSingletonDOMElementResource)this, context), KeyDownEvent.getType());
        return (DatePickerDOMElement)this.e;
    }

    private void doValueUpdate() {
        this.flush();
        this.destroyResources();
        this.gridLayer.batch();
        this.gridPanel.setFocus(true);
    }

    @Override
    public String convert(Date value) {
        return dateTimeFormat.format(value);
    }

    @Override
    public Date convert(String value) {
        try {
            return dateTimeFormat.parse(value);
        }
        catch (IllegalArgumentException iae) {
            return new Date();
        }
    }

    protected Date getValue() {
        if (this.getWidget() != null) {
            return TimeZoneUtils.convertToServerTimeZone((Date)this.getWidget().getValue());
        }
        return null;
    }

    DatePicker getWidget() {
        return (DatePicker)this.widget;
    }
}

