/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.keyboard;

import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import java.util.Optional;
import java.util.function.Function;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.HasSingletonDOMElementResource;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;

public class KeyDownHandlerCommon
implements KeyDownHandler {
    protected final GridLienzoPanel gridPanel;
    protected final GridLayer gridLayer;
    protected final GridWidget gridWidget;
    protected final HasSingletonDOMElementResource gridCell;
    protected final GridBodyCellRenderContext context;

    public KeyDownHandlerCommon(GridLienzoPanel gridPanel, GridLayer gridLayer, GridWidget gridWidget, HasSingletonDOMElementResource gridCell, GridBodyCellRenderContext context) {
        this.gridPanel = gridPanel;
        this.gridLayer = gridLayer;
        this.gridWidget = gridWidget;
        this.gridCell = gridCell;
        this.context = context;
    }

    public void onKeyDown(KeyDownEvent e) {
        int keyCode = e.getNativeKeyCode();
        boolean isShiftKeyDown = e.isShiftKeyDown();
        switch (keyCode) {
            case 9: 
            case 13: {
                this.gridCell.flush();
                this.moveSelection(keyCode, isShiftKeyDown);
                e.preventDefault();
            }
            case 27: {
                this.gridCell.destroyResources();
                this.gridPanel.setFocus(true);
                this.gridLayer.batch();
            }
        }
        e.stopPropagation();
    }

    protected void moveSelection(int keyCode, boolean isShiftKeyDown) {
        Optional<Integer> dx = this.getDelta(keyCode, 9, isShiftKeyDown);
        Optional<Integer> dy = this.getDelta(keyCode, 13, isShiftKeyDown);
        if (dx.isPresent() || dy.isPresent()) {
            Function<Integer, Integer> boundsX = this.getBoundsXCheck(isShiftKeyDown);
            Function<Integer, Integer> boundsY = this.getBoundsYCheck(isShiftKeyDown);
            this.moveSelection(dx, dy, boundsX, boundsY);
        }
    }

    private Optional<Integer> getDelta(int keyCode, int requiredKeyCode, boolean isShiftKeyDown) {
        if (keyCode == requiredKeyCode) {
            return Optional.of(isShiftKeyDown ? -1 : 1);
        }
        return Optional.empty();
    }

    private Function<Integer, Integer> getBoundsXCheck(boolean isShiftKeyDown) {
        if (isShiftKeyDown) {
            return x -> x < 0 ? 0 : x;
        }
        int maxUiColumnIndex = this.gridWidget.getModel().getColumnCount() - 1;
        return x -> x > maxUiColumnIndex ? maxUiColumnIndex : x;
    }

    private Function<Integer, Integer> getBoundsYCheck(boolean isShiftKeyDown) {
        if (isShiftKeyDown) {
            return y -> y < 0 ? 0 : y;
        }
        int maxUiRowIndex = this.gridWidget.getModel().getRowCount() - 1;
        return y -> y > maxUiRowIndex ? maxUiRowIndex : y;
    }

    protected void moveSelection(Optional<Integer> dx, Optional<Integer> dy, Function<Integer, Integer> boundsX, Function<Integer, Integer> boundsY) {
        int uiRowIndex = boundsY.apply(this.context.getRowIndex() + dy.orElse(0));
        int uiColumnIndex = boundsX.apply(this.context.getColumnIndex() + dx.orElse(0));
        this.gridWidget.selectCell(uiRowIndex, uiColumnIndex, false, false);
    }
}

