/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiffImpl;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryBRLConditionColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.Synchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseColumnSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizer;

@Dependent
public class LimitedEntryBRLConditionColumnSynchronizer
extends BaseColumnSynchronizer<BaseColumnSynchronizer.ColumnMetaData, BaseColumnSynchronizer.ColumnMetaData, BaseColumnSynchronizer.ColumnMetaData> {
    @Override
    public int priority() {
        return 4;
    }

    @Override
    public boolean handlesAppend(Synchronizer.MetaData metaData) throws ModelSynchronizer.VetoException {
        return this.handlesUpdate(metaData);
    }

    @Override
    public void append(BaseColumnSynchronizer.ColumnMetaData metaData) throws ModelSynchronizer.VetoException {
        if (!this.handlesAppend(metaData)) {
            return;
        }
        LimitedEntryBRLConditionColumn column = (LimitedEntryBRLConditionColumn)metaData.getColumn();
        this.model.getConditions().add(column);
        this.synchroniseAppendColumn((BaseColumn)column);
    }

    @Override
    public boolean handlesUpdate(Synchronizer.MetaData metaData) throws ModelSynchronizer.VetoException {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof LimitedEntryBRLConditionColumn;
    }

    @Override
    public List<BaseColumnFieldDiff> update(BaseColumnSynchronizer.ColumnMetaData originalMetaData, BaseColumnSynchronizer.ColumnMetaData editedMetaData) throws ModelSynchronizer.VetoException {
        if (!this.handlesUpdate(originalMetaData) || !this.handlesUpdate(editedMetaData)) {
            return Collections.emptyList();
        }
        LimitedEntryBRLConditionColumn originalColumn = (LimitedEntryBRLConditionColumn)originalMetaData.getColumn();
        LimitedEntryBRLConditionColumn editedColumn = (LimitedEntryBRLConditionColumn)editedMetaData.getColumn();
        List diffs = originalColumn.diff((BaseColumn)editedColumn);
        this.update(originalColumn, editedColumn);
        boolean isHideUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", (List)diffs);
        boolean isHeaderUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", (List)diffs);
        if (isHideUpdated) {
            this.setColumnVisibility((BaseColumn)originalColumn, originalColumn.isHideColumn());
        }
        if (isHeaderUpdated) {
            this.setColumnHeader((BaseColumn)originalColumn, originalColumn.getHeader());
        }
        return diffs;
    }

    @Override
    public boolean handlesDelete(Synchronizer.MetaData metaData) throws ModelSynchronizer.VetoException {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof LimitedEntryBRLConditionColumn;
    }

    @Override
    public void delete(BaseColumnSynchronizer.ColumnMetaData metaData) throws ModelSynchronizer.VetoException {
        if (!this.handlesDelete(metaData)) {
            return;
        }
        LimitedEntryBRLConditionColumn column = (LimitedEntryBRLConditionColumn)metaData.getColumn();
        int columnIndex = this.model.getExpandedColumns().indexOf(column);
        this.model.getConditions().remove(column);
        this.synchroniseDeleteColumn(columnIndex);
    }

    @Override
    public boolean handlesMoveColumnsTo(List<? extends Synchronizer.MetaData> metaData) throws ModelSynchronizer.VetoException {
        for (Synchronizer.MetaData metaData2 : metaData) {
            if (!(metaData2 instanceof BaseSynchronizer.MoveColumnToMetaData)) {
                return false;
            }
            Object column = ((BaseSynchronizer.MoveColumnToMetaData)metaData2).getColumn();
            if (column instanceof LimitedEntryBRLConditionColumn) continue;
            return false;
        }
        return metaData.size() == 1;
    }

    @Override
    public void moveColumnsTo(List<BaseSynchronizer.MoveColumnToMetaData> metaData) throws ModelSynchronizer.VetoException {
        if (!this.handlesMoveColumnsTo(metaData)) {
            return;
        }
        BaseSynchronizer.MoveColumnToMetaData md = metaData.get(0);
        LimitedEntryBRLConditionColumn modelColumn = (LimitedEntryBRLConditionColumn)md.getColumn();
        List modelConditionColumns = this.model.getConditions();
        int modelConditionColumnCount = modelConditionColumns.size();
        if (modelConditionColumnCount == 0) {
            throw new ModelSynchronizer.MoveVetoException();
        }
        List allModelColumns = this.model.getExpandedColumns();
        int minColumnIndex = allModelColumns.indexOf(modelConditionColumns.get(0));
        int maxColumnIndex = allModelColumns.indexOf(modelConditionColumns.get(modelConditionColumnCount - 1));
        int targetColumnIndex = md.getTargetColumnIndex();
        int sourceColumnIndex = md.getSourceColumnIndex();
        if (targetColumnIndex < minColumnIndex || targetColumnIndex > maxColumnIndex) {
            throw new ModelSynchronizer.MoveVetoException();
        }
        this.moveModelData(targetColumnIndex, sourceColumnIndex, sourceColumnIndex);
        modelConditionColumns.remove(modelColumn);
        modelConditionColumns.add(targetColumnIndex - minColumnIndex, modelColumn);
    }

    private void update(LimitedEntryBRLConditionColumn originalColumn, LimitedEntryBRLConditionColumn editedColumn) {
        originalColumn.setHeader(editedColumn.getHeader());
        originalColumn.setDefaultValue(editedColumn.getDefaultValue());
        originalColumn.setHideColumn(editedColumn.isHideColumn());
        originalColumn.setDefinition(editedColumn.getDefinition());
    }
}

