/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.cell.GridWidgetCellFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.PrioritySynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.SalienceSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;

public class SystemControlledColumnValuesSynchronizer {
    private final GuidedDecisionTable52 model;
    private final GuidedDecisionTableUiModel uiModel;
    private final GridWidgetCellFactory gridWidgetCellFactory;
    private final CellUtilities cellUtilities;
    private final ColumnUtilities columnUtilities;
    private final SalienceSynchronizer salienceSynchronizer;
    private final PrioritySynchronizer prioritySynchronizer;

    public SystemControlledColumnValuesSynchronizer(GuidedDecisionTable52 model, GuidedDecisionTableUiModel uiModel, GridWidgetCellFactory gridWidgetCellFactory, CellUtilities cellUtilities, ColumnUtilities columnUtilities) {
        this.model = model;
        this.uiModel = uiModel;
        this.gridWidgetCellFactory = gridWidgetCellFactory;
        this.cellUtilities = cellUtilities;
        this.columnUtilities = columnUtilities;
        this.salienceSynchronizer = new SalienceSynchronizer(model, uiModel, gridWidgetCellFactory, cellUtilities, columnUtilities);
        this.prioritySynchronizer = new PrioritySynchronizer(model, uiModel, gridWidgetCellFactory, cellUtilities, columnUtilities);
    }

    public void updateSystemControlledColumnValues() {
        this.updateSystemControlledColumnValues(this.prioritySynchronizer::update);
    }

    private void updateSystemControlledColumnValues(PostSyncOperation postSyncOperation) {
        for (BaseColumn column : this.model.getExpandedColumns()) {
            AttributeCol52 attrCol;
            if (column instanceof RowNumberCol52) {
                this.updateRowNumberColumnValues((RowNumberCol52)column, postSyncOperation);
                continue;
            }
            if (!(column instanceof AttributeCol52) || !(attrCol = (AttributeCol52)column).getAttribute().equals("salience")) continue;
            this.salienceSynchronizer.updateSalienceColumnValues(attrCol);
        }
    }

    private void updateRowNumberColumnValues(RowNumberCol52 modelColumn, PostSyncOperation postSyncOperation) {
        PrioritySynchronizer.RowNumberChanges rowNumberChanges = new PrioritySynchronizer.RowNumberChanges();
        int iModelColumn = this.model.getExpandedColumns().indexOf(modelColumn);
        for (int rowNumber = 0; rowNumber < this.model.getData().size(); ++rowNumber) {
            List modelRow = (List)this.model.getData().get(rowNumber);
            DTCellValue52 modelCell = (DTCellValue52)modelRow.get(iModelColumn);
            int oldRowNumber = (Integer)modelCell.getNumericValue();
            int newRowNumber = rowNumber + 1;
            rowNumberChanges.put(oldRowNumber, newRowNumber);
            modelCell.setNumericValue(Integer.valueOf(newRowNumber));
            this.uiModel.setCellValueInternal(rowNumber, iModelColumn, (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(modelCell, (BaseColumn)modelColumn, this.cellUtilities, this.columnUtilities));
        }
        postSyncOperation.execute(iModelColumn, rowNumberChanges);
    }

    public void deleteRow(int rowIndex) {
        this.prioritySynchronizer.deleteRow(rowIndex);
        this.updateSystemControlledColumnValues((a, b) -> {});
    }

    public void insertRow(int rowIndex) {
        this.prioritySynchronizer.insertRow(rowIndex);
        this.updateSystemControlledColumnValues((a, b) -> {});
    }

    public void appendRow() {
        this.updateSystemControlledColumnValues();
    }

    private static interface PostSyncOperation {
        public void execute(int var1, PrioritySynchronizer.RowNumberChanges var2);
    }
}

