/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.utilities;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.soup.project.datamodel.oracle.DropDownData;
import org.kie.workbench.common.services.shared.enums.EnumDropdownService;
import org.kie.workbench.common.widgets.client.util.ConstraintValueHelper;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.Command;

@Dependent
public class EnumLoaderUtilities {
    private final Caller<EnumDropdownService> enumDropdownService;
    private final Map<String, Map<String, String>> enumCache = new HashMap<String, Map<String, String>>();

    @Inject
    public EnumLoaderUtilities(Caller<EnumDropdownService> enumDropdownService) {
        this.enumDropdownService = enumDropdownService;
    }

    public void getEnums(DropDownData enumDefinition, Callback<Map<String, String>> callback, GuidedDecisionTablePresenter presenter, Command onFetchCommand, Command onFetchCompleteCommand) {
        if (enumDefinition == null) {
            callback.callback(Collections.emptyMap());
            return;
        }
        if (enumDefinition.getFixedList() != null) {
            this.getEnumsFromFixedList(enumDefinition, callback);
            return;
        }
        if (enumDefinition.getQueryExpression() != null) {
            this.getEnumsFromServer(enumDefinition, callback, presenter, onFetchCommand, onFetchCompleteCommand);
            return;
        }
        callback.callback(Collections.emptyMap());
    }

    private void getEnumsFromFixedList(DropDownData enumDefinition, Callback<Map<String, String>> callback) {
        String key = this.buildKey(enumDefinition);
        if (this.enumCache.containsKey(key)) {
            callback.callback(this.enumCache.get(key));
            return;
        }
        Map<String, String> convertedDropDownData = this.convertDropDownData(enumDefinition.getFixedList());
        this.enumCache.put(key, convertedDropDownData);
        callback.callback(convertedDropDownData);
    }

    private void getEnumsFromServer(DropDownData enumDefinition, final Callback<Map<String, String>> callback, GuidedDecisionTablePresenter presenter, Command onFetchCommand, final Command onFetchCompleteCommand) {
        final String key = this.buildKey(enumDefinition);
        if (this.enumCache.containsKey(key)) {
            callback.callback(this.enumCache.get(key));
            return;
        }
        this.enumCache.put(key, Collections.emptyMap());
        final GuidedDecisionTableView view = presenter.getView();
        ObservablePath currentPath = presenter.getCurrentPath();
        onFetchCommand.execute();
        ((EnumDropdownService)this.enumDropdownService.call((RemoteCallback)new RemoteCallback<String[]>(){

            public void callback(String[] items) {
                onFetchCompleteCommand.execute();
                Map<String, String> convertedDropDownData = EnumLoaderUtilities.this.convertDropDownData(items);
                EnumLoaderUtilities.this.enumCache.put(key, convertedDropDownData);
                callback.callback(convertedDropDownData);
                view.batch();
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)view))).loadDropDownExpression((Path)currentPath, enumDefinition.getValuePairs(), enumDefinition.getQueryExpression());
    }

    private String buildKey(DropDownData enumDefinition) {
        if (enumDefinition.getFixedList() != null) {
            return this.buildFixedListKey(enumDefinition.getFixedList());
        }
        return this.buildQueryExpressionKey(enumDefinition.getQueryExpression(), enumDefinition.getValuePairs());
    }

    private String buildFixedListKey(String[] items) {
        StringBuilder sb = new StringBuilder();
        for (String item : items) {
            sb.append(item).append("#");
        }
        String key = sb.toString();
        return key;
    }

    private String buildQueryExpressionKey(String queryExpression, String[] items) {
        StringBuilder sb = new StringBuilder();
        sb.append(queryExpression).append("#");
        sb.append(this.buildFixedListKey(items));
        String key = sb.toString();
        return key;
    }

    public Map<String, String> convertDropDownData(String[] dropDownItems) {
        TreeMap<String, String> convertedDropDownData = new TreeMap<String, String>();
        if (dropDownItems.length == 0) {
            return convertedDropDownData;
        }
        for (int i = 0; i < dropDownItems.length; ++i) {
            String dropDownItem;
            String key = dropDownItem = dropDownItems[i];
            String display = dropDownItem;
            if (dropDownItem.indexOf(61) > 0) {
                String[] split = ConstraintValueHelper.splitValue((String)dropDownItem);
                key = split[0];
                display = split[1];
            }
            convertedDropDownData.put(key.trim(), display.trim());
        }
        return convertedDropDownData;
    }
}

