/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasAdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.BaseDecisionTableColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class AdditionalInfoPage<T extends HasAdditionalInfoPage & DecisionTableColumnPlugin>
extends BaseDecisionTableColumnPage<T> {
    private View view;
    private boolean headerEnabled = false;
    private boolean hideColumnEnabled = false;
    private boolean logicallyInsertEnabled = false;
    private boolean updateEngineWithChangesEnabled = false;

    @Inject
    public AdditionalInfoPage(View view, TranslationService translationService) {
        super(translationService);
        this.view = view;
    }

    public String getTitle() {
        return this.translate("AdditionalInfoPage.AdditionalInfo", new Object[0]);
    }

    public void prepareView() {
        this.view.init(this);
        this.view.clear();
        this.setup();
    }

    @Override
    protected UberElement<?> getView() {
        return this.view;
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean isValid;
        boolean isNotEmpty = this.isHeaderNotEmpty();
        boolean isUnique = this.isHeaderUnique();
        boolean bl = isValid = isNotEmpty && isUnique;
        if (!isNotEmpty) {
            this.view.showWarning(this.translate("YouMustEnterAColumnHeaderValueDescription", new Object[0]));
        }
        if (!isUnique) {
            this.view.showWarning(this.translate("ThatColumnNameIsAlreadyInUsePleasePickAnother", new Object[0]));
        }
        if (isValid) {
            this.view.hideWarning();
        }
        callback.callback((Object)isValid);
    }

    public void enableHideColumn() {
        this.hideColumnEnabled = true;
    }

    public void enableLogicallyInsert() {
        this.logicallyInsertEnabled = true;
    }

    public void enableUpdateEngineWithChanges() {
        this.updateEngineWithChangesEnabled = true;
    }

    public void enableHeader() {
        this.headerEnabled = true;
    }

    public String getHeader() {
        return ((HasAdditionalInfoPage)this.plugin()).getHeader();
    }

    void setHeader(String header) {
        ((HasAdditionalInfoPage)this.plugin()).setHeader(header);
    }

    private void setup() {
        this.setupHeader();
        this.setupHideColumn();
        this.setupLogicallyInsert();
        this.setupUpdateEngineWithChanges();
    }

    void setupHeader() {
        if (this.headerEnabled) {
            this.view.showHeader();
        }
    }

    void setupHideColumn() {
        if (this.hideColumnEnabled) {
            this.view.showHideColumn(((HasAdditionalInfoPage)this.plugin()).isHideColumn());
        }
    }

    void setupLogicallyInsert() {
        if (this.logicallyInsertEnabled && ((HasAdditionalInfoPage)this.plugin()).showLogicallyInsert()) {
            this.view.showLogicallyInsert(((HasAdditionalInfoPage)this.plugin()).isLogicallyInsert());
        }
    }

    void setupUpdateEngineWithChanges() {
        if (this.updateEngineWithChangesEnabled && ((HasAdditionalInfoPage)this.plugin()).showUpdateEngineWithChanges()) {
            this.view.showUpdateEngineWithChanges(((HasAdditionalInfoPage)this.plugin()).isUpdateEngine());
        }
    }

    private boolean isHeaderNotEmpty() {
        return this.headerEnabled && !DecisionTableColumnViewUtils.nil(this.getHeader());
    }

    boolean isHeaderUnique() {
        return !((HasAdditionalInfoPage)this.plugin()).getAlreadyUsedColumnHeaders().stream().filter(header -> ((DecisionTableColumnPlugin)((Object)((HasAdditionalInfoPage)this.plugin()))).isNewColumn() != false || !this.originalColumnHeader().equals(header)).anyMatch(header -> header.equals(this.getHeader()));
    }

    private String originalColumnHeader() {
        DTColumnConfig52 originalCol = ((DecisionTableColumnPlugin)((Object)((HasAdditionalInfoPage)this.plugin()))).getOriginalColumnConfig52();
        return originalCol.getHeader();
    }

    void setHideColumn(Boolean isHidden) {
        ((HasAdditionalInfoPage)this.plugin()).setHideColumn(isHidden);
    }

    void setInsertLogical(Boolean insertLogical) {
        ((HasAdditionalInfoPage)this.plugin()).setInsertLogical(insertLogical);
    }

    public void setUpdate(Boolean update) {
        ((HasAdditionalInfoPage)this.plugin()).setUpdate(update);
    }

    public static interface View
    extends UberElement<AdditionalInfoPage> {
        public void showHideColumn(boolean var1);

        public void showHeader();

        public void showLogicallyInsert(boolean var1);

        public void showUpdateEngineWithChanges(boolean var1);

        public void showWarning(String var1);

        public void hideWarning();

        public void clear();
    }
}

