/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.BaseDecisionTableColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class SummaryPage
extends BaseDecisionTableColumnPage {
    private Boolean includeAdvanced = Boolean.FALSE;
    private List<DecisionTableColumnPlugin> plugins = new ArrayList<DecisionTableColumnPlugin>();
    private ManagedInstance<DecisionTableColumnPlugin> pluginManagedInstance;
    private View view;

    @Inject
    public SummaryPage(ManagedInstance<DecisionTableColumnPlugin> pluginManagedInstance, View view, TranslationService translationService) {
        super(translationService);
        this.pluginManagedInstance = pluginManagedInstance;
        this.view = view;
    }

    public String getTitle() {
        return this.translate("SummaryPage.NewColumn", new Object[0]);
    }

    public void isComplete(Callback<Boolean> callback) {
        callback.callback((Object)true);
    }

    public void prepareView() {
        this.view.init(this);
        this.setupPluginList();
    }

    @Override
    protected UberElement<?> getView() {
        return this.view;
    }

    @PostConstruct
    public void loadPlugins() {
        ArrayList<DecisionTableColumnPlugin> loadedPlugins = new ArrayList<DecisionTableColumnPlugin>(){
            {
                SummaryPage.this.pluginManagedInstance.forEach(this::add);
            }
        };
        this.plugins = this.sortByTitle((List<DecisionTableColumnPlugin>)loadedPlugins);
    }

    void openPage(String selectedItemText) {
        if (selectedItemText.isEmpty() || this.presenter.isReadOnly()) {
            return;
        }
        DecisionTableColumnPlugin plugin = this.findPluginByIdentifier(selectedItemText);
        this.wizard.start(plugin);
    }

    DecisionTableColumnPlugin findPluginByIdentifier(String selectedItemText) {
        for (DecisionTableColumnPlugin plugin : this.plugins()) {
            if (!plugin.getIdentifier().equals(selectedItemText)) continue;
            return plugin;
        }
        throw new UnsupportedOperationException("The plugin " + selectedItemText + " does not have an implementation.");
    }

    List<DecisionTableColumnPlugin> pluginsByCategory() {
        return this.plugins().stream().filter(plugin -> this.includeAdvanced != false || plugin.getType() == DecisionTableColumnPlugin.Type.BASIC).collect(Collectors.toList());
    }

    List<DecisionTableColumnPlugin> plugins() {
        return this.plugins;
    }

    List<DecisionTableColumnPlugin> sortByTitle(List<DecisionTableColumnPlugin> plugins) {
        ArrayList<DecisionTableColumnPlugin> sortedPlugins = new ArrayList<DecisionTableColumnPlugin>(plugins);
        sortedPlugins.sort((plugin1, plugin2) -> plugin1.getTitle().compareTo(plugin2.getTitle()));
        return sortedPlugins;
    }

    void setIncludeAdvanced(Boolean includeAdvanced) {
        this.includeAdvanced = includeAdvanced;
        this.setupPluginList();
    }

    private void setupPluginList() {
        this.view.loadPluginList(this.pluginsByCategory());
        this.view.setSelectedPlugin(this.currentPluginIdentifier());
    }

    private String currentPluginIdentifier() {
        DecisionTableColumnPlugin plugin = Optional.ofNullable(this.plugin()).orElse(DecisionTableColumnPlugin.DEFAULT);
        return plugin.getIdentifier();
    }

    public static interface View
    extends UberElement<SummaryPage> {
        public void loadPluginList(List<DecisionTableColumnPlugin> var1);

        public void setSelectedPlugin(String var1);
    }
}

