/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ListBox;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.SummaryPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class SummaryPageView
implements IsElement,
SummaryPage.View {
    private SummaryPage page;
    @DataField(value="pluginsList")
    private ListBox pluginsList;
    @DataField(value="includeAdvanced")
    private CheckBox includeAdvanced;

    @Inject
    public SummaryPageView(ListBox pluginsList, CheckBox includeAdvanced) {
        this.pluginsList = pluginsList;
        this.includeAdvanced = includeAdvanced;
    }

    public void init(SummaryPage page) {
        this.page = page;
    }

    @EventHandler(value={"pluginsList"})
    public void onPluginSelected(ChangeEvent event) {
        this.openSelectedPlugin();
    }

    @EventHandler(value={"includeAdvanced"})
    public void onSelectIncludeAdvanced(ChangeEvent event) {
        this.page.setIncludeAdvanced(this.includeAdvanced.getValue());
    }

    private void openSelectedPlugin() {
        String selectedValue = this.pluginsList.getSelectedValue();
        this.page.openPage(selectedValue);
    }

    @Override
    public void loadPluginList(List<DecisionTableColumnPlugin> plugins) {
        this.pluginsList.clear();
        for (DecisionTableColumnPlugin plugin : plugins) {
            this.pluginsList.addItem(plugin.getTitle(), plugin.getIdentifier());
        }
        this.pluginsList.setVisibleItemCount(this.pluginsList.getItemCount());
    }

    @Override
    public void setSelectedPlugin(String identifier) {
        int currentValueIndex = DecisionTableColumnViewUtils.getCurrentIndexFromListWithoutDefaultSelect(identifier, this.pluginsList);
        this.pluginsList.setSelectedIndex(currentValueIndex);
    }
}

