/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.table.pages;

import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.ImportsPageView;
import org.drools.workbench.screens.guided.dtable.client.wizard.table.pages.MinimumWidthCellList;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Label;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.ext.widgets.core.client.resources.WizardCellListResources;

@Dependent
public class ImportsPageViewImpl
extends Composite
implements ImportsPageView {
    private ImportsPageView.Presenter presenter;
    private List<String> availableImports;
    private Set<String> availableImportsSelections;
    private MinimumWidthCellList<String> availableImportsWidget;
    private MultiSelectionModel<String> availableImportsSelectionModel = new MultiSelectionModel();
    private List<String> chosenImports;
    private Set<String> chosenImportSelections;
    private MinimumWidthCellList<String> chosenImportsWidget;
    private MultiSelectionModel<String> chosenImportsSelectionModel = new MultiSelectionModel();
    @UiField
    ScrollPanel availableImportsContainer;
    @UiField
    ScrollPanel chosenImportsContainer;
    @UiField
    Button btnAdd;
    @UiField
    Button btnRemove;
    private static ImportsPageWidgetBinder uiBinder = (ImportsPageWidgetBinder)GWT.create(ImportsPageWidgetBinder.class);

    public ImportsPageViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    @PostConstruct
    public void setup() {
        this.availableImportsWidget = new MinimumWidthCellList(new TextCell(), (CellList.Resources)WizardCellListResources.INSTANCE);
        this.chosenImportsWidget = new MinimumWidthCellList(new TextCell(), (CellList.Resources)WizardCellListResources.INSTANCE);
        this.initialiseAvailableImports();
        this.initialiseChosenImports();
    }

    private void initialiseAvailableImports() {
        this.availableImportsContainer.add(this.availableImportsWidget);
        this.availableImportsWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.availableImportsWidget.setMinimumWidth(270);
        Label lstEmpty = new Label(GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardNoAvailableImports());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.availableImportsWidget.setEmptyListWidget((Widget)lstEmpty);
        this.availableImportsWidget.setSelectionModel((SelectionModel)this.availableImportsSelectionModel);
        this.availableImportsSelectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                ImportsPageViewImpl.this.availableImportsSelections = ImportsPageViewImpl.this.availableImportsSelectionModel.getSelectedSet();
                ImportsPageViewImpl.this.btnAdd.setEnabled(ImportsPageViewImpl.this.availableImportsSelections.size() > 0);
            }
        });
    }

    private void initialiseChosenImports() {
        this.chosenImportsContainer.add(this.chosenImportsWidget);
        this.chosenImportsWidget.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.ENABLED);
        this.chosenImportsWidget.setMinimumWidth(270);
        Label lstEmpty = new Label(GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardNoChosenImports());
        lstEmpty.setStyleName(WizardCellListResources.INSTANCE.cellListStyle().cellListEmptyItem());
        this.chosenImportsWidget.setEmptyListWidget((Widget)lstEmpty);
        this.chosenImportsWidget.setSelectionModel((SelectionModel)this.chosenImportsSelectionModel);
        this.chosenImportsSelectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                ImportsPageViewImpl.this.chosenImportSelections = ImportsPageViewImpl.this.chosenImportsSelectionModel.getSelectedSet();
                ImportsPageViewImpl.this.btnRemove.setEnabled(ImportsPageViewImpl.this.chosenImportSelections.size() > 0);
            }
        });
    }

    @Override
    public void setAvailableImports(List<String> imports) {
        Collections.sort(imports);
        this.availableImports = new ArrayList<String>(imports);
        this.availableImportsWidget.setRowCount(this.availableImports.size(), true);
        this.availableImportsWidget.setRowData(this.availableImports);
    }

    @Override
    public void setChosenImports(List<String> imports) {
        Collections.sort(imports);
        this.chosenImports = new ArrayList<String>(imports);
        this.chosenImportsWidget.setRowCount(this.chosenImports.size(), true);
        this.chosenImportsWidget.setRowData(this.chosenImports);
    }

    public void init(ImportsPageView.Presenter presenter) {
        this.presenter = presenter;
    }

    @UiHandler(value={"btnAdd"})
    public void btnAddClick(ClickEvent event) {
        for (String imp : this.availableImportsSelections) {
            this.availableImports.remove(imp);
            this.chosenImports.add(imp);
            this.presenter.addImport(imp);
        }
        this.refreshImportsWidgets();
        this.availableImportsSelections.clear();
        this.availableImportsSelectionModel.clear();
        this.btnAdd.setEnabled(false);
    }

    @UiHandler(value={"btnRemove"})
    public void btnRemoveClick(ClickEvent event) {
        boolean allImportsRemoved = true;
        Iterator<String> itr = this.chosenImportSelections.iterator();
        while (itr.hasNext()) {
            String imp = itr.next();
            boolean importRemoved = this.presenter.removeImport(imp);
            boolean bl = allImportsRemoved = allImportsRemoved && importRemoved;
            if (!importRemoved) continue;
            this.availableImports.add(imp);
            this.chosenImports.remove(imp);
            this.chosenImportsSelectionModel.setSelected((Object)imp, false);
            itr.remove();
        }
        this.refreshImportsWidgets();
        if (!allImportsRemoved) {
            ErrorPopup.showMessage((String)GuidedDecisionTableConstants.INSTANCE.DecisionTableWizardCannotRemoveImport());
        }
        this.btnRemove.setEnabled(!allImportsRemoved);
    }

    private void refreshImportsWidgets() {
        this.setAvailableImports(this.availableImports);
        this.setChosenImports(this.chosenImports);
    }

    static interface ImportsPageWidgetBinder
    extends UiBinder<Widget, ImportsPageViewImpl> {
    }
}

