/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.event.Event;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.EditMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.InsertMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.ViewMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.kie.workbench.common.widgets.metadata.client.KieMultipleDocumentEditor;
import org.kie.workbench.common.widgets.metadata.client.KieMultipleDocumentEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.menu.RegisteredDocumentsMenuBuilder;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

public abstract class BaseGuidedDecisionTableEditorPresenter
extends KieMultipleDocumentEditor<GuidedDecisionTableView.Presenter> {
    protected View view;
    protected Caller<GuidedDecisionTableEditorService> service;
    protected Event<NotificationEvent> notification;
    protected Event<DecisionTableSelectedEvent> decisionTableSelectedEvent;
    protected ValidationPopup validationPopup;
    protected ClientResourceType resourceType;
    protected EditMenuBuilder editMenuBuilder;
    protected ViewMenuBuilder viewMenuBuilder;
    protected InsertMenuBuilder insertMenuBuilder;
    protected RadarMenuBuilder radarMenuBuilder;
    protected GuidedDecisionTableModellerView.Presenter modeller;
    protected ObservablePath editorPath;
    protected PlaceRequest editorPlaceRequest;
    protected MenuItem editMenuItem;
    protected MenuItem viewMenuItem;
    protected MenuItem insertMenuItem;
    protected MenuItem radarMenuItem;
    protected SyncBeanManager beanManager;
    protected PlaceManager placeManager;

    public BaseGuidedDecisionTableEditorPresenter(View view, Caller<GuidedDecisionTableEditorService> service, Event<NotificationEvent> notification, Event<DecisionTableSelectedEvent> decisionTableSelectedEvent, ValidationPopup validationPopup, ClientResourceType resourceType, EditMenuBuilder editMenuBuilder, ViewMenuBuilder viewMenuBuilder, InsertMenuBuilder insertMenuBuilder, RadarMenuBuilder radarMenuBuilder, GuidedDecisionTableModellerView.Presenter modeller, SyncBeanManager beanManager, PlaceManager placeManager) {
        super((KieEditorView)view);
        this.view = view;
        this.service = service;
        this.notification = notification;
        this.decisionTableSelectedEvent = decisionTableSelectedEvent;
        this.validationPopup = validationPopup;
        this.resourceType = resourceType;
        this.editMenuBuilder = editMenuBuilder;
        this.viewMenuBuilder = viewMenuBuilder;
        this.insertMenuBuilder = insertMenuBuilder;
        this.radarMenuBuilder = radarMenuBuilder;
        this.modeller = modeller;
        this.beanManager = beanManager;
        this.placeManager = placeManager;
    }

    protected void setupMenuBar() {
        super.setupMenuBar();
    }

    protected void setKieEditorWrapperView(KieMultipleDocumentEditorWrapperView kieEditorWrapperView) {
        super.setKieEditorWrapperView(kieEditorWrapperView);
    }

    protected void setOverviewWidget(OverviewWidgetPresenter overviewWidget) {
        super.setOverviewWidget(overviewWidget);
    }

    protected void setSavePopUpPresenter(SavePopUpPresenter savePopUpPresenter) {
        super.setSavePopUpPresenter(savePopUpPresenter);
    }

    protected void setImportsWidget(ImportsWidgetPresenter importsWidget) {
        super.setImportsWidget(importsWidget);
    }

    protected void setNotificationEvent(Event<NotificationEvent> notificationEvent) {
        super.setNotificationEvent(notificationEvent);
    }

    protected void setChangeTitleEvent(Event<ChangeTitleWidgetEvent> changeTitleEvent) {
        super.setChangeTitleEvent(changeTitleEvent);
    }

    protected void setWorkbenchContext(ProjectContext workbenchContext) {
        super.setWorkbenchContext(workbenchContext);
    }

    protected void setVersionRecordManager(VersionRecordManager versionRecordManager) {
        super.setVersionRecordManager(versionRecordManager);
    }

    protected void setFileMenuBuilder(FileMenuBuilder fileMenuBuilder) {
        super.setFileMenuBuilder(fileMenuBuilder);
    }

    protected void setRegisteredDocumentsMenuBuilder(RegisteredDocumentsMenuBuilder registeredDocumentsMenuBuilder) {
        super.setRegisteredDocumentsMenuBuilder(registeredDocumentsMenuBuilder);
    }

    protected void setFileNameValidator(DefaultFileNameValidator fileNameValidator) {
        super.setFileNameValidator(fileNameValidator);
    }

    protected void init() {
        this.viewMenuBuilder.setModeller(this.modeller);
        this.insertMenuBuilder.setModeller(this.modeller);
        this.radarMenuBuilder.setModeller(this.modeller);
        this.view.setModellerView(this.modeller.getView());
    }

    protected void onStartup(ObservablePath path, PlaceRequest placeRequest) {
        this.editorPath = path;
        this.editorPlaceRequest = placeRequest;
    }

    protected void onFocus() {
        if (this.modeller.getActiveDecisionTable() != null) {
            this.decisionTableSelectedEvent.fire((Object)new DecisionTableSelectedEvent(this.modeller.getActiveDecisionTable()));
            this.modeller.getActiveDecisionTable().initialiseAnalysis();
        }
    }

    protected String getTitleText() {
        return this.resourceType.getDescription();
    }

    public String getDocumentTitle(GuidedDecisionTableView.Presenter dtPresenter) {
        return dtPresenter.getCurrentPath().getFileName() + " - " + this.resourceType.getDescription();
    }

    protected boolean mayClose() {
        for (GuidedDecisionTableView.Presenter dtPresenter : this.modeller.getAvailableDecisionTables()) {
            if (this.mayClose(dtPresenter)) continue;
            return false;
        }
        return true;
    }

    protected boolean mayClose(GuidedDecisionTableView.Presenter dtPresenter) {
        Integer originalHashCode = dtPresenter.getOriginalHashCode();
        Integer currentHashCode = dtPresenter.getModel().hashCode();
        return this.mayClose(originalHashCode, currentHashCode);
    }

    public void onClose() {
        super.onClose();
        this.modeller.onClose();
    }

    protected void onDecisionTableSelected(DecisionTableSelectedEvent event) {
        Optional<GuidedDecisionTableView.Presenter> dtPresenter = event.getPresenter();
        this.enableMenuItem(dtPresenter.isPresent(), MenuItems.VALIDATE);
        if (!dtPresenter.isPresent()) {
            return;
        }
        GuidedDecisionTableView.Presenter presenter = dtPresenter.get();
        if (!this.modeller.isDecisionTableAvailable(presenter)) {
            return;
        }
        if (presenter.equals(this.getActiveDocument())) {
            return;
        }
        this.activateDocument(presenter);
    }

    protected void activateDocument(GuidedDecisionTableView.Presenter dtPresenter) {
        this.enableMenus(true);
        dtPresenter.activate();
        this.activateDocument(dtPresenter, dtPresenter.getOverview(), dtPresenter.getDataModelOracle(), dtPresenter.getModel().getImports(), !dtPresenter.getAccess().isEditable());
    }

    public void refreshDocument(GuidedDecisionTableView.Presenter dtPresenter) {
        ObservablePath versionPath = dtPresenter.getCurrentPath();
        this.view.showLoading();
        ((GuidedDecisionTableEditorService)this.service.call(this.getRefreshContentSuccessCallback(dtPresenter), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)versionPath);
    }

    private RemoteCallback<GuidedDecisionTableEditorContent> getRefreshContentSuccessCallback(GuidedDecisionTableView.Presenter dtPresenter) {
        ObservablePath path = dtPresenter.getLatestPath();
        PlaceRequest place = dtPresenter.getPlaceRequest();
        boolean isReadOnly = dtPresenter.isReadOnly();
        return content -> {
            this.modeller.refreshDecisionTable(dtPresenter, path, place, (GuidedDecisionTableEditorContent)content, isReadOnly);
            this.activateDocument(dtPresenter);
            this.view.hideBusyIndicator();
        };
    }

    public void removeDocument(GuidedDecisionTableView.Presenter dtPresenter) {
        this.modeller.removeDecisionTable(dtPresenter);
        this.deregisterDocument(dtPresenter);
        dtPresenter.onClose();
        this.openOtherDecisionTable();
    }

    void openOtherDecisionTable() {
        Set<GuidedDecisionTableView.Presenter> availableDecisionTables = this.modeller.getAvailableDecisionTables();
        if (availableDecisionTables == null || availableDecisionTables.isEmpty()) {
            this.decisionTableSelectedEvent.fire((Object)DecisionTableSelectedEvent.NONE);
        } else {
            GuidedDecisionTableView.Presenter dtPresenter = availableDecisionTables.iterator().next();
            this.activateDocument(dtPresenter);
        }
    }

    public void onValidate(GuidedDecisionTableView.Presenter dtPresenter) {
        ObservablePath path = dtPresenter.getCurrentPath();
        GuidedDecisionTable52 model = dtPresenter.getModel();
        ((GuidedDecisionTableEditorService)this.service.call((RemoteCallback)new RemoteCallback<List<ValidationMessage>>(){

            public void callback(List<ValidationMessage> results) {
                if (results == null || results.isEmpty()) {
                    BaseGuidedDecisionTableEditorPresenter.this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemValidatedSuccessfully(), NotificationEvent.NotificationType.SUCCESS));
                } else {
                    BaseGuidedDecisionTableEditorPresenter.this.showValidationPopup(results);
                }
            }
        })).validate((Path)path, (Object)model);
    }

    void showValidationPopup(List<ValidationMessage> results) {
        this.validationPopup.showMessages(results);
    }

    public void onSave(GuidedDecisionTableView.Presenter dtPresenter, String commitMessage) {
        ObservablePath path = dtPresenter.getCurrentPath();
        GuidedDecisionTable52 model = dtPresenter.getModel();
        Metadata metadata = dtPresenter.getOverview().getMetadata();
        ((GuidedDecisionTableEditorService)this.service.call(this.getSaveSuccessCallback(dtPresenter, model.hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).saveAndUpdateGraphEntries((Path)path, model, metadata, commitMessage);
    }

    public void onSourceTabSelected(GuidedDecisionTableView.Presenter dtPresenter) {
        ObservablePath path = dtPresenter.getCurrentPath();
        GuidedDecisionTable52 model = dtPresenter.getModel();
        ((GuidedDecisionTableEditorService)this.service.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String source) {
                BaseGuidedDecisionTableEditorPresenter.this.updateSource(source);
            }
        }, (ErrorCallback)this.getCouldNotGenerateSourceErrorCallback())).toSource((Path)path, (Object)model);
    }

    protected MenuItem getEditMenuItem() {
        if (this.editMenuItem == null) {
            this.editMenuItem = this.editMenuBuilder.build();
        }
        return this.editMenuItem;
    }

    protected MenuItem getViewMenuItem() {
        if (this.viewMenuItem == null) {
            this.viewMenuItem = this.viewMenuBuilder.build();
        }
        return this.viewMenuItem;
    }

    protected MenuItem getInsertMenuItem() {
        if (this.insertMenuItem == null) {
            this.insertMenuItem = this.insertMenuBuilder.build();
        }
        return this.insertMenuItem;
    }

    protected MenuItem getRadarMenuItem() {
        if (this.radarMenuItem == null) {
            this.radarMenuItem = this.radarMenuBuilder.build();
        }
        return this.radarMenuItem;
    }

    protected void enableMenus(boolean enabled) {
        super.enableMenus(enabled);
        this.getEditMenuItem().setEnabled(enabled);
        this.getViewMenuItem().setEnabled(enabled);
        this.getInsertMenuItem().setEnabled(enabled);
        this.getRadarMenuItem().setEnabled(enabled);
    }

    public static interface View
    extends RequiresResize,
    ProvidesResize,
    KieEditorView,
    IsWidget {
        public void setModellerView(GuidedDecisionTableModellerView var1);
    }
}

