/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.imports.Imports;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.editor.BaseGuidedDecisionTableEditorPresenter;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.EditMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.InsertMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.ViewMenuBuilder;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableGraphResourceType;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.wizard.NewGuidedDecisionTableWizardHelper;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorContent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphContent;
import org.drools.workbench.screens.guided.dtable.model.GuidedDecisionTableEditorGraphModel;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableGraphEditorService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.widgets.client.callbacks.CommandDrivenErrorCallback;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.popups.validation.ValidationPopup;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.LockManager;
import org.uberfire.client.mvp.LockTarget;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.SaveInProgressEvent;
import org.uberfire.client.mvp.UpdatedLockStatusEvent;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.menu.MenuItems;
import org.uberfire.ext.editor.commons.client.resources.i18n.CommonConstants;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.version.events.RestoreEvent;
import org.uberfire.ext.widgets.common.client.callbacks.DefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.ConcurrentChangePopup;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="GuidedDecisionTableGraphEditor", supportedTypes={GuidedDTableGraphResourceType.class}, lockingStrategy=WorkbenchEditor.LockingStrategy.EDITOR_PROVIDED)
public class GuidedDecisionTableGraphEditorPresenter
extends BaseGuidedDecisionTableEditorPresenter {
    private final Caller<GuidedDecisionTableGraphEditorService> graphService;
    private final Caller<KieProjectService> projectService;
    private final Event<SaveInProgressEvent> saveInProgressEvent;
    private final LockManager lockManager;
    protected ObservablePath.OnConcurrentUpdateEvent concurrentUpdateSessionInfo = null;
    protected GuidedDecisionTablePresenter.Access access = new GuidedDecisionTablePresenter.Access();
    protected Integer originalGraphHash;
    private GuidedDecisionTableEditorGraphContent content;
    private LoadGraphLatch loadGraphLatch = null;
    private SaveGraphLatch saveGraphLatch = null;
    private NewGuidedDecisionTableWizardHelper helper;

    @Inject
    public GuidedDecisionTableGraphEditorPresenter(BaseGuidedDecisionTableEditorPresenter.View view, Caller<GuidedDecisionTableEditorService> service, Caller<GuidedDecisionTableGraphEditorService> graphService, Caller<KieProjectService> projectService, Event<NotificationEvent> notification, Event<SaveInProgressEvent> saveInProgressEvent, Event<DecisionTableSelectedEvent> decisionTableSelectedEvent, ValidationPopup validationPopup, GuidedDTableGraphResourceType dtGraphResourceType, EditMenuBuilder editMenuBuilder, ViewMenuBuilder viewMenuBuilder, InsertMenuBuilder insertMenuBuilder, RadarMenuBuilder radarMenuBuilder, GuidedDecisionTableModellerView.Presenter modeller, NewGuidedDecisionTableWizardHelper helper, SyncBeanManager beanManager, PlaceManager placeManager, LockManager lockManager) {
        super(view, service, notification, decisionTableSelectedEvent, validationPopup, dtGraphResourceType, editMenuBuilder, viewMenuBuilder, insertMenuBuilder, radarMenuBuilder, modeller, beanManager, placeManager);
        this.graphService = graphService;
        this.projectService = projectService;
        this.saveInProgressEvent = saveInProgressEvent;
        this.helper = helper;
        this.lockManager = lockManager;
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
        this.registeredDocumentsMenuBuilder.setActivateDocumentCommand(document -> {
            GuidedDecisionTablePresenter dtPresenter = (GuidedDecisionTablePresenter)document;
            this.decisionTableSelectedEvent.fire((Object)new DecisionTableSelectedEvent(dtPresenter));
        });
        this.registeredDocumentsMenuBuilder.setRemoveDocumentCommand(document -> {
            GuidedDecisionTablePresenter dtPresenter = (GuidedDecisionTablePresenter)document;
            if (this.mayClose(dtPresenter)) {
                this.removeDocument(dtPresenter);
            }
        });
        this.registeredDocumentsMenuBuilder.setNewDocumentCommand(this::onNewDocument);
    }

    void onNewDocument() {
        ((KieProjectService)this.projectService.call(pkg -> this.helper.createNewGuidedDecisionTable(pkg.getPackageMainResourcesPath(), "", GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, GuidedDecisionTable52.HitPolicy.NONE, (HasBusyIndicator)this.view, (RemoteCallback<Path>)((RemoteCallback)path -> this.onOpenDocumentsInEditor(Collections.singletonList(path)))))).resolvePackage((Path)this.editorPath);
    }

    @Override
    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest placeRequest) {
        super.onStartup(path, placeRequest);
        this.initialiseEditor(path, placeRequest);
    }

    @Override
    @OnFocus
    public void onFocus() {
        super.onFocus();
    }

    public void loadDocument(ObservablePath path, PlaceRequest placeRequest) {
        throw new UnsupportedOperationException();
    }

    void initialiseEditor(ObservablePath path, PlaceRequest placeRequest) {
        this.access.setReadOnly(placeRequest.getParameter("readOnly", null) != null);
        this.initialiseLockManager();
        this.initialiseVersionManager();
        this.addFileChangeListeners(path);
        this.loadDocumentGraph(path);
    }

    void initialiseVersionManager() {
        this.versionRecordManager.init(null, this.editorPath, versionRecord -> {
            this.versionRecordManager.setVersion(versionRecord.id());
            this.access.setReadOnly(!this.versionRecordManager.isLatest(versionRecord));
            this.registeredDocumentsMenuBuilder.setReadOnly(this.isReadOnly());
            this.reload();
        });
    }

    void loadDocumentGraph(ObservablePath path) {
        this.view.showLoading();
        this.view.refreshTitle(this.getTitleText());
        ((GuidedDecisionTableGraphEditorService)this.graphService.call(this.getLoadGraphContentSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)path);
    }

    private RemoteCallback<GuidedDecisionTableEditorGraphContent> getLoadGraphContentSuccessCallback() {
        return content -> {
            this.content = content;
            this.originalGraphHash = content.getModel().hashCode();
            this.concurrentUpdateSessionInfo = null;
            GuidedDecisionTableEditorGraphModel model = content.getModel();
            Set modelEntries = model.getEntries();
            this.initialiseEditorTabsWhenNoDocuments();
            if (modelEntries == null || modelEntries.isEmpty()) {
                this.view.hideBusyIndicator();
                return;
            }
            this.loadGraphLatch = new LoadGraphLatch(modelEntries.size(), this.getSelectDecisionTableCommand(((GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry)modelEntries.iterator().next()).getPathHead()), () -> {
                this.originalGraphHash = this.buildModelFromEditor().hashCode();
                this.modeller.getView().getGridPanel().setFocus(true);
            });
            modelEntries.stream().forEach(x$0 -> this.loadGraphLatch.loadDocumentGraphEntry(x$0));
        };
    }

    private ParameterizedCommand<GuidedDecisionTableView.Presenter> getSelectDecisionTableCommand(Path dtToSelectPath) {
        return dtPresenter -> {
            if (dtPresenter.getCurrentPath().getOriginal().equals(dtToSelectPath)) {
                this.decisionTableSelectedEvent.fire((Object)new DecisionTableSelectedEvent((GuidedDecisionTableView.Presenter)dtPresenter, false));
            }
        };
    }

    PathPlaceRequest getPathPlaceRequest(Path path) {
        return new PathPlaceRequest(path);
    }

    void initialiseLockManager() {
        this.lockManager.init(new LockTarget((Path)this.editorPath, (IsWidget)this.view.asWidget(), this.editorPlaceRequest, () -> this.editorPath.getFileName() + " - " + this.resourceType.getDescription(), () -> {}));
    }

    @Override
    @WorkbenchPartTitle
    public String getTitleText() {
        return this.versionRecordManager.getCurrentPath().getFileName() + " - " + this.resourceType.getDescription();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return super.getMenus();
    }

    @Override
    @OnMayClose
    public boolean mayClose() {
        this.setMayCloseHandler(this::doMayCloseGraph);
        boolean mayClose = this.mayClose(this.originalGraphHash, this.buildModelFromEditor().hashCode());
        this.setMayCloseHandler(this::doMayCloseDocument);
        mayClose = mayClose && super.mayClose();
        return mayClose;
    }

    private boolean doMayCloseGraph(Integer originalHashCode, Integer currentHashCode) {
        if (this.isDirty(originalHashCode, currentHashCode) || this.overviewWidget.isDirty()) {
            return this.editorView.confirmClose();
        }
        return true;
    }

    private boolean doMayCloseDocument(Integer originalHashCode, Integer currentHashCode) {
        if (this.isDirty(originalHashCode, currentHashCode)) {
            return this.editorView.confirmClose();
        }
        return true;
    }

    GuidedDecisionTableEditorGraphModel buildModelFromEditor() {
        GuidedDecisionTableEditorGraphModel model = new GuidedDecisionTableEditorGraphModel();
        for (GuidedDecisionTableView.Presenter dtPresenter : this.modeller.getAvailableDecisionTables()) {
            model.getEntries().add(new GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry((Path)dtPresenter.getLatestPath(), (Path)dtPresenter.getCurrentPath(), Double.valueOf(dtPresenter.getView().getX()), Double.valueOf(dtPresenter.getView().getY())));
        }
        return model;
    }

    @Override
    @OnClose
    public void onClose() {
        this.lockManager.releaseLock();
        super.onClose();
    }

    @Override
    protected void onDecisionTableSelected(@Observes DecisionTableSelectedEvent event) {
        super.onDecisionTableSelected(event);
        if (event.isLockRequired() && !this.isReadOnly()) {
            this.lockManager.acquireLock();
        }
    }

    public void makeMenuBar() {
        if (this.canUpdateProject()) {
            this.fileMenuBuilder.addSave(this.getSaveMenuItem()).addCopy(() -> ((VersionRecordManager)this.versionRecordManager).getCurrentPath(), (Validator)this.fileNameValidator).addRename(() -> ((VersionRecordManager)this.versionRecordManager).getPathToLatest(), (Validator)this.fileNameValidator).addDelete(() -> ((VersionRecordManager)this.versionRecordManager).getPathToLatest());
        }
        this.menus = this.fileMenuBuilder.addValidate(() -> this.onValidate((GuidedDecisionTableView.Presenter)this.getActiveDocument())).addNewTopLevelMenu(this.getEditMenuItem()).addNewTopLevelMenu(this.getViewMenuItem()).addNewTopLevelMenu(this.getInsertMenuItem()).addNewTopLevelMenu(this.getRadarMenuItem()).addNewTopLevelMenu(this.getRegisteredDocumentsMenuItem()).addNewTopLevelMenu(this.getVersionManagerMenuItem()).build();
    }

    @Override
    protected void enableMenus(boolean enabled) {
        super.enableMenus(enabled);
        this.getRegisteredDocumentsMenuItem().setEnabled(enabled);
    }

    public void getAvailableDocumentPaths(final Callback<List<Path>> callback) {
        this.view.showLoading();
        ((GuidedDecisionTableGraphEditorService)this.graphService.call((RemoteCallback)new RemoteCallback<List<Path>>(){

            public void callback(List<Path> paths) {
                GuidedDecisionTableGraphEditorPresenter.this.view.hideBusyIndicator();
                callback.callback(paths);
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).listDecisionTablesInPackage((Path)this.editorPath);
    }

    public void onOpenDocumentsInEditor(List<Path> selectedDocumentPaths) {
        if (selectedDocumentPaths == null || selectedDocumentPaths.isEmpty()) {
            return;
        }
        this.view.showLoading();
        this.loadGraphLatch = new LoadGraphLatch(selectedDocumentPaths.size(), (ParameterizedCommand)this.getSelectDecisionTableCommand(selectedDocumentPaths.get(0)));
        selectedDocumentPaths.stream().forEach(p -> {
            PathPlaceRequest placeRequest = this.getPathPlaceRequest((Path)p);
            this.loadGraphLatch.loadDocument(placeRequest.getPath(), (PlaceRequest)placeRequest);
        });
    }

    protected void doSave() {
        if (this.isReadOnly()) {
            if (this.versionRecordManager.isCurrentLatest()) {
                this.view.alertReadOnly();
                return;
            }
            this.versionRecordManager.restoreToCurrentVersion();
            return;
        }
        HashSet<GuidedDecisionTableView.Presenter> allDecisionTables = new HashSet<GuidedDecisionTableView.Presenter>(this.modeller.getAvailableDecisionTables());
        HashSet<ObservablePath.OnConcurrentUpdateEvent> concurrentUpdateSessionInfos = new HashSet<ObservablePath.OnConcurrentUpdateEvent>();
        allDecisionTables.stream().forEach(dtPresenter -> {
            ObservablePath.OnConcurrentUpdateEvent concurrentUpdateSessionInfo = dtPresenter.getConcurrentUpdateSessionInfo();
            if (concurrentUpdateSessionInfo != null) {
                concurrentUpdateSessionInfos.add(concurrentUpdateSessionInfo);
            }
        });
        if (this.concurrentUpdateSessionInfo != null) {
            concurrentUpdateSessionInfos.add(this.concurrentUpdateSessionInfo);
        }
        if (!concurrentUpdateSessionInfos.isEmpty()) {
            this.showConcurrentUpdatesPopup();
        } else {
            this.saveDocumentGraphEntries();
        }
    }

    void showConcurrentUpdatesPopup() {
        ConcurrentChangePopup.newConcurrentUpdate((Path)this.concurrentUpdateSessionInfo.getPath(), (User)this.concurrentUpdateSessionInfo.getIdentity(), this::saveDocumentGraphEntries, () -> {}, this::reload).show();
    }

    void saveDocumentGraphEntries() {
        HashSet<GuidedDecisionTableView.Presenter> allDecisionTables = new HashSet<GuidedDecisionTableView.Presenter>(this.modeller.getAvailableDecisionTables());
        this.savePopUpPresenter.show((Path)this.editorPath, commitMessage -> {
            this.editorView.showSaving();
            this.saveGraphLatch = new SaveGraphLatch(allDecisionTables.size(), (String)commitMessage);
            if (allDecisionTables.isEmpty()) {
                this.saveGraphLatch.saveDocumentGraph();
            } else {
                allDecisionTables.stream().forEach(dtPresenter -> {
                    this.saveGraphLatch.saveDocumentGraphEntry(dtPresenter);
                    this.saveInProgressEvent.fire((Object)new SaveInProgressEvent((Path)dtPresenter.getLatestPath()));
                });
            }
        });
    }

    protected void initialiseVersionManager(GuidedDecisionTableView.Presenter dtPresenter) {
    }

    protected void initialiseKieEditorTabs(GuidedDecisionTableView.Presenter document, Overview overview, AsyncPackageDataModelOracle dmo, Imports imports, boolean isReadOnly) {
        this.kieEditorWrapperView.clear();
        this.kieEditorWrapperView.addMainEditorPage(this.editorView);
        this.kieEditorWrapperView.addOverviewPage(this.overviewWidget, () -> this.overviewWidget.refresh(this.versionRecordManager.getVersion()));
        this.kieEditorWrapperView.addSourcePage(this.sourceWidget);
        this.kieEditorWrapperView.addImportsTab((IsWidget)this.importsWidget);
        this.overviewWidget.setContent(this.content.getOverview(), this.versionRecordManager.getPathToLatest());
        this.importsWidget.setContent(dmo, imports, isReadOnly);
    }

    void initialiseEditorTabsWhenNoDocuments() {
        this.getEditMenuItem().setEnabled(false);
        this.getViewMenuItem().setEnabled(false);
        this.getInsertMenuItem().setEnabled(false);
        this.getRadarMenuItem().setEnabled(false);
        this.enableMenuItem(false, MenuItems.VALIDATE);
        this.kieEditorWrapperView.clear();
        this.kieEditorWrapperView.addMainEditorPage(this.editorView);
        this.kieEditorWrapperView.addOverviewPage(this.overviewWidget, () -> this.overviewWidget.refresh(this.versionRecordManager.getVersion()));
        this.overviewWidget.setContent(this.content.getOverview(), this.versionRecordManager.getPathToLatest());
    }

    void addFileChangeListeners(ObservablePath path) {
        path.onRename(this::onRename);
        path.onDelete(this::onDelete);
        path.onConcurrentUpdate(info -> {
            this.concurrentUpdateSessionInfo = info;
        });
        path.onConcurrentRename(info -> ConcurrentChangePopup.newConcurrentRename((Path)info.getSource(), (Path)info.getTarget(), (User)info.getIdentity(), () -> this.enableMenus(false), this::reload).show());
        path.onConcurrentDelete(info -> ConcurrentChangePopup.newConcurrentDelete((Path)info.getPath(), (User)info.getIdentity(), () -> this.enableMenus(false), () -> this.placeManager.closePlace(this.editorPlaceRequest)).show());
    }

    void onDelete() {
        this.scheduleClosure(() -> this.placeManager.forceClosePlace(this.editorPlaceRequest));
    }

    void scheduleClosure(Scheduler.ScheduledCommand command) {
        Scheduler.get().scheduleDeferred(command);
    }

    void onRename() {
        this.reload();
        this.changeTitleEvent.fire((Object)new ChangeTitleWidgetEvent(this.editorPlaceRequest, this.getTitleText(), (IsWidget)this.editorView.getTitleWidget()));
    }

    void reload() {
        ArrayList documents = new ArrayList(this.documents);
        documents.stream().forEach(arg_0 -> ((GuidedDecisionTableGraphEditorPresenter)this).deregisterDocument(arg_0));
        this.modeller.getView().clear();
        this.modeller.releaseDecisionTables();
        this.loadDocumentGraph(this.versionRecordManager.getCurrentPath());
    }

    void onRestore(@Observes RestoreEvent restore) {
        if (this.versionRecordManager.getCurrentPath() == null || restore == null || restore.getPath() == null) {
            return;
        }
        if (this.versionRecordManager.getCurrentPath().equals(restore.getPath())) {
            this.initialiseEditor(this.versionRecordManager.getPathToLatest(), this.editorPlaceRequest);
            this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemRestored()));
        }
    }

    private boolean isReadOnly() {
        return !this.access.isEditable();
    }

    void onUpdatedLockStatusEvent(@Observes UpdatedLockStatusEvent event) {
        if (this.editorPath == null) {
            return;
        }
        if (this.editorPath.equals(event.getFile())) {
            if (event.isLocked()) {
                this.access.setLock(event.isLockedByCurrentUser() ? GuidedDecisionTablePresenter.Access.LockedBy.CURRENT_USER : GuidedDecisionTablePresenter.Access.LockedBy.OTHER_USER);
            } else {
                this.access.setLock(GuidedDecisionTablePresenter.Access.LockedBy.NOBODY);
            }
        }
    }

    private class SaveGraphLatch {
        private final String commitMessage;
        private int dtGraphElementCount = 0;

        private SaveGraphLatch(int dtGraphElementCount, String commitMessage) {
            this.dtGraphElementCount = dtGraphElementCount;
            this.commitMessage = commitMessage;
        }

        private void saveDocumentGraph() {
            --this.dtGraphElementCount;
            if (this.dtGraphElementCount > 0) {
                return;
            }
            final GuidedDecisionTableEditorGraphModel model = GuidedDecisionTableGraphEditorPresenter.this.buildModelFromEditor();
            ((GuidedDecisionTableGraphEditorService)GuidedDecisionTableGraphEditorPresenter.this.graphService.call((RemoteCallback)new RemoteCallback<Path>(){

                public void callback(Path path) {
                    GuidedDecisionTableGraphEditorPresenter.this.editorView.hideBusyIndicator();
                    GuidedDecisionTableGraphEditorPresenter.this.versionRecordManager.reloadVersions(path);
                    GuidedDecisionTableGraphEditorPresenter.this.originalGraphHash = model.hashCode();
                    GuidedDecisionTableGraphEditorPresenter.this.concurrentUpdateSessionInfo = null;
                    GuidedDecisionTableGraphEditorPresenter.this.notificationEvent.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.ItemSavedSuccessfully()));
                }
            }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)GuidedDecisionTableGraphEditorPresenter.this.view))).save((Path)GuidedDecisionTableGraphEditorPresenter.this.editorPath, (Object)model, GuidedDecisionTableGraphEditorPresenter.this.content.getOverview().getMetadata(), this.commitMessage);
        }

        private void saveDocumentGraphEntry(GuidedDecisionTableView.Presenter dtPresenter) {
            ObservablePath path = dtPresenter.getCurrentPath();
            GuidedDecisionTable52 model = dtPresenter.getModel();
            Metadata metadata = dtPresenter.getOverview().getMetadata();
            ((GuidedDecisionTableEditorService)GuidedDecisionTableGraphEditorPresenter.this.service.call(this.getSaveSuccessCallback(dtPresenter, model.hashCode()), (ErrorCallback)this.getSaveErrorCallback())).save((Path)path, (Object)model, metadata, this.commitMessage);
        }

        private RemoteCallback<Path> getSaveSuccessCallback(GuidedDecisionTableView.Presenter document, int currentHashCode) {
            return path -> {
                document.setConcurrentUpdateSessionInfo(null);
                document.setOriginalHashCode(currentHashCode);
                this.saveDocumentGraph();
            };
        }

        private DefaultErrorCallback getSaveErrorCallback() {
            return new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)GuidedDecisionTableGraphEditorPresenter.this.view){

                public boolean error(Message message, Throwable throwable) {
                    SaveGraphLatch.this.saveDocumentGraph();
                    return super.error(message, throwable);
                }
            };
        }
    }

    private class LoadGraphLatch {
        private int dtGraphElementCount;
        private Command onAllDocumentGraphEntriesLoadedCommand;
        private ParameterizedCommand<GuidedDecisionTableView.Presenter> onDocumentGraphEntryLoadedCommand;

        private LoadGraphLatch(int dtGraphElementCount, ParameterizedCommand<GuidedDecisionTableView.Presenter> onDocumentGraphEntryLoadedCommand) {
            this(dtGraphElementCount, onDocumentGraphEntryLoadedCommand, () -> {});
        }

        private LoadGraphLatch(int dtGraphElementCount, ParameterizedCommand<GuidedDecisionTableView.Presenter> onDocumentGraphEntryLoadedCommand, Command onAllDocumentGraphEntriesLoadedCommand) {
            this.dtGraphElementCount = dtGraphElementCount;
            this.onDocumentGraphEntryLoadedCommand = onDocumentGraphEntryLoadedCommand;
            this.onAllDocumentGraphEntriesLoadedCommand = onAllDocumentGraphEntriesLoadedCommand;
        }

        private void onDocumentGraphEntryLoaded(GuidedDecisionTableView.Presenter dtPresenter) {
            if (this.onDocumentGraphEntryLoadedCommand != null) {
                this.onDocumentGraphEntryLoadedCommand.execute((Object)dtPresenter);
            }
        }

        private void hideLoadingIndicator() {
            --this.dtGraphElementCount;
            if (this.dtGraphElementCount == 0) {
                if (this.onAllDocumentGraphEntriesLoadedCommand != null) {
                    this.onAllDocumentGraphEntriesLoadedCommand.execute();
                }
                GuidedDecisionTableGraphEditorPresenter.this.view.hideBusyIndicator();
            }
        }

        private void loadDocumentGraphEntry(GuidedDecisionTableEditorGraphModel.GuidedDecisionTableGraphEntry entry) {
            PathPlaceRequest placeRequest = GuidedDecisionTableGraphEditorPresenter.this.getPathPlaceRequest(entry.getPathHead());
            ObservablePath pathHead = placeRequest.getPath();
            Path pathVersion = entry.getPathVersion();
            Double x = entry.getX();
            Double y = entry.getY();
            if (GuidedDecisionTableGraphEditorPresenter.this.isReadOnly()) {
                placeRequest.addParameter("readOnly", "");
            }
            ((GuidedDecisionTableEditorService)GuidedDecisionTableGraphEditorPresenter.this.service.call(this.getLoadDocumentGraphEntryContentSuccessCallback(pathHead, (PlaceRequest)placeRequest, x, y), (ErrorCallback)this.getLoadErrorCallback())).loadContent(pathVersion);
        }

        private RemoteCallback<GuidedDecisionTableEditorContent> getLoadDocumentGraphEntryContentSuccessCallback(ObservablePath path, PlaceRequest placeRequest, Double x, Double y) {
            return content -> {
                if (path == null) {
                    return;
                }
                GuidedDecisionTableView.Presenter dtPresenter = GuidedDecisionTableGraphEditorPresenter.this.modeller.addDecisionTable(path, placeRequest, (GuidedDecisionTableEditorContent)content, placeRequest.getParameter("readOnly", null) != null, x, y);
                GuidedDecisionTableGraphEditorPresenter.this.registerDocument(dtPresenter);
                this.onDocumentGraphEntryLoaded(dtPresenter);
                this.hideLoadingIndicator();
            };
        }

        private void loadDocument(ObservablePath path, PlaceRequest placeRequest) {
            ((GuidedDecisionTableEditorService)GuidedDecisionTableGraphEditorPresenter.this.service.call(this.getLoadContentSuccessCallback(path, placeRequest), (ErrorCallback)this.getLoadErrorCallback())).loadContent((Path)path);
        }

        private RemoteCallback<GuidedDecisionTableEditorContent> getLoadContentSuccessCallback(ObservablePath path, PlaceRequest placeRequest) {
            return content -> {
                if (path == null) {
                    return;
                }
                GuidedDecisionTableView.Presenter dtPresenter = GuidedDecisionTableGraphEditorPresenter.this.modeller.addDecisionTable(path, placeRequest, (GuidedDecisionTableEditorContent)content, placeRequest.getParameter("readOnly", null) != null, null, null);
                GuidedDecisionTableGraphEditorPresenter.this.registerDocument(dtPresenter);
                this.onDocumentGraphEntryLoaded(dtPresenter);
                this.hideLoadingIndicator();
            };
        }

        private DefaultErrorCallback getLoadErrorCallback() {
            final CommandDrivenErrorCallback wrapped = GuidedDecisionTableGraphEditorPresenter.this.getNoSuchFileExceptionErrorCallback();
            DefaultErrorCallback callback = new DefaultErrorCallback(){

                public boolean error(Message message, Throwable throwable) {
                    LoadGraphLatch.this.hideLoadingIndicator();
                    return wrapped.error(message, throwable);
                }
            };
            return callback;
        }
    }
}

