/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.editor.clipboard.Clipboard;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.BaseMenu;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RowContextMenuView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectionsChangedEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@Dependent
public class RowContextMenu
extends BaseMenu
implements IsWidget,
RowContextMenuView.Presenter {
    private RowContextMenuView view;
    private Clipboard clipboard;

    @Inject
    public RowContextMenu(RowContextMenuView view, Clipboard clipboard) {
        this.view = view;
        this.clipboard = clipboard;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    @Override
    public void onDecisionTableSelectedEvent(@Observes DecisionTableSelectedEvent event) {
        super.onDecisionTableSelectedEvent(event);
    }

    @Override
    public void onDecisionTableSelectionsChangedEvent(@Observes DecisionTableSelectionsChangedEvent event) {
        super.onDecisionTableSelectionsChangedEvent(event);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    @Override
    public void show(int mx, int my) {
        this.view.show(mx, my);
    }

    @Override
    public void hide() {
        this.view.hide();
    }

    @Override
    public void initialise() {
        if (this.activeDecisionTable == null || !this.activeDecisionTable.getAccess().isEditable()) {
            this.disableMenuItems();
            return;
        }
        List selections = this.activeDecisionTable.getView().getModel().getSelectedCells();
        if (selections == null || selections.isEmpty()) {
            this.disableMenuItems();
            return;
        }
        HashMap<Integer, Boolean> rowUsage = new HashMap<Integer, Boolean>();
        for (GridData.SelectedCell sc : selections) {
            rowUsage.put(sc.getRowIndex(), true);
        }
        this.enableMenuItemsForClipboard();
        this.enableMenuItemsForRowOperations(rowUsage.keySet().size() == 1);
    }

    @Override
    public void onCut() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onCut();
        }
        this.hide();
    }

    @Override
    public void onCopy() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onCopy();
        }
        this.hide();
    }

    @Override
    public void onPaste() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onPaste();
        }
        this.hide();
    }

    @Override
    public void onInsertRowAbove() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onInsertRowAbove();
        }
        this.hide();
    }

    @Override
    public void onInsertRowBelow() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onInsertRowBelow();
        }
        this.hide();
    }

    @Override
    public void onDeleteSelectedRows() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.onDeleteSelectedRows();
        }
        this.hide();
    }

    private void disableMenuItems() {
        this.view.enableCutMenuItem(false);
        this.view.enableCopyMenuItem(false);
        this.view.enablePasteMenuItem(false);
        this.view.enableInsertRowAboveMenuItem(false);
        this.view.enableInsertRowBelowMenuItem(false);
        this.view.enableDeleteRowMenuItem(false);
    }

    private void enableMenuItemsForClipboard() {
        this.view.enableCutMenuItem(true);
        this.view.enableCopyMenuItem(true);
        this.view.enablePasteMenuItem(this.clipboard.hasData());
    }

    private void enableMenuItemsForRowOperations(boolean isSingleRow) {
        this.view.enableInsertRowAboveMenuItem(isSingleRow);
        this.view.enableInsertRowBelowMenuItem(isSingleRow);
        this.view.enableDeleteRowMenuItem(true);
    }
}

