/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.BaseMenu;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTablePinnedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.ext.widgets.common.client.menu.MenuItemDividerView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemFactory;
import org.uberfire.ext.widgets.common.client.menu.MenuItemHeaderView;
import org.uberfire.ext.widgets.common.client.menu.MenuItemWithIconView;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;

@Dependent
public class ViewMenuBuilder
extends BaseMenu
implements MenuFactory.CustomMenuBuilder {
    private TranslationService ts;
    private MenuItemFactory menuItemFactory;
    private GuidedDecisionTableModellerView.Presenter modeller;
    MenuItemFactory.MenuItemViewHolder<MenuItemHeaderView> miHeader;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miZoom125pct;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miZoom100pct;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miZoom75pct;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miZoom50pct;
    MenuItemFactory.MenuItemViewHolder<MenuItemDividerView> miSeparator;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miToggleMergeState;
    MenuItemFactory.MenuItemViewHolder<MenuItemWithIconView> miViewAuditLog;

    @Inject
    public ViewMenuBuilder(TranslationService ts, MenuItemFactory menuItemFactory) {
        this.ts = ts;
        this.menuItemFactory = menuItemFactory;
    }

    @PostConstruct
    public void setup() {
        this.miHeader = this.menuItemFactory.makeMenuItemHeader(this.ts.getTranslation("ViewMenu.zoom"));
        this.miZoom125pct = this.menuItemFactory.makeMenuItemWithIcon("125%", () -> this.onZoom(125));
        this.miZoom100pct = this.menuItemFactory.makeMenuItemWithIcon("100%", () -> this.onZoom(100));
        this.miZoom75pct = this.menuItemFactory.makeMenuItemWithIcon("75%", () -> this.onZoom(75));
        this.miZoom50pct = this.menuItemFactory.makeMenuItemWithIcon("50%", () -> this.onZoom(50));
        this.miSeparator = this.menuItemFactory.makeMenuItemDivider();
        this.miToggleMergeState = this.menuItemFactory.makeMenuItemWithIcon(this.ts.getTranslation("ViewMenu.merged"), this::onToggleMergeState);
        this.miViewAuditLog = this.menuItemFactory.makeMenuItemWithIcon(this.ts.getTranslation("ViewMenu.auditLog"), this::onViewAuditLog);
        ((MenuItemWithIconView)this.miZoom125pct.getMenuItemView()).setIconType(null);
        ((MenuItemWithIconView)this.miZoom100pct.getMenuItemView()).setIconType(IconType.CHECK);
        ((MenuItemWithIconView)this.miZoom75pct.getMenuItemView()).setIconType(null);
        ((MenuItemWithIconView)this.miZoom50pct.getMenuItemView()).setIconType(null);
        this.miToggleMergeState.getMenuItem().setEnabled(false);
        this.miViewAuditLog.getMenuItem().setEnabled(false);
    }

    public void setModeller(GuidedDecisionTableModellerView.Presenter modeller) {
        this.modeller = modeller;
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return (MenuItem)((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelMenu((String)this.ts.getTranslation("ViewMenu.title")).withItems(this.getEditMenuItems()).endMenu()).build().getItems().get(0);
    }

    List<MenuItem> getEditMenuItems() {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        menuItems.add(this.miHeader.getMenuItem());
        menuItems.add(this.miZoom125pct.getMenuItem());
        menuItems.add(this.miZoom100pct.getMenuItem());
        menuItems.add(this.miZoom75pct.getMenuItem());
        menuItems.add(this.miZoom50pct.getMenuItem());
        menuItems.add(this.miSeparator.getMenuItem());
        menuItems.add(this.miToggleMergeState.getMenuItem());
        menuItems.add(this.miViewAuditLog.getMenuItem());
        return menuItems;
    }

    @Override
    public void onDecisionTableSelectedEvent(@Observes DecisionTableSelectedEvent event) {
        super.onDecisionTableSelectedEvent(event);
        this.enableZoomMenu(event.getPresenter().isPresent());
    }

    @Override
    public void initialise() {
        if (this.activeDecisionTable == null || !this.activeDecisionTable.getAccess().isEditable()) {
            this.miToggleMergeState.getMenuItem().setEnabled(false);
            ((MenuItemWithIconView)this.miToggleMergeState.getMenuItemView()).setIconType(null);
            this.miViewAuditLog.getMenuItem().setEnabled(false);
        } else {
            this.miToggleMergeState.getMenuItem().setEnabled(true);
            ((MenuItemWithIconView)this.miToggleMergeState.getMenuItemView()).setIconType((IconType)(this.activeDecisionTable.isMerged() ? IconType.CHECK : null));
            this.miViewAuditLog.getMenuItem().setEnabled(true);
        }
    }

    public void onDecisionTablePinnedEvent(@Observes DecisionTablePinnedEvent event) {
        GuidedDecisionTableModellerView.Presenter modeller = event.getPresenter();
        if (modeller == null) {
            return;
        }
        if (!modeller.equals(this.modeller)) {
            return;
        }
        this.enableZoomMenu(!event.isPinned());
    }

    private void enableZoomMenu(boolean enabled) {
        this.miZoom125pct.getMenuItem().setEnabled(enabled);
        this.miZoom100pct.getMenuItem().setEnabled(enabled);
        this.miZoom75pct.getMenuItem().setEnabled(enabled);
        this.miZoom50pct.getMenuItem().setEnabled(enabled);
    }

    void onZoom(int zoom) {
        this.modeller.setZoom(zoom);
        ((MenuItemWithIconView)this.miZoom125pct.getMenuItemView()).setIconType(null);
        ((MenuItemWithIconView)this.miZoom100pct.getMenuItemView()).setIconType(null);
        ((MenuItemWithIconView)this.miZoom75pct.getMenuItemView()).setIconType(null);
        ((MenuItemWithIconView)this.miZoom50pct.getMenuItemView()).setIconType(null);
        switch (zoom) {
            case 125: {
                ((MenuItemWithIconView)this.miZoom125pct.getMenuItemView()).setIconType(IconType.CHECK);
                break;
            }
            case 100: {
                ((MenuItemWithIconView)this.miZoom100pct.getMenuItemView()).setIconType(IconType.CHECK);
                break;
            }
            case 75: {
                ((MenuItemWithIconView)this.miZoom75pct.getMenuItemView()).setIconType(IconType.CHECK);
                break;
            }
            case 50: {
                ((MenuItemWithIconView)this.miZoom50pct.getMenuItemView()).setIconType(IconType.CHECK);
            }
        }
    }

    void onToggleMergeState() {
        if (this.activeDecisionTable != null) {
            boolean newMergeState = !this.activeDecisionTable.isMerged();
            ((MenuItemWithIconView)this.miToggleMergeState.getMenuItemView()).setIconType((IconType)(newMergeState ? IconType.CHECK : null));
            this.activeDecisionTable.setMerged(newMergeState);
        }
    }

    void onViewAuditLog() {
        if (this.activeDecisionTable != null) {
            this.activeDecisionTable.showAuditLog();
        }
    }

    public static interface HasAuditLog {
        public void showAuditLog();
    }

    public static interface HasMergedView {
        public void setMerged(boolean var1);

        public boolean isMerged();
    }

    public static interface SupportsZoom {
        public void setZoom(int var1);
    }
}

