/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.handlers;

import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.screens.guided.dtable.client.handlers.GuidedDecisionTableOptions;
import org.drools.workbench.screens.guided.dtable.client.resources.GuidedDecisionTableResources;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.type.GuidedDTableResourceType;
import org.drools.workbench.screens.guided.dtable.client.wizard.NewGuidedDecisionTableWizardHelper;
import org.drools.workbench.screens.guided.dtable.service.GuidedDecisionTableEditorService;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.widgets.client.handlers.DefaultNewResourceHandler;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.kie.workbench.common.widgets.client.handlers.NewResourceSuccessEvent;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class NewGuidedDecisionTableHandler
extends DefaultNewResourceHandler {
    private PlaceManager placeManager;
    private Caller<GuidedDecisionTableEditorService> service;
    private GuidedDTableResourceType resourceType;
    private GuidedDecisionTableOptions options;
    private BusyIndicatorView busyIndicatorView;
    private NewGuidedDecisionTableWizardHelper helper;
    private NewResourcePresenter newResourcePresenter;

    public NewGuidedDecisionTableHandler() {
    }

    @Inject
    public NewGuidedDecisionTableHandler(PlaceManager placeManager, Caller<GuidedDecisionTableEditorService> service, GuidedDTableResourceType resourceType, GuidedDecisionTableOptions options, BusyIndicatorView busyIndicatorView, NewGuidedDecisionTableWizardHelper helper) {
        this.placeManager = placeManager;
        this.service = service;
        this.resourceType = resourceType;
        this.options = options;
        this.busyIndicatorView = busyIndicatorView;
        this.helper = helper;
    }

    @PostConstruct
    private void setupExtensions() {
        this.extensions.add(new Pair((Object)GuidedDecisionTableConstants.INSTANCE.Options(), (Object)this.options));
    }

    public String getDescription() {
        return GuidedDecisionTableConstants.INSTANCE.NewGuidedDecisionTableDescription();
    }

    public IsWidget getIcon() {
        return new Image(GuidedDecisionTableResources.INSTANCE.images().typeGuidedDecisionTable());
    }

    public ResourceTypeDefinition getResourceType() {
        return this.resourceType;
    }

    public void create(Package pkg, String baseFileName, NewResourcePresenter presenter) {
        this.newResourcePresenter = presenter;
        if (!this.options.isUsingWizard()) {
            this.createEmptyDecisionTable(pkg.getPackageMainResourcesPath(), baseFileName);
        } else {
            this.createDecisionTableWithWizard(pkg.getPackageMainResourcesPath(), baseFileName);
        }
    }

    private void createEmptyDecisionTable(Path contextPath, String baseFileName) {
        GuidedDecisionTable52 model = new GuidedDecisionTable52();
        model.setTableFormat(this.options.getTableFormat());
        model.setHitPolicy(this.options.getHitPolicy());
        if (GuidedDecisionTable52.HitPolicy.RESOLVED_HIT.equals((Object)this.options.getHitPolicy())) {
            MetadataCol52 metadataCol52 = new MetadataCol52();
            metadataCol52.setMetadata("ResolvedHitPriorityOverRow");
            model.getMetadataCols().add(metadataCol52);
        }
        model.setTableName(baseFileName);
        RemoteCallback<Path> onSaveSuccessCallback = this.getSuccessCallback(this.newResourcePresenter);
        this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Saving());
        ((GuidedDecisionTableEditorService)this.service.call(path -> {
            this.busyIndicatorView.hideBusyIndicator();
            onSaveSuccessCallback.callback(path);
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.busyIndicatorView))).create(contextPath, this.buildFileName(baseFileName, (ResourceTypeDefinition)this.resourceType), (Object)model, "");
    }

    private void createDecisionTableWithWizard(Path contextPath, String baseFileName) {
        this.helper.createNewGuidedDecisionTable(contextPath, baseFileName, this.options.getTableFormat(), this.options.getHitPolicy(), (HasBusyIndicator)this.busyIndicatorView, this.getSuccessCallback(this.newResourcePresenter));
    }

    protected RemoteCallback<Path> getSuccessCallback(NewResourcePresenter presenter) {
        return path -> {
            presenter.complete();
            this.notifySuccess();
            this.newResourceSuccessEvent.fire((Object)new NewResourceSuccessEvent(path));
            this.placeManager.goTo(path);
        };
    }

    public int order() {
        return -20;
    }
}

