/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis;

import com.google.gwt.webworker.client.MessageEvent;
import com.google.gwt.webworker.client.MessageHandler;
import com.google.gwt.webworker.client.Worker;
import java.util.HashSet;
import java.util.logging.Logger;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.AnalysisReporter;
import org.drools.workbench.services.verifier.api.client.Status;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.reporting.Issues;
import org.drools.workbench.services.verifier.plugin.client.api.WebWorkerException;
import org.drools.workbench.services.verifier.plugin.client.api.WebWorkerLogMessage;
import org.jboss.errai.enterprise.client.jaxrs.MarshallingWrapper;
import org.uberfire.commons.validation.PortablePreconditions;

public class Receiver {
    private static final Logger LOGGER = Logger.getLogger("DTable Analyzer");
    private AnalysisReporter reporter;

    public Receiver(AnalysisReporter reporter) {
        this.reporter = (AnalysisReporter)PortablePreconditions.checkNotNull((String)"reporter", (Object)reporter);
    }

    public void activate() {
        this.reporter.activate();
    }

    private void received(String json) {
        try {
            LOGGER.finest("Receiving: " + json);
            Object o = MarshallingWrapper.fromJSON((String)json);
            if (o instanceof WebWorkerLogMessage) {
                LOGGER.info("Web Worker log message: " + ((WebWorkerLogMessage)o).getMessage());
            } else if (o instanceof WebWorkerException) {
                LOGGER.severe("Web Worker failed: " + ((WebWorkerException)o).getMessage());
            } else if (o instanceof Status) {
                this.reporter.sendStatus((Status)o);
            } else if (o instanceof Issues) {
                this.reporter.sendReport(new HashSet<Issue>(((Issues)o).getSet()));
            }
        }
        catch (Exception e) {
            LOGGER.severe("Could not manage received json: " + e.getMessage() + " JSON: " + json);
        }
    }

    public void setUp(Worker worker) {
        worker.setOnMessage(new MessageHandler(){

            public void onMessage(MessageEvent messageEvent) {
                Receiver.this.received(messageEvent.getDataAsString());
            }
        });
    }
}

