/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.cellview.client.HasKeyboardPagingPolicy;
import com.google.gwt.user.cellview.client.HasKeyboardSelectionPolicy;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisLineCell;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReportScreen;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.AnalysisReportScreenView;
import org.drools.workbench.screens.guided.dtable.client.widget.analysis.panel.IssuePresenter;
import org.drools.workbench.services.verifier.api.client.reporting.Issue;
import org.drools.workbench.services.verifier.api.client.resources.i18n.AnalysisConstants;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class AnalysisReportScreenViewImpl
extends Composite
implements AnalysisReportScreenView,
RequiresResize {
    private AnalysisReportScreen presenter;
    @DataField(value="progressPanel")
    Element progressPanel = DOM.createDiv();
    @DataField(value="issuesList")
    CellList<Issue> issuesList = new CellList((Cell)new AnalysisLineCell());
    @DataField(value="issueDetailsView")
    Widget issueDetailsView;
    private IssuePresenter issueDetails;

    public AnalysisReportScreenViewImpl() {
    }

    @Inject
    public AnalysisReportScreenViewImpl(IssuePresenter issuePresenter) {
        this.issueDetails = issuePresenter;
        this.issueDetailsView = issuePresenter.asWidget();
    }

    @PostConstruct
    private void init() {
        this.issuesList.setKeyboardPagingPolicy(HasKeyboardPagingPolicy.KeyboardPagingPolicy.INCREASE_RANGE);
        this.issuesList.setKeyboardSelectionPolicy(HasKeyboardSelectionPolicy.KeyboardSelectionPolicy.BOUND_TO_SELECTION);
        this.issuesList.setSelectionModel(this.getSelectionModel());
    }

    private SingleSelectionModel<Issue> getSelectionModel() {
        final SingleSelectionModel selectionModel = new SingleSelectionModel();
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                AnalysisReportScreenViewImpl.this.presenter.onSelect((Issue)selectionModel.getSelectedObject());
            }
        });
        return selectionModel;
    }

    @Override
    public void setUpDataProvider(ListDataProvider<Issue> dataProvider) {
        dataProvider.addDataDisplay(this.issuesList);
    }

    @Override
    public void setPresenter(AnalysisReportScreen presenter) {
        this.presenter = presenter;
    }

    @Override
    public void showIssue(Issue issue) {
        this.issueDetails.show(issue);
    }

    @Override
    public void clearIssue() {
        this.issueDetails.clear();
    }

    @Override
    public void showStatusComplete() {
        this.progressPanel.getStyle().setColor("WHITE");
        this.progressPanel.getStyle().setBackgroundColor("GREEN");
        this.progressPanel.setInnerHTML(AnalysisConstants.INSTANCE.AnalysisComplete());
    }

    @Override
    public void showStatusTitle(int start, int end, int totalCheckCount) {
        this.progressPanel.getStyle().setColor("BLACK");
        this.progressPanel.getStyle().setBackgroundColor("#ffc");
        this.progressPanel.setInnerHTML(AnalysisConstants.INSTANCE.AnalysingChecks0To1Of2(start, end, totalCheckCount));
    }

    public void onResize() {
        this.setHeight(this.getParent().getOffsetHeight() + "px");
        this.setWidth(this.getWidth() + "px");
    }

    private int getWidth() {
        int width = this.getParent().getOffsetWidth() - 15;
        if (width < 0) {
            return 0;
        }
        return width;
    }
}

