/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.event.NodeMouseMoveEvent;
import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.resources.GuidedDecisionTableResources;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.table.BoundaryTransformMediator;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerBoundsHelper;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.accordion.GuidedDecisionTableAccordion;
import org.drools.workbench.screens.guided.dtable.client.widget.table.accordion.GuidedDecisionTableAccordionItem;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.AttributeColumnConfigRow;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.workbench.common.widgets.client.ruleselector.RuleSelector;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;
import org.uberfire.ext.wires.core.grids.client.model.Bounds;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;
import org.uberfire.mvp.ParameterizedCommand;

public class GuidedDecisionTableModellerViewImpl
extends Composite
implements GuidedDecisionTableModellerView {
    private static final double VP_SCALE = 1.0;
    private static GuidedDecisionTableModellerViewImplUiBinder uiBinder = (GuidedDecisionTableModellerViewImplUiBinder)GWT.create(GuidedDecisionTableModellerViewImplUiBinder.class);
    private final RuleSelector ruleSelector = new RuleSelector();
    private final GuidedDecisionTableModellerBoundsHelper boundsHelper = new GuidedDecisionTableModellerBoundsHelper();
    @UiField
    FlowPanel accordionContainer;
    @UiField
    Button addColumn;
    @UiField
    Button editColumns;
    @UiField(provided=true)
    GridLienzoPanel gridPanel = new GridLienzoPanel(){

        public void onResize() {
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    int width = this.getParent().getOffsetWidth();
                    int height = this.getParent().getOffsetHeight();
                    if (width != 0 && height != 0) {
                        domElementContainer.setPixelSize(width, height);
                        lienzoPanel.setPixelSize(width, height);
                    }
                    TransformMediator restriction = GuidedDecisionTableModellerViewImpl.this.mousePanMediator.getTransformMediator();
                    Transform transform = restriction.adjust(GuidedDecisionTableModellerViewImpl.this.gridLayer.getViewport().getTransform(), GuidedDecisionTableModellerViewImpl.this.gridLayer.getVisibleBounds());
                    GuidedDecisionTableModellerViewImpl.this.gridLayer.getViewport().setTransform(transform);
                    GuidedDecisionTableModellerViewImpl.this.gridLayer.draw();
                }
            });
        }
    };
    @Inject
    private GuidedDecisionTableAccordion guidedDecisionTableAccordion;
    private VerticalPanel attributeConfigWidget = this.makeDefaultPanel();
    private VerticalPanel metaDataConfigWidget = this.makeDefaultPanel();
    private VerticalPanel conditionsConfigWidget = this.makeDefaultPanel();
    private VerticalPanel actionsConfigWidget = this.makeDefaultPanel();
    private GuidedDecisionTableAccordion accordion;
    private TransformMediator defaultTransformMediator;
    private GuidedDecisionTableModellerView.Presenter presenter;
    private final DefaultGridLayer gridLayer = this.defaultGridLayer();
    private final RestrictedMousePanMediator mousePanMediator = this.restrictedMousePanMediator();

    public GuidedDecisionTableModellerViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    DefaultGridLayer defaultGridLayer() {
        return new DefaultGridLayer(){

            public void enterPinnedMode(GridWidget gridWidget, final Command onStartCommand) {
                super.enterPinnedMode(gridWidget, new Command(){

                    public void execute() {
                        onStartCommand.execute();
                        GuidedDecisionTableModellerViewImpl.this.presenter.onViewPinned(true);
                    }
                });
            }

            public void exitPinnedMode(final Command onCompleteCommand) {
                super.exitPinnedMode(new Command(){

                    public void execute() {
                        onCompleteCommand.execute();
                        GuidedDecisionTableModellerViewImpl.this.presenter.onViewPinned(false);
                    }
                });
            }

            public TransformMediator getDefaultTransformMediator() {
                return GuidedDecisionTableModellerViewImpl.this.defaultTransformMediator;
            }
        };
    }

    RestrictedMousePanMediator restrictedMousePanMediator() {
        return new RestrictedMousePanMediator((GridLayer)this.gridLayer){

            protected void onMouseMove(NodeMouseMoveEvent event) {
                super.onMouseMove(event);
                GuidedDecisionTableModellerViewImpl.this.presenter.updateRadar();
            }
        };
    }

    protected void initWidget(Widget widget) {
        super.initWidget(widget);
    }

    public void init(GuidedDecisionTableModellerView.Presenter presenter) {
        this.presenter = presenter;
        this.setupAccordion(presenter);
    }

    @PostConstruct
    public void setup() {
        this.setupSubMenu();
        this.setupGridPanel();
    }

    void setupGridPanel() {
        Transform transform = new Transform().scale(1.0);
        this.gridPanel.getViewport().setTransform(transform);
        this.defaultTransformMediator = new BoundaryTransformMediator(this);
        this.mousePanMediator.setTransformMediator(this.defaultTransformMediator);
        this.gridPanel.getViewport().getMediators().push((IMediator)this.mousePanMediator);
        this.mousePanMediator.setBatchDraw(true);
        this.gridPanel.add(this.gridLayer);
        this.gridPanel.getElement().setId("dtable_container_" + Document.get().createUniqueId());
    }

    void setupSubMenu() {
        this.getAddColumn().addClickHandler(e -> this.addColumn());
        this.getEditColumns().addClickHandler(e -> this.editColumns());
    }

    void addColumn() {
        this.getPresenter().openNewGuidedDecisionTableColumnWizard();
    }

    void editColumns() {
        this.toggleClassName((Widget)this.getAccordionContainer(), GuidedDecisionTableResources.INSTANCE.css().openedAccordion());
        this.toggleClassName((Widget)this.getEditColumns(), "active");
    }

    void toggleClassName(Widget widget, String className) {
        widget.getElement().toggleClassName(className);
    }

    public void onResize() {
        this.gridPanel.onResize();
        this.getPresenter().updateRadar();
    }

    public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
        return this.gridPanel.addKeyDownHandler(handler);
    }

    public HandlerRegistration addContextMenuHandler(ContextMenuHandler handler) {
        return this.gridPanel.addDomHandler((EventHandler)handler, ContextMenuEvent.getType());
    }

    public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
        return this.gridPanel.addMouseDownHandler(handler);
    }

    Widget ruleInheritanceWidget() {
        FlowPanel result = this.makeFlowPanel();
        result.setStyleName(GuidedDecisionTableResources.INSTANCE.css().ruleInheritance());
        result.add((Widget)this.ruleInheritanceLabel());
        result.add(this.ruleSelector());
        return result;
    }

    FlowPanel makeFlowPanel() {
        return new FlowPanel();
    }

    Widget ruleSelector() {
        this.getRuleSelector().setEnabled(false);
        this.getRuleSelector().addValueChangeHandler(e -> this.presenter.getActiveDecisionTable().setParentRuleName((String)e.getValue()));
        return this.getRuleSelector();
    }

    Label ruleInheritanceLabel() {
        Label label = new Label(GuidedDecisionTableConstants.INSTANCE.AllTheRulesInherit());
        label.setStyleName(GuidedDecisionTableResources.INSTANCE.css().ruleInheritanceLabel());
        return label;
    }

    @Override
    public void clear() {
        this.gridLayer.removeAll();
    }

    @Override
    public void addDecisionTable(GuidedDecisionTableView gridWidget) {
        if (this.gridLayer.getGridWidgets().isEmpty()) {
            Point2D translation = this.getTranslation(gridWidget);
            Transform t = this.gridLayer.getViewport().getTransform();
            t.translate(translation.getX(), translation.getY());
        }
        this.gridLayer.add((IPrimitive)gridWidget);
        this.gridLayer.batch();
    }

    private Point2D getTranslation(GuidedDecisionTableView gridWidget) {
        double boundsPadding = 20.0;
        Transform t = this.gridLayer.getViewport().getTransform();
        double requiredTranslateX = 20.0 - gridWidget.getX();
        double requiredTranslateY = 20.0 - gridWidget.getY();
        double actualTranslateX = t.getTranslateX();
        double actualTranslateY = t.getTranslateY();
        double dx = requiredTranslateX - actualTranslateX;
        double dy = requiredTranslateY - actualTranslateY;
        return new Point2D(dx, dy);
    }

    @Override
    public void removeDecisionTable(GuidedDecisionTableView gridWidget, Command afterRemovalCommand) {
        if (gridWidget == null) {
            return;
        }
        Command remove = () -> {
            this.gridLayer.remove((IPrimitive)gridWidget);
            this.gridLayer.batch();
            afterRemovalCommand.execute();
        };
        if (this.gridLayer.isGridPinned()) {
            GridPinnedModeManager.PinnedContext context = this.gridLayer.getPinnedContext();
            if (gridWidget.equals(context.getGridWidget())) {
                this.gridLayer.exitPinnedMode(remove);
            }
        } else {
            remove.execute();
        }
    }

    @Override
    public void setEnableColumnCreation(boolean enabled) {
        this.addColumn.setEnabled(enabled);
    }

    @Override
    public void refreshRuleInheritance(String selectedParentRuleName, Collection<String> availableParentRuleNames) {
        this.ruleSelector.setRuleName(selectedParentRuleName);
        this.ruleSelector.setRuleNames(availableParentRuleNames);
    }

    private VerticalPanel makeDefaultPanel() {
        return new VerticalPanel(){
            {
                this.add((Widget)GuidedDecisionTableModellerViewImpl.this.blankSlate());
            }
        };
    }

    Label blankSlate() {
        String disabledLabelStyle = "text-muted";
        final String noColumns = GuidedDecisionTableConstants.INSTANCE.NoColumnsAvailable();
        return new Label(){
            {
                this.setText(noColumns);
                this.setStyleName("text-muted");
            }
        };
    }

    @Override
    public void refreshAttributeWidget(List<AttributeCol52> attributeColumns) {
        this.getAttributeConfigWidget().clear();
        if (attributeColumns == null || attributeColumns.isEmpty()) {
            this.getAccordion().getItem(GuidedDecisionTableAccordionItem.Type.ATTRIBUTE).setOpen(false);
            this.getAttributeConfigWidget().add((Widget)this.blankSlate());
            return;
        }
        for (AttributeCol52 attributeColumn : attributeColumns) {
            AttributeColumnConfigRow attributeColumnConfigRow = new AttributeColumnConfigRow();
            attributeColumnConfigRow.init(attributeColumn, this.getPresenter());
            this.getAttributeConfigWidget().add(attributeColumnConfigRow.getView());
        }
    }

    @Override
    public void refreshMetaDataWidget(List<MetadataCol52> metaDataColumns) {
        this.metaDataConfigWidget.clear();
        if (metaDataColumns == null || metaDataColumns.isEmpty()) {
            this.accordion.getItem(GuidedDecisionTableAccordionItem.Type.METADATA).setOpen(false);
            this.metaDataConfigWidget.add((Widget)this.blankSlate());
            return;
        }
        boolean isEditable = this.presenter.isActiveDecisionTableEditable();
        for (MetadataCol52 metaDataColumn : metaDataColumns) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
            SmallLabel label = this.makeColumnLabel(metaDataColumn);
            hp.add((Widget)label);
            final MetadataCol52 originalColumn = metaDataColumn;
            final CheckBox chkHideColumn = new CheckBox(GuidedDecisionTableConstants.INSTANCE.HideThisColumn() + ":");
            chkHideColumn.setValue(Boolean.valueOf(metaDataColumn.isHideColumn()));
            chkHideColumn.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    MetadataCol52 editedColumn = originalColumn.cloneColumn();
                    editedColumn.setHideColumn(chkHideColumn.getValue().booleanValue());
                    GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().updateColumn(originalColumn, editedColumn);
                }
            });
            hp.add((Widget)chkHideColumn);
            if (isEditable) {
                hp.add(this.deleteAnchor(e -> {
                    String ms = GuidedDecisionTableConstants.INSTANCE.DeleteActionColumnWarning(metaDataColumn.getMetadata());
                    if (Window.confirm((String)ms)) {
                        this.presenter.getActiveDecisionTable().deleteColumn(metaDataColumn);
                    }
                }));
            }
            this.metaDataConfigWidget.add((Widget)hp);
        }
    }

    private SmallLabel makeColumnLabel(MetadataCol52 metaDataColumn) {
        SmallLabel label = new SmallLabel(metaDataColumn.getMetadata());
        ColumnUtilities.setColumnLabelStyleWhenHidden(label, metaDataColumn.isHideColumn());
        return label;
    }

    @Override
    public void refreshConditionsWidget(List<CompositeColumn<? extends BaseColumn>> conditionColumns) {
        this.conditionsConfigWidget.clear();
        if (conditionColumns == null || conditionColumns.isEmpty()) {
            this.accordion.getItem(GuidedDecisionTableAccordionItem.Type.CONDITION).setOpen(false);
            this.conditionsConfigWidget.add((Widget)this.blankSlate());
            return;
        }
        VerticalPanel patternsPanel = new VerticalPanel();
        this.conditionsConfigWidget.add((Widget)patternsPanel);
        final boolean isEditable = this.presenter.isActiveDecisionTableEditable();
        for (CompositeColumn<? extends BaseColumn> conditionColumn : conditionColumns) {
            if (conditionColumn instanceof Pattern52) {
                final Pattern52 p = (Pattern52)conditionColumn;
                VerticalPanel patternPanel = new VerticalPanel();
                VerticalPanel conditionsPanel = new VerticalPanel();
                HorizontalPanel patternHeaderPanel = new HorizontalPanel();
                Label patternLabel = this.makePatternLabel(p);
                patternHeaderPanel.add((Widget)patternLabel);
                patternPanel.add((Widget)patternHeaderPanel);
                patternPanel.add((Widget)conditionsPanel);
                patternsPanel.add((Widget)patternPanel);
                List conditions = p.getChildColumns();
                for (final ConditionCol52 c : conditions) {
                    HorizontalPanel hp = new HorizontalPanel();
                    SmallLabel conditionLabel = this.makeColumnLabel(c);
                    hp.add((Widget)conditionLabel);
                    FlowPanel buttons = new FlowPanel(){
                        {
                            this.add(GuidedDecisionTableModellerViewImpl.this.editCondition(p, c));
                            if (isEditable) {
                                this.add(GuidedDecisionTableModellerViewImpl.this.removeCondition(c));
                            }
                        }
                    };
                    hp.add((Widget)buttons);
                    conditionsPanel.add((Widget)hp);
                }
                continue;
            }
            if (!(conditionColumn instanceof BRLConditionColumn)) continue;
            final BRLConditionColumn brl = (BRLConditionColumn)conditionColumn;
            HorizontalPanel patternHeaderPanel = new HorizontalPanel();
            HorizontalPanel patternPanel = new HorizontalPanel();
            SmallLabel patternLabel = this.makePatternLabel(brl);
            patternPanel.add((Widget)patternLabel);
            patternHeaderPanel.add((Widget)patternPanel);
            FlowPanel buttons = new FlowPanel(){
                {
                    this.add(GuidedDecisionTableModellerViewImpl.this.editCondition(brl));
                    if (isEditable) {
                        this.add(GuidedDecisionTableModellerViewImpl.this.removeCondition((ConditionCol52)brl));
                    }
                }
            };
            patternPanel.add((Widget)buttons);
            patternsPanel.add((Widget)patternHeaderPanel);
        }
    }

    private Label makePatternLabel(Pattern52 p) {
        StringBuilder patternLabel = new StringBuilder();
        String factType = p.getFactType();
        String boundName = p.getBoundName();
        if (factType != null && factType.length() > 0) {
            if (p.isNegated()) {
                patternLabel.append(GuidedDecisionTableConstants.INSTANCE.negatedPattern()).append(" ").append(factType);
            } else {
                patternLabel.append(factType).append(" [").append(boundName).append("]");
            }
        }
        return new Label(patternLabel.toString());
    }

    private SmallLabel makePatternLabel(BRLConditionColumn brl) {
        StringBuilder sb = new StringBuilder();
        sb.append(brl.getHeader());
        return new SmallLabel(sb.toString());
    }

    private SmallLabel makeColumnLabel(ConditionCol52 cc) {
        StringBuilder sb = new StringBuilder();
        if (cc.isBound()) {
            sb.append(cc.getBinding());
            sb.append(" : ");
        }
        sb.append(cc.getHeader());
        SmallLabel label = new SmallLabel(sb.toString());
        if (cc.isHideColumn()) {
            label.setStylePrimaryName(GuidedDecisionTableResources.INSTANCE.css().columnLabelHidden());
        }
        return label;
    }

    private Widget editCondition(Pattern52 origPattern, ConditionCol52 origCol) {
        return this.makeEditColumnWidget(GuidedDecisionTableConstants.INSTANCE.EditThisColumnsConfiguration(), () -> this.presenter.getActiveDecisionTable().editCondition(origPattern, origCol));
    }

    private Widget editCondition(BRLConditionColumn origCol) {
        return this.makeEditColumnWidget(GuidedDecisionTableConstants.INSTANCE.EditThisColumnsConfiguration(), () -> this.presenter.getActiveDecisionTable().editCondition(origCol));
    }

    private Widget makeEditColumnWidget(String caption, Command command) {
        return this.editAnchor(e -> command.execute());
    }

    private Widget editAnchor(ClickHandler clickHandler) {
        return this.anchor(GuidedDecisionTableConstants.INSTANCE.Edit(), clickHandler);
    }

    private Widget deleteAnchor(ClickHandler clickHandler) {
        return this.anchor(GuidedDecisionTableConstants.INSTANCE.Delete(), clickHandler);
    }

    private Anchor anchor(final String text, final ClickHandler clickHandler) {
        return new Anchor(){
            {
                this.setText(text);
                this.addClickHandler(clickHandler);
            }
        };
    }

    private Widget removeCondition(ConditionCol52 column) {
        if (column instanceof BRLConditionColumn) {
            return this.makeRemoveConditionWidget(column, (ParameterizedCommand<Command>)((ParameterizedCommand)command -> {
                if (!this.presenter.getActiveDecisionTable().canConditionBeDeleted((BRLConditionColumn)column)) {
                    Window.alert((String)GuidedDecisionTableConstants.INSTANCE.UnableToDeleteConditionColumn0(column.getHeader()));
                    return;
                }
                command.execute();
            }));
        }
        return this.makeRemoveConditionWidget(column, (ParameterizedCommand<Command>)((ParameterizedCommand)command -> {
            if (!this.presenter.getActiveDecisionTable().canConditionBeDeleted(column)) {
                Window.alert((String)GuidedDecisionTableConstants.INSTANCE.UnableToDeleteConditionColumn0(column.getHeader()));
                return;
            }
            command.execute();
        }));
    }

    private Widget makeRemoveConditionWidget(ConditionCol52 column, ParameterizedCommand<Command> command) {
        ClickHandler clickHandler = e -> command.execute(() -> {
            String cm = GuidedDecisionTableConstants.INSTANCE.DeleteConditionColumnWarning0(column.getHeader());
            if (Window.confirm((String)cm)) {
                this.presenter.getActiveDecisionTable().deleteColumn(column);
            }
        });
        return this.deleteAnchor(clickHandler);
    }

    @Override
    public void refreshActionsWidget(List<ActionCol52> actionColumns) {
        this.actionsConfigWidget.clear();
        if (actionColumns == null || actionColumns.isEmpty()) {
            this.accordion.getItem(GuidedDecisionTableAccordionItem.Type.ACTION).setOpen(false);
            this.actionsConfigWidget.add((Widget)this.blankSlate());
            return;
        }
        VerticalPanel actionsPanel = new VerticalPanel();
        this.actionsConfigWidget.add((Widget)actionsPanel);
        final boolean isEditable = this.presenter.isActiveDecisionTableEditable();
        for (final ActionCol52 actionColumn : actionColumns) {
            HorizontalPanel hp = new HorizontalPanel();
            SmallLabel actionLabel = this.makeColumnLabel(actionColumn);
            hp.add((Widget)actionLabel);
            FlowPanel buttons = new FlowPanel(){
                {
                    this.add(GuidedDecisionTableModellerViewImpl.this.editAction(actionColumn));
                    if (isEditable) {
                        this.add(GuidedDecisionTableModellerViewImpl.this.deleteAnchor(e -> {
                            String cm = GuidedDecisionTableConstants.INSTANCE.DeleteActionColumnWarning(actionColumn.getHeader());
                            if (Window.confirm((String)cm)) {
                                GuidedDecisionTableModellerViewImpl.this.presenter.getActiveDecisionTable().deleteColumn(actionColumn);
                            }
                        }));
                    }
                }
            };
            hp.add((Widget)buttons);
            actionsPanel.add((Widget)hp);
        }
    }

    private SmallLabel makeColumnLabel(ActionCol52 actionColumn) {
        SmallLabel label = new SmallLabel(actionColumn.getHeader());
        if (actionColumn.isHideColumn()) {
            label.setStylePrimaryName(GuidedDecisionTableResources.INSTANCE.css().columnLabelHidden());
        }
        return label;
    }

    private Widget editAction(ActionCol52 actionColumn) {
        return this.makeEditColumnWidget(GuidedDecisionTableConstants.INSTANCE.EditThisActionColumnConfiguration(), () -> this.presenter.getActiveDecisionTable().editAction(actionColumn));
    }

    @Override
    public void refreshColumnsNote(boolean hasColumnDefinitions) {
        this.getGuidedDecisionTableAccordion().setColumnsNoteInfoHidden(hasColumnDefinitions);
    }

    @Override
    public void setZoom(int zoom) {
        Transform transform = new Transform();
        double tx = this.gridPanel.getViewport().getTransform().getTranslateX();
        double ty = this.gridPanel.getViewport().getTransform().getTranslateY();
        transform.translate(tx, ty);
        transform.scale((double)zoom / 100.0);
        this.gridPanel.getViewport().setTransform(transform);
        TransformMediator restriction = this.mousePanMediator.getTransformMediator();
        Transform newTransform = restriction.adjust(transform, this.gridLayer.getVisibleBounds());
        this.gridPanel.getViewport().setTransform(newTransform);
        this.gridPanel.getViewport().batch();
    }

    @Override
    public void onInsertColumn() {
        this.addColumn();
    }

    @Override
    public GridLayer getGridLayerView() {
        return this.gridLayer;
    }

    @Override
    public GridLienzoPanel getGridPanel() {
        return this.gridPanel;
    }

    @Override
    public Bounds getBounds() {
        if (this.presenter == null) {
            return this.boundsHelper.getBounds(Collections.emptySet());
        }
        return this.boundsHelper.getBounds(this.presenter.getAvailableDecisionTables());
    }

    public void select(GridWidget selectedGridWidget) {
        this.ruleSelector.setEnabled(true);
        this.gridLayer.select(selectedGridWidget);
    }

    public void selectLinkedColumn(GridColumn<?> link) {
        this.gridLayer.selectLinkedColumn(link);
    }

    public Set<GridWidget> getGridWidgets() {
        return this.gridLayer.getGridWidgets();
    }

    GuidedDecisionTableAccordion getGuidedDecisionTableAccordion() {
        return this.guidedDecisionTableAccordion;
    }

    void setupAccordion(GuidedDecisionTableModellerView.Presenter presenter) {
        this.accordion = this.makeAccordion(presenter);
        Widget widget = this.asWidget(this.accordion);
        this.getAccordionContainer().add(widget);
        this.getAccordionContainer().add(this.ruleInheritanceWidget());
    }

    FlowPanel getAccordionContainer() {
        return this.accordionContainer;
    }

    Widget asWidget(GuidedDecisionTableAccordion accordion) {
        GuidedDecisionTableAccordion.View accordionView = accordion.getView();
        return ElementWrapperWidget.getWidget((HTMLElement)accordionView.getElement());
    }

    GuidedDecisionTableAccordion makeAccordion(GuidedDecisionTableModellerView.Presenter presenter) {
        GuidedDecisionTableAccordion accordion = this.getGuidedDecisionTableAccordion();
        accordion.addItem(GuidedDecisionTableAccordionItem.Type.ATTRIBUTE, (Widget)this.getAttributeConfigWidget());
        accordion.addItem(GuidedDecisionTableAccordionItem.Type.METADATA, (Widget)this.getMetaDataConfigWidget());
        accordion.addItem(GuidedDecisionTableAccordionItem.Type.CONDITION, (Widget)this.getConditionsConfigWidget());
        accordion.addItem(GuidedDecisionTableAccordionItem.Type.ACTION, (Widget)this.getActionsConfigWidget());
        return accordion;
    }

    VerticalPanel getAttributeConfigWidget() {
        return this.attributeConfigWidget;
    }

    VerticalPanel getMetaDataConfigWidget() {
        return this.metaDataConfigWidget;
    }

    VerticalPanel getConditionsConfigWidget() {
        return this.conditionsConfigWidget;
    }

    VerticalPanel getActionsConfigWidget() {
        return this.actionsConfigWidget;
    }

    RuleSelector getRuleSelector() {
        return this.ruleSelector;
    }

    Button getAddColumn() {
        return this.addColumn;
    }

    Button getEditColumns() {
        return this.editColumns;
    }

    GuidedDecisionTableModellerView.Presenter getPresenter() {
        return this.presenter;
    }

    GuidedDecisionTableAccordion getAccordion() {
        return this.accordion;
    }

    static interface GuidedDecisionTableModellerViewImplUiBinder
    extends UiBinder<Widget, GuidedDecisionTableModellerViewImpl> {
    }
}

