/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table;

import com.ait.lienzo.client.core.event.INodeXYEvent;
import com.ait.lienzo.client.core.event.NodeDragMoveHandler;
import com.ait.lienzo.client.core.event.NodeMouseDoubleClickHandler;
import com.ait.lienzo.client.core.shape.BoundingBoxPathClipper;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPathClipper;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.Point2D;
import javax.enterprise.event.Event;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.i18n.GuidedDecisionTableConstants;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.themes.GuidedDecisionTableTheme;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.workbench.events.NotificationEvent;

public class GuidedDecisionTableViewImpl
extends BaseGridWidget
implements GuidedDecisionTableView {
    public static final int HEADER_CAPTION_WIDTH = 200;
    public static final int HEADER_CAPTION_HEIGHT = 32;
    private final GuidedDecisionTableView.Presenter presenter;
    private final GuidedDecisionTable52 model;
    private final Event<NotificationEvent> notificationEvent;
    private Group headerCaption;

    public GuidedDecisionTableViewImpl(GridData uiModel, GridRenderer renderer, GuidedDecisionTableView.Presenter presenter, GuidedDecisionTable52 model, Event<NotificationEvent> notificationEvent) {
        super(uiModel, (GridSelectionManager)presenter, (GridPinnedModeManager)presenter, renderer);
        this.presenter = presenter;
        this.model = model;
        this.notificationEvent = notificationEvent;
        this.headerCaption = this.makeHeaderCaption();
    }

    @Override
    public void registerNodeDragMoveHandler(NodeDragMoveHandler handler) {
        this.addNodeDragMoveHandler(handler);
    }

    @Override
    public void registerNodeMouseDoubleClickHandler(NodeMouseDoubleClickHandler handler) {
        this.addNodeMouseDoubleClickHandler(handler);
    }

    private Group makeHeaderCaption() {
        Group g = new Group();
        double captionWidth = this.getHeaderCaptionWidth();
        GuidedDecisionTableTheme theme = (GuidedDecisionTableTheme)this.renderer.getTheme();
        Rectangle r = theme.getBaseRectangle(GuidedDecisionTableTheme.ModelColumnType.CAPTION).setWidth(captionWidth).setHeight(32.0);
        MultiPath border = theme.getBodyGridLine();
        border.M(0.5, 32.5).L(0.5, 0.5).L(captionWidth + 0.5, 0.5).L(captionWidth + 0.5, 32.5).L(0.5, 32.5);
        Text caption = (Text)((Text)theme.getHeaderText().setText(this.model.getTableName()).setX(captionWidth / 2.0)).setY(16.0);
        BoundingBox bb = new BoundingBox(0.0, 0.0, captionWidth + border.getStrokeWidth(), 32.5);
        IPathClipper clipper = this.getPathClipper(bb);
        g.setPathClipper(clipper);
        clipper.setActive(true);
        g.add((IPrimitive)r);
        g.add((IPrimitive)caption);
        g.add((IPrimitive)border);
        return g;
    }

    private IPathClipper getPathClipper(BoundingBox bb) {
        return new BoundingBoxPathClipper(bb);
    }

    private double getHeaderCaptionWidth() {
        return Math.max(200, this.model.getRowNumberCol().getWidth() + this.model.getDescriptionCol().getWidth());
    }

    public boolean onDragHandle(INodeXYEvent event) {
        return this.isNodeMouseEventOverCaption(event);
    }

    @Override
    public boolean isNodeMouseEventOverCaption(INodeXYEvent event) {
        Point2D ap = CoordinateUtilities.convertDOMToGridCoordinate((GridWidget)this, (Point2D)new Point2D((double)event.getX(), (double)event.getY()));
        double cx = ap.getX();
        double cy = ap.getY();
        return cx > this.headerCaption.getX() && cx < this.headerCaption.getX() + this.getHeaderCaptionWidth() && cy > this.headerCaption.getY() && cy < this.headerCaption.getY() + 32.0;
    }

    @Override
    public GuidedDecisionTableView.Presenter getPresenter() {
        return this.presenter;
    }

    @Override
    public void setLocation(double x, double y) {
        this.setLocation(new Point2D(x, y));
    }

    protected void drawHeader(BaseGridRendererHelper.RenderingInformation renderingInformation, boolean isSelectionLayer) {
        super.drawHeader(renderingInformation, isSelectionLayer);
        this.headerCaption = this.makeHeaderCaption();
        this.headerCaption.setY(this.header == null ? 0.0 : this.header.getY());
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = renderingInformation.getFloatingBlockInformation();
        if (!floatingBlockInformation.getColumns().isEmpty()) {
            this.headerCaption.setX(floatingBlockInformation.getX());
        } else {
            this.headerCaption.setX(0.0);
        }
        this.add((IPrimitive)this.headerCaption);
    }

    @Override
    public void showDataCutNotificationEvent() {
        this.notificationEvent.fire((Object)new NotificationEvent(GuidedDecisionTableConstants.INSTANCE.DataCutToClipboardMessage()));
    }

    @Override
    public void showDataCopiedNotificationEvent() {
        this.notificationEvent.fire((Object)new NotificationEvent(GuidedDecisionTableConstants.INSTANCE.DataCopiedToClipboardMessage()));
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }
}

