/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.accordion;

import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class GuidedDecisionTableAccordionItem {
    private final View view;
    private final TranslationService translationService;
    private Type type;
    private Widget content;
    private String parentId;

    @Inject
    public GuidedDecisionTableAccordionItem(View view, TranslationService translationService) {
        this.view = view;
        this.translationService = translationService;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
    }

    public View getView() {
        return this.view;
    }

    public void init(String parentId, Type type, Widget content) {
        this.parentId = parentId;
        this.type = type;
        this.content = content;
        this.refreshView();
    }

    void refreshView() {
        this.view.setTitle(this.getTitle());
        this.view.setItemId(this.getItemId());
        this.view.setContent(this.getContent());
        this.view.setParentId(this.getParentId());
    }

    private String getItemId() {
        return this.getParentId() + (Object)((Object)this.getType());
    }

    String getTitle() {
        String titleKey = this.getType().getTitleKey();
        return this.translationService.format(titleKey, new Object[0]);
    }

    Widget getContent() {
        return this.content;
    }

    public Type getType() {
        return this.type;
    }

    public void setOpen(boolean isOpen) {
        this.view.setOpen(isOpen);
    }

    private String getParentId() {
        return this.parentId;
    }

    public static interface View
    extends UberElement<GuidedDecisionTableAccordionItem> {
        public void setTitle(String var1);

        public void setContent(Widget var1);

        public void setItemId(String var1);

        public void setOpen(boolean var1);

        public void setParentId(String var1);
    }

    public static enum Type {
        METADATA("GuidedDecisionTableAccordionItem.Metadata"),
        ATTRIBUTE("GuidedDecisionTableAccordionItem.Attribute"),
        CONDITION("GuidedDecisionTableAccordionItem.Condition"),
        ACTION("GuidedDecisionTableAccordionItem.Action");

        private final String titleKey;

        private Type(String titleKey) {
            this.titleKey = titleKey;
        }

        String getTitleKey() {
            return this.titleKey;
        }
    }
}

