/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTablePresenter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.BaseUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.BaseColumnConverter;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.column.GridWidgetColumnFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

@Dependent
public class GridWidgetColumnFactoryImpl
implements GridWidgetColumnFactory {
    private final List<BaseColumnConverter> converters = new ArrayList<BaseColumnConverter>();

    @Override
    public void setConverters(List<BaseColumnConverter> converters) {
        this.converters.clear();
        Collections.sort(converters, new Comparator<BaseColumnConverter>(){

            @Override
            public int compare(BaseColumnConverter o1, BaseColumnConverter o2) {
                return o2.priority() - o1.priority();
            }
        });
        this.converters.addAll(converters);
    }

    @Override
    public void initialise(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle, ColumnUtilities columnUtilities, GuidedDecisionTableView.Presenter presenter) {
        for (BaseColumnConverter converter : this.converters) {
            converter.initialise(model, oracle, columnUtilities, presenter);
        }
    }

    @Override
    public GridColumn<?> convertColumn(BaseColumn column, GuidedDecisionTablePresenter.Access access, GuidedDecisionTableView gridWidget) {
        for (BaseColumnConverter converter : this.converters) {
            if (!converter.handles(column)) continue;
            GridColumn<?> uiColumn = converter.convertColumn(column, access, gridWidget);
            if (uiColumn instanceof BaseUiColumn) {
                ((BaseUiColumn)uiColumn).setColumnResizeListener(width -> column.setWidth((int)width));
            }
            column.setWidth((int)uiColumn.getWidth());
            return uiColumn;
        }
        throw new IllegalArgumentException("Column '" + column.getHeader() + "' was not converted.");
    }
}

