/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.drools.workbench.models.datamodel.oracle.OperatorsOracle;
import org.drools.workbench.models.datamodel.util.PortablePreconditions;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiffImpl;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.gwt.BoundFactsChangedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.Synchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseColumnSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;

@Dependent
public class ConditionColumnSynchronizer
extends BaseColumnSynchronizer<PatternConditionMetaData, PatternConditionMetaData, BaseColumnSynchronizer.ColumnMetaData> {
    @Override
    public boolean handlesAppend(Synchronizer.MetaData metaData) {
        return this.handlesUpdate(metaData);
    }

    @Override
    public void append(PatternConditionMetaData metaData) {
        if (!this.handlesAppend(metaData)) {
            return;
        }
        Pattern52 pattern = metaData.getPattern();
        ConditionCol52 column = (ConditionCol52)metaData.getColumn();
        if (!this.model.getConditions().contains(pattern)) {
            this.model.getConditions().add(pattern);
            BoundFactsChangedEvent bfce = new BoundFactsChangedEvent(this.rm.getLHSBoundFacts());
            this.eventBus.fireEvent((GwtEvent)bfce);
        }
        pattern.getChildColumns().add(column);
        this.synchroniseAppendColumn((BaseColumn)column);
    }

    @Override
    public boolean handlesUpdate(Synchronizer.MetaData metaData) {
        return metaData instanceof PatternConditionMetaData;
    }

    @Override
    public List<BaseColumnFieldDiff> update(PatternConditionMetaData originalMetaData, PatternConditionMetaData editedMetaData) {
        if (!this.handlesUpdate(originalMetaData) || !this.handlesUpdate(editedMetaData)) {
            return Collections.emptyList();
        }
        Pattern52 originalPattern = originalMetaData.getPattern();
        Pattern52 editedPattern = editedMetaData.getPattern();
        ConditionCol52 originalColumn = (ConditionCol52)originalMetaData.getColumn();
        ConditionCol52 editedColumn = (ConditionCol52)editedMetaData.getColumn();
        List patternDiffs = originalPattern.diff((BaseColumn)editedPattern);
        List columnDiffs = originalColumn.diff((BaseColumn)editedColumn);
        ArrayList<BaseColumnFieldDiff> diffs = new ArrayList<BaseColumnFieldDiff>();
        if (patternDiffs != null) {
            diffs.addAll(patternDiffs);
        }
        if (columnDiffs != null) {
            diffs.addAll(columnDiffs);
        }
        boolean isNewPattern = this.isNewPattern(editedPattern);
        boolean isUpdatedPattern = BaseColumnFieldDiffImpl.hasChanged((String)"boundName", diffs);
        if (isNewPattern || isUpdatedPattern) {
            this.append(editedMetaData);
            this.copyColumnData(originalColumn, editedColumn, diffs);
            this.delete(originalMetaData);
            return diffs;
        }
        this.update(originalColumn, editedColumn);
        boolean isHideUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"hideColumn", diffs);
        boolean isHeaderUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"header", diffs);
        boolean isFactTypeUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"factType", diffs);
        boolean isFactFieldUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"factField", diffs);
        boolean isFieldTypeUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"fieldType", diffs);
        boolean isConstraintValueTypeUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"constraintValueType", diffs);
        if (isFactTypeUpdated || isFactFieldUpdated || isFieldTypeUpdated || isConstraintValueTypeUpdated) {
            this.clearColumnData((BaseColumn)originalColumn);
        } else {
            this.cleanColumnData(originalColumn, editedColumn, diffs);
        }
        this.synchroniseUpdateColumn((BaseColumn)originalColumn);
        if (isHideUpdated) {
            this.setColumnVisibility((BaseColumn)originalColumn, originalColumn.isHideColumn());
        }
        if (isHeaderUpdated) {
            this.setColumnHeader((BaseColumn)originalColumn, originalColumn.getHeader());
        }
        return diffs;
    }

    @Override
    public boolean handlesDelete(Synchronizer.MetaData metaData) {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof ConditionCol52;
    }

    @Override
    public void delete(BaseColumnSynchronizer.ColumnMetaData metaData) {
        if (!this.handlesDelete(metaData)) {
            return;
        }
        ConditionCol52 column = (ConditionCol52)metaData.getColumn();
        int columnIndex = this.model.getExpandedColumns().indexOf(column);
        Pattern52 pattern = this.model.getPattern(column);
        pattern.getChildColumns().remove(column);
        if (pattern.getChildColumns().isEmpty()) {
            this.model.getConditions().remove(pattern);
            BoundFactsChangedEvent bfce = new BoundFactsChangedEvent(this.rm.getLHSBoundFacts());
            this.eventBus.fireEvent((GwtEvent)bfce);
        }
        this.synchroniseDeleteColumn(columnIndex);
    }

    @Override
    public boolean handlesMoveColumnsTo(List<? extends Synchronizer.MetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        for (Synchronizer.MetaData metaData2 : metaData) {
            if (!(metaData2 instanceof BaseSynchronizer.MoveColumnToMetaData)) {
                return false;
            }
            if (((BaseSynchronizer.MoveColumnToMetaData)metaData2).getColumn() instanceof ConditionCol52) continue;
            return false;
        }
        return true;
    }

    @Override
    public void moveColumnsTo(List<BaseSynchronizer.MoveColumnToMetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        if (!this.handlesMoveColumnsTo(metaData)) {
            return;
        }
        if (this.isBRLFragment(metaData)) {
            this.doMoveBRLFragment(metaData);
        } else if (this.isPattern(metaData)) {
            this.doMovePattern(metaData);
        } else if (this.isSingleCondition(metaData)) {
            this.doMoveSingleCondition(metaData.get(0));
        } else {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
    }

    private boolean isBRLFragment(List<BaseSynchronizer.MoveColumnToMetaData> metaData) {
        if (!metaData.stream().allMatch(c -> c.getColumn() instanceof BRLConditionVariableColumn)) {
            return false;
        }
        BaseSynchronizer.MoveColumnToMetaData md = metaData.get(0);
        BRLConditionVariableColumn srcModelColumn = (BRLConditionVariableColumn)md.getColumn();
        BRLConditionColumn srcModelPattern = this.model.getBRLColumn(srcModelColumn);
        return srcModelPattern.getChildColumns().size() == metaData.size();
    }

    private boolean isPattern(List<BaseSynchronizer.MoveColumnToMetaData> metaData) {
        if (!metaData.stream().allMatch(c -> c.getColumn() instanceof ConditionCol52)) {
            return false;
        }
        BaseSynchronizer.MoveColumnToMetaData md = metaData.get(0);
        ConditionCol52 srcModelColumn = (ConditionCol52)md.getColumn();
        Pattern52 srcModelPattern = this.model.getPattern(srcModelColumn);
        return srcModelPattern.getChildColumns().size() == metaData.size();
    }

    private boolean isSingleCondition(List<BaseSynchronizer.MoveColumnToMetaData> metaData) {
        if (metaData.size() != 1) {
            return false;
        }
        if (metaData.get(0).getColumn() instanceof BRLConditionVariableColumn) {
            return false;
        }
        return metaData.get(0).getColumn() instanceof ConditionCol52;
    }

    private void doMoveBRLFragment(List<BaseSynchronizer.MoveColumnToMetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        BaseSynchronizer.MoveColumnToMetaData md = metaData.get(0);
        BRLConditionVariableColumn srcModelColumn = (BRLConditionVariableColumn)md.getColumn();
        BRLConditionColumn srcModelBRLFragment = this.model.getBRLColumn(srcModelColumn);
        if (srcModelBRLFragment == null) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        List srcModelBRLFragmentColumns = srcModelBRLFragment.getChildColumns();
        int srcModelPatternConditionColumnCount = srcModelBRLFragmentColumns.size();
        if (srcModelPatternConditionColumnCount == 0) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        if (srcModelPatternConditionColumnCount != metaData.size()) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        int tgtColumnIndex = md.getTargetColumnIndex();
        int tgtPatternIndex = this.findTargetPatternIndex(md);
        List allModelColumns = this.model.getExpandedColumns();
        this.moveModelData(tgtColumnIndex, allModelColumns.indexOf(srcModelBRLFragmentColumns.get(0)), allModelColumns.indexOf(srcModelBRLFragmentColumns.get(0)) + srcModelPatternConditionColumnCount - 1);
        this.model.getConditions().remove(srcModelBRLFragment);
        this.model.getConditions().add(tgtPatternIndex, srcModelBRLFragment);
    }

    private void doMovePattern(List<BaseSynchronizer.MoveColumnToMetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        BaseSynchronizer.MoveColumnToMetaData md = metaData.get(0);
        ConditionCol52 srcModelColumn = (ConditionCol52)md.getColumn();
        Pattern52 srcModelPattern = this.model.getPattern(srcModelColumn);
        if (srcModelPattern == null) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        List srcModelPatternConditionColumns = srcModelPattern.getChildColumns();
        int srcModelPatternConditionColumnCount = srcModelPatternConditionColumns.size();
        if (srcModelPatternConditionColumnCount == 0) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        if (srcModelPatternConditionColumnCount != metaData.size()) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        int tgtColumnIndex = md.getTargetColumnIndex();
        int tgtPatternIndex = this.findTargetPatternIndex(md);
        List allModelColumns = this.model.getExpandedColumns();
        this.moveModelData(tgtColumnIndex, allModelColumns.indexOf(srcModelPatternConditionColumns.get(0)), allModelColumns.indexOf(srcModelPatternConditionColumns.get(0)) + srcModelPatternConditionColumnCount - 1);
        this.model.getConditions().remove(srcModelPattern);
        this.model.getConditions().add(tgtPatternIndex, srcModelPattern);
    }

    private void doMoveSingleCondition(BaseSynchronizer.MoveColumnToMetaData metaData) throws ModelSynchronizer.MoveColumnVetoException {
        ConditionCol52 modelColumn = (ConditionCol52)metaData.getColumn();
        Pattern52 modelPattern = this.model.getPattern(modelColumn);
        if (modelPattern == null) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        List modelPatternConditionColumns = modelPattern.getChildColumns();
        int modelPatternConditionColumnCount = modelPatternConditionColumns.size();
        if (modelPatternConditionColumnCount == 0) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        List allModelColumns = this.model.getExpandedColumns();
        int minColumnIndex = allModelColumns.indexOf(modelPatternConditionColumns.get(0));
        int maxColumnIndex = allModelColumns.indexOf(modelPatternConditionColumns.get(modelPatternConditionColumnCount - 1));
        int targetColumnIndex = metaData.getTargetColumnIndex();
        int sourceColumnIndex = metaData.getSourceColumnIndex();
        if (targetColumnIndex < minColumnIndex || targetColumnIndex > maxColumnIndex) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        this.moveModelData(targetColumnIndex, sourceColumnIndex, sourceColumnIndex);
        modelPatternConditionColumns.remove(modelColumn);
        modelPatternConditionColumns.add(targetColumnIndex - minColumnIndex, modelColumn);
    }

    private int findTargetPatternIndex(BaseSynchronizer.MoveColumnToMetaData md) throws ModelSynchronizer.MoveColumnVetoException {
        int tgtPatternIndex = -1;
        int tgtColumnIndex = md.getTargetColumnIndex();
        List allModelColumns = this.model.getExpandedColumns();
        List allModelConditions = this.model.getConditions();
        for (int patternIndex = 0; patternIndex < allModelConditions.size(); ++patternIndex) {
            CompositeColumn cc = (CompositeColumn)allModelConditions.get(patternIndex);
            List children = cc.getChildColumns();
            if (children == null || children.isEmpty()) continue;
            BaseColumn firstChild = (BaseColumn)children.get(0);
            BaseColumn lastChild = (BaseColumn)children.get(children.size() - 1);
            int firstChildIndex = allModelColumns.indexOf(firstChild);
            int lastChildIndex = allModelColumns.indexOf(lastChild);
            if (tgtColumnIndex < firstChildIndex || tgtColumnIndex > lastChildIndex) continue;
            tgtPatternIndex = patternIndex;
            break;
        }
        if (tgtPatternIndex < 0) {
            throw new ModelSynchronizer.MoveColumnVetoException();
        }
        return tgtPatternIndex;
    }

    private boolean isNewPattern(Pattern52 editedPattern) {
        if (this.model.getConditions() == null || this.model.getConditions().isEmpty()) {
            return true;
        }
        boolean isNewPattern = true;
        for (CompositeColumn column : this.model.getConditions()) {
            Pattern52 existingPattern;
            if (!(column instanceof Pattern52) || !(existingPattern = (Pattern52)column).getBoundName().equals(editedPattern.getBoundName())) continue;
            isNewPattern = false;
            break;
        }
        return isNewPattern;
    }

    private void copyColumnData(ConditionCol52 originalColumn, ConditionCol52 editedColumn, List<BaseColumnFieldDiff> diffs) {
        boolean isFactTypeUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"factType", diffs);
        boolean isFactFieldUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"factField", diffs);
        boolean isConstraintValueTypeUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"constraintValueType", diffs);
        if (!(isFactTypeUpdated || isFactFieldUpdated || isConstraintValueTypeUpdated)) {
            int originalColumnIndex = this.model.getExpandedColumns().indexOf(originalColumn);
            int editedColumnIndex = this.model.getExpandedColumns().indexOf(editedColumn);
            for (int rowIndex = 0; rowIndex < this.model.getData().size(); ++rowIndex) {
                List modelRow = (List)this.model.getData().get(rowIndex);
                DTCellValue52 modelCell = (DTCellValue52)modelRow.get(originalColumnIndex);
                modelRow.set(editedColumnIndex, modelRow.get(originalColumnIndex));
                if (!modelCell.hasValue()) continue;
                this.uiModel.setCell(rowIndex, editedColumnIndex, (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(modelCell, (BaseColumn)editedColumn, this.cellUtilities, this.columnUtilities));
            }
        }
    }

    private void cleanColumnData(ConditionCol52 originalColumn, ConditionCol52 editedColumn, List<BaseColumnFieldDiff> diffs) {
        boolean isOperatorUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"operator", diffs);
        boolean isValueListUpdated = BaseColumnFieldDiffImpl.hasChanged((String)"valueList", diffs);
        if (isOperatorUpdated && !ColumnUtilities.canAcceptOtherwiseValues((BaseColumn)editedColumn)) {
            this.removeOtherwiseStates((BaseColumn)originalColumn);
        }
        if (isOperatorUpdated && !this.canAcceptCommaSeparatedValues(editedColumn)) {
            this.cellUtilities.removeCommaSeparatedValue(editedColumn.getDefaultValue());
            this.removeCommaSeparatedValues((BaseColumn)originalColumn);
        }
        if (isValueListUpdated) {
            this.updateCellsForOptionValueList((BaseColumn)originalColumn, (BaseColumn)editedColumn);
        }
    }

    private void removeOtherwiseStates(BaseColumn column) {
        int columnIndex = this.model.getExpandedColumns().indexOf(column);
        for (List row : this.model.getData()) {
            DTCellValue52 dcv = (DTCellValue52)row.get(columnIndex);
            dcv.setOtherwise(false);
        }
    }

    private boolean canAcceptCommaSeparatedValues(ConditionCol52 column) {
        if (column.getConstraintValueType() != 1) {
            return false;
        }
        List<String> ops = Arrays.asList(OperatorsOracle.EXPLICIT_LIST_OPERATORS);
        return ops.contains(column.getOperator());
    }

    private void removeCommaSeparatedValues(BaseColumn column) {
        int columnIndex = this.model.getExpandedColumns().indexOf(column);
        for (List row : this.model.getData()) {
            DTCellValue52 dcv = (DTCellValue52)row.get(columnIndex);
            this.cellUtilities.removeCommaSeparatedValue(dcv);
        }
    }

    private void update(ConditionCol52 originalColumn, ConditionCol52 editedColumn) {
        originalColumn.setConstraintValueType(editedColumn.getConstraintValueType());
        originalColumn.setFactField(editedColumn.getFactField());
        originalColumn.setFieldType(editedColumn.getFieldType());
        originalColumn.setHeader(editedColumn.getHeader());
        originalColumn.setOperator(editedColumn.getOperator());
        originalColumn.setValueList(editedColumn.getValueList());
        originalColumn.setDefaultValue(editedColumn.getDefaultValue());
        originalColumn.setHideColumn(editedColumn.isHideColumn());
        originalColumn.setParameters(editedColumn.getParameters());
        originalColumn.setBinding(editedColumn.getBinding());
        if (originalColumn instanceof LimitedEntryCol && editedColumn instanceof LimitedEntryCol) {
            ((LimitedEntryCol)originalColumn).setValue(((LimitedEntryCol)editedColumn).getValue());
        }
    }

    public static class PatternConditionMetaData
    extends BaseColumnSynchronizer.ColumnMetaDataImpl {
        private final Pattern52 pattern;

        public PatternConditionMetaData(Pattern52 pattern, ConditionCol52 column) {
            super((BaseColumn)column);
            this.pattern = (Pattern52)PortablePreconditions.checkNotNull((String)"pattern", (Object)pattern);
        }

        public Pattern52 getPattern() {
            return this.pattern;
        }
    }
}

