/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.RowNumberCol52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.Synchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizer;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.selections.impl.RowSelectionStrategy;

@Dependent
public class RowSynchronizer
extends BaseSynchronizer<RowMetaData, RowMetaData, RowMetaData> {
    @Override
    public boolean handlesAppend(Synchronizer.MetaData metaData) {
        return metaData instanceof RowMetaData;
    }

    @Override
    public void append(RowMetaData metaData) {
        if (!this.handlesAppend(metaData)) {
            return;
        }
        ArrayList modelRow = new ArrayList();
        this.model.getData().add(modelRow);
        BaseGridRow uiModelRow = new BaseGridRow(24.0);
        this.uiModel.appendRow((GridRow)uiModelRow);
        int rowIndex = this.uiModel.getRowCount() - 1;
        this.initialiseRowData(rowIndex);
    }

    @Override
    public boolean handlesInsert(Synchronizer.MetaData metaData) throws ModelSynchronizer.MoveColumnVetoException {
        return metaData instanceof RowMetaData;
    }

    @Override
    public void insert(RowMetaData metaData) throws ModelSynchronizer.MoveColumnVetoException {
        if (!this.handlesAppend(metaData)) {
            return;
        }
        int rowIndex = metaData.getRowIndex();
        ArrayList modelRow = new ArrayList();
        this.model.getData().add(rowIndex, modelRow);
        BaseGridRow uiModelRow = new BaseGridRow(24.0);
        this.uiModel.insertRow(rowIndex, (GridRow)uiModelRow);
        this.initialiseRowData(rowIndex);
    }

    private void initialiseRowData(int rowIndex) {
        List modelColumns = this.model.getExpandedColumns();
        List modelRow = (List)this.model.getData().get(rowIndex);
        for (int columnIndex = 0; columnIndex < modelColumns.size(); ++columnIndex) {
            BaseColumn modelColumn = (BaseColumn)modelColumns.get(columnIndex);
            DTCellValue52 modelCell = this.makeModelCellValue(modelColumn);
            modelRow.add(modelCell);
            if (modelCell.hasValue()) {
                this.uiModel.setCellInternal(rowIndex, columnIndex, (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(modelCell, modelColumn, this.cellUtilities, this.columnUtilities));
            }
            this.uiModel.indexColumn(columnIndex);
            if (!(modelColumn instanceof RowNumberCol52)) continue;
            this.uiModel.getCell(rowIndex, columnIndex).setSelectionManager(RowSelectionStrategy.INSTANCE);
        }
    }

    @Override
    public boolean handlesUpdate(Synchronizer.MetaData metaData) {
        return false;
    }

    @Override
    public List<BaseColumnFieldDiff> update(RowMetaData originalMetaData, RowMetaData editedMetaData) {
        return Collections.emptyList();
    }

    @Override
    public boolean handlesDelete(Synchronizer.MetaData metaData) {
        return metaData instanceof RowMetaData;
    }

    @Override
    public void delete(RowMetaData metaData) {
        if (!this.handlesDelete(metaData)) {
            return;
        }
        int rowIndex = metaData.getRowIndex();
        GridData.Range rowRange = this.uiModel.deleteRow(rowIndex);
        int minRowIndex = rowRange.getMinRowIndex();
        int maxRowIndex = rowRange.getMaxRowIndex();
        for (int ri = minRowIndex; ri <= maxRowIndex; ++ri) {
            this.model.getData().remove(minRowIndex);
        }
    }

    @Override
    public boolean handlesMoveColumnsTo(List<? extends Synchronizer.MetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        return false;
    }

    @Override
    public void moveColumnsTo(List<BaseSynchronizer.MoveColumnToMetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
    }

    @Override
    public boolean handlesMoveRowsTo(List<? extends Synchronizer.MetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        for (Synchronizer.MetaData metaData2 : metaData) {
            if (metaData2 instanceof BaseSynchronizer.MoveRowToMetaData) continue;
            return false;
        }
        return true;
    }

    @Override
    public void moveRowsTo(List<BaseSynchronizer.MoveRowToMetaData> metaData) throws ModelSynchronizer.MoveColumnVetoException {
        if (!this.handlesMoveRowsTo(metaData)) {
            return;
        }
        for (int idx = 0; idx < metaData.size(); ++idx) {
            BaseSynchronizer.MoveRowToMetaData md = metaData.get(idx);
            int sourceRowIndex = md.getSourceRowIndex();
            int targetRowIndex = md.getTargetRowIndex();
            List<DTCellValue52> row = md.getRow();
            if (targetRowIndex < sourceRowIndex) {
                this.model.getData().remove(sourceRowIndex);
                this.model.getData().add(targetRowIndex, row);
                continue;
            }
            if (targetRowIndex <= sourceRowIndex) continue;
            this.model.getData().remove(sourceRowIndex - idx);
            this.model.getData().add(targetRowIndex - idx, row);
        }
    }

    public static class RowMetaDataImpl
    implements RowMetaData {
        private final int rowIndex;

        public RowMetaDataImpl() {
            this(-1);
        }

        public RowMetaDataImpl(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        @Override
        public int getRowIndex() {
            return this.rowIndex;
        }
    }

    public static interface RowMetaData
    extends Synchronizer.MetaData {
        public int getRowIndex();
    }
}

