/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.List;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.SalienceUiColumn;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.GuidedDecisionTableUiModel;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.converters.cell.GridWidgetCellFactory;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

public class SalienceSynchronizer {
    private final GuidedDecisionTable52 model;
    private final GuidedDecisionTableUiModel uiModel;
    private final GridWidgetCellFactory gridWidgetCellFactory;
    private final CellUtilities cellUtilities;
    private final ColumnUtilities columnUtilities;

    public SalienceSynchronizer(GuidedDecisionTable52 model, GuidedDecisionTableUiModel uiModel, GridWidgetCellFactory gridWidgetCellFactory, CellUtilities cellUtilities, ColumnUtilities columnUtilities) {
        this.model = model;
        this.uiModel = uiModel;
        this.gridWidgetCellFactory = gridWidgetCellFactory;
        this.cellUtilities = cellUtilities;
        this.columnUtilities = columnUtilities;
    }

    public void updateSalienceColumnValues(AttributeCol52 modelColumn) {
        int iModelColumn = this.model.getExpandedColumns().indexOf(modelColumn);
        GridColumn uiColumn = (GridColumn)this.uiModel.getColumns().get(iModelColumn);
        if (uiColumn instanceof SalienceUiColumn) {
            ((SalienceUiColumn)uiColumn).setUseRowNumber(modelColumn.isUseRowNumber());
        }
        if (modelColumn.isUseRowNumber()) {
            this.setSalienceByRowNumbers(modelColumn, iModelColumn);
        }
    }

    private void setSalienceByRowNumbers(AttributeCol52 modelColumn, int iModelColumn) {
        int salience = modelColumn.isReverseOrder() ? this.model.getData().size() : 1;
        for (int rowNumber = 0; rowNumber < this.model.getData().size(); ++rowNumber) {
            List modelRow = (List)this.model.getData().get(rowNumber);
            DTCellValue52 modelCell = (DTCellValue52)modelRow.get(iModelColumn);
            modelCell.setNumericValue(Integer.valueOf(salience));
            this.uiModel.setCellInternal(rowNumber, iModelColumn, (GridCellValue<?>)this.gridWidgetCellFactory.convertCell(modelCell, (BaseColumn)modelColumn, this.cellUtilities, this.columnUtilities));
            if (modelColumn.isReverseOrder()) {
                --salience;
                continue;
            }
            ++salience;
        }
        this.uiModel.indexColumn(iModelColumn);
    }
}

