/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.utilities;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.DateConverter;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;

public class CellUtilities {
    protected static DateConverter DATE_CONVERTOR = null;

    public static void injectDateConvertor(DateConverter dc) {
        DATE_CONVERTOR = dc;
    }

    public void convertDTCellValueType(DataType.DataTypes dataType, DTCellValue52 dcv) {
        if (dcv == null) {
            return;
        }
        if (dataType.equals((Object)dcv.getDataType())) {
            return;
        }
        switch (dataType) {
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: {
                dcv.setNumericValue(this.convertToBigDecimal(dcv));
                break;
            }
            case NUMERIC_BIGINTEGER: {
                dcv.setNumericValue(this.convertToBigInteger(dcv));
                break;
            }
            case NUMERIC_BYTE: {
                dcv.setNumericValue(this.convertToByte(dcv));
                break;
            }
            case NUMERIC_DOUBLE: {
                dcv.setNumericValue(this.convertToDouble(dcv));
                break;
            }
            case NUMERIC_FLOAT: {
                dcv.setNumericValue(this.convertToFloat(dcv));
                break;
            }
            case NUMERIC_INTEGER: {
                dcv.setNumericValue(this.convertToInteger(dcv));
                break;
            }
            case NUMERIC_LONG: {
                dcv.setNumericValue(this.convertToLong(dcv));
                break;
            }
            case NUMERIC_SHORT: {
                dcv.setNumericValue(this.convertToShort(dcv));
                break;
            }
            case DATE: {
                dcv.setDateValue(this.convertToDate(dcv));
                break;
            }
            case BOOLEAN: {
                dcv.setBooleanValue(this.convertToBoolean(dcv));
                break;
            }
            case STRING: {
                dcv.setStringValue(this.convertToString(dcv));
            }
        }
    }

    public String asString(DTCellValue52 dcv) {
        switch (dcv.getDataType()) {
            case BOOLEAN: {
                return this.convertBooleanValueToString(dcv);
            }
            case DATE: {
                return this.convertDateValueToString(dcv);
            }
            case NUMERIC: {
                return this.convertNumericValueToString(dcv);
            }
            case NUMERIC_BIGDECIMAL: {
                return this.convertBigDecimalValueToString(dcv);
            }
            case NUMERIC_BIGINTEGER: {
                return this.convertBigIntegerValueToString(dcv);
            }
            case NUMERIC_BYTE: {
                return this.convertByteValueToString(dcv);
            }
            case NUMERIC_DOUBLE: {
                return this.convertDoubleValueToString(dcv);
            }
            case NUMERIC_FLOAT: {
                return this.convertFloatValueToString(dcv);
            }
            case NUMERIC_INTEGER: {
                return this.convertIntegerValueToString(dcv);
            }
            case NUMERIC_LONG: {
                return this.convertLongValueToString(dcv);
            }
            case NUMERIC_SHORT: {
                return this.convertShortValueToString(dcv);
            }
        }
        return this.convertStringValueToString(dcv);
    }

    public void removeCommaSeparatedValue(DTCellValue52 dcv) {
        if (dcv == null) {
            return;
        }
        if (dcv.getDataType().equals((Object)DataType.DataTypes.STRING)) {
            if (dcv.getStringValue() == null) {
                return;
            }
            String[] values = dcv.getStringValue().split(",");
            if (values.length > 0) {
                dcv.setStringValue(values[0]);
            }
        }
    }

    private String convertBooleanValueToString(DTCellValue52 dcv) {
        Boolean value = dcv.getBooleanValue();
        return value == null ? "" : value.toString();
    }

    private String convertDateValueToString(DTCellValue52 dcv) {
        Date value = dcv.getDateValue();
        String result = "";
        if (value != null) {
            result = DATE_CONVERTOR.format(value);
        }
        return result;
    }

    private String convertNumericValueToString(DTCellValue52 dcv) {
        BigDecimal value = (BigDecimal)dcv.getNumericValue();
        return value == null ? "" : value.toPlainString();
    }

    private String convertBigDecimalValueToString(DTCellValue52 dcv) {
        BigDecimal value = (BigDecimal)dcv.getNumericValue();
        return value == null ? "" : value.toPlainString();
    }

    private String convertBigIntegerValueToString(DTCellValue52 dcv) {
        BigInteger value = (BigInteger)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertByteValueToString(DTCellValue52 dcv) {
        Byte value = (Byte)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertDoubleValueToString(DTCellValue52 dcv) {
        Double value = (Double)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertFloatValueToString(DTCellValue52 dcv) {
        Float value = (Float)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertIntegerValueToString(DTCellValue52 dcv) {
        Integer value = (Integer)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertLongValueToString(DTCellValue52 dcv) {
        Long value = (Long)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertShortValueToString(DTCellValue52 dcv) {
        Short value = (Short)dcv.getNumericValue();
        return value == null ? "" : value.toString();
    }

    private String convertStringValueToString(DTCellValue52 dcv) {
        String value = dcv.getStringValue();
        return value == null ? "" : value;
    }

    public BigDecimal convertToBigDecimal(DTCellValue52 cell) {
        switch (cell.getDataType()) {
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: 
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_BYTE: 
            case NUMERIC_DOUBLE: 
            case NUMERIC_FLOAT: 
            case NUMERIC_INTEGER: 
            case NUMERIC_LONG: 
            case NUMERIC_SHORT: {
                try {
                    if (cell.getNumericValue() == null) {
                        return null;
                    }
                    return new BigDecimal(cell.getNumericValue().toString());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case STRING: {
                try {
                    if (cell.getStringValue() == null) {
                        return null;
                    }
                    return new BigDecimal(cell.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
        }
        return null;
    }

    public BigInteger convertToBigInteger(DTCellValue52 cell) {
        switch (cell.getDataType()) {
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: 
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_BYTE: 
            case NUMERIC_DOUBLE: 
            case NUMERIC_FLOAT: 
            case NUMERIC_INTEGER: 
            case NUMERIC_LONG: 
            case NUMERIC_SHORT: {
                try {
                    if (cell.getNumericValue() == null) {
                        return null;
                    }
                    return new BigInteger(cell.getNumericValue().toString());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case STRING: {
                try {
                    if (cell.getStringValue() == null) {
                        return null;
                    }
                    return new BigInteger(cell.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
        }
        return null;
    }

    public Byte convertToByte(DTCellValue52 cell) {
        switch (cell.getDataType()) {
            case NUMERIC_BYTE: {
                if (cell.getNumericValue() == null) {
                    return null;
                }
                return cell.getNumericValue().byteValue();
            }
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: 
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_DOUBLE: 
            case NUMERIC_FLOAT: 
            case NUMERIC_INTEGER: 
            case NUMERIC_LONG: 
            case NUMERIC_SHORT: {
                try {
                    if (cell.getNumericValue() == null) {
                        return null;
                    }
                    return new Byte(cell.getNumericValue().toString());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case STRING: {
                try {
                    if (cell.getStringValue() == null) {
                        return null;
                    }
                    return new Byte(cell.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
        }
        return null;
    }

    public Double convertToDouble(DTCellValue52 cell) {
        switch (cell.getDataType()) {
            case NUMERIC_DOUBLE: {
                if (cell.getNumericValue() == null) {
                    return null;
                }
                return cell.getNumericValue().doubleValue();
            }
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: 
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_BYTE: 
            case NUMERIC_FLOAT: 
            case NUMERIC_INTEGER: 
            case NUMERIC_LONG: 
            case NUMERIC_SHORT: {
                try {
                    if (cell.getNumericValue() == null) {
                        return null;
                    }
                    return new Double(cell.getNumericValue().toString());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case STRING: {
                try {
                    if (cell.getStringValue() == null) {
                        return null;
                    }
                    return new Double(cell.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
        }
        return null;
    }

    public Float convertToFloat(DTCellValue52 cell) {
        switch (cell.getDataType()) {
            case NUMERIC_FLOAT: {
                if (cell.getNumericValue() == null) {
                    return null;
                }
                return Float.valueOf(cell.getNumericValue().floatValue());
            }
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: 
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_BYTE: 
            case NUMERIC_DOUBLE: 
            case NUMERIC_INTEGER: 
            case NUMERIC_LONG: 
            case NUMERIC_SHORT: {
                try {
                    if (cell.getNumericValue() == null) {
                        return null;
                    }
                    return new Float(cell.getNumericValue().toString());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case STRING: {
                try {
                    if (cell.getStringValue() == null) {
                        return null;
                    }
                    return new Float(cell.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
        }
        return null;
    }

    public Integer convertToInteger(DTCellValue52 cell) {
        switch (cell.getDataType()) {
            case NUMERIC_INTEGER: {
                if (cell.getNumericValue() == null) {
                    return null;
                }
                return cell.getNumericValue().intValue();
            }
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: 
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_BYTE: 
            case NUMERIC_DOUBLE: 
            case NUMERIC_FLOAT: 
            case NUMERIC_LONG: 
            case NUMERIC_SHORT: {
                try {
                    if (cell.getNumericValue() == null) {
                        return null;
                    }
                    return new Integer(cell.getNumericValue().toString());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case STRING: {
                try {
                    if (cell.getStringValue() == null) {
                        return null;
                    }
                    return new Integer(cell.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
        }
        return null;
    }

    public Long convertToLong(DTCellValue52 cell) {
        switch (cell.getDataType()) {
            case NUMERIC_LONG: {
                if (cell.getNumericValue() == null) {
                    return null;
                }
                return cell.getNumericValue().longValue();
            }
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: 
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_BYTE: 
            case NUMERIC_DOUBLE: 
            case NUMERIC_FLOAT: 
            case NUMERIC_INTEGER: 
            case NUMERIC_SHORT: {
                try {
                    if (cell.getNumericValue() == null) {
                        return null;
                    }
                    return new Long(cell.getNumericValue().toString());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case STRING: {
                try {
                    if (cell.getStringValue() == null) {
                        return null;
                    }
                    return new Long(cell.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
        }
        return null;
    }

    public Short convertToShort(DTCellValue52 cell) {
        switch (cell.getDataType()) {
            case NUMERIC_SHORT: {
                if (cell.getNumericValue() == null) {
                    return null;
                }
                return cell.getNumericValue().shortValue();
            }
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: 
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_BYTE: 
            case NUMERIC_DOUBLE: 
            case NUMERIC_FLOAT: 
            case NUMERIC_INTEGER: 
            case NUMERIC_LONG: {
                try {
                    if (cell.getNumericValue() == null) {
                        return null;
                    }
                    return new Short(cell.getNumericValue().toString());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            case STRING: {
                try {
                    if (cell.getStringValue() == null) {
                        return null;
                    }
                    return new Short(cell.getStringValue());
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
        }
        return null;
    }

    public Date convertToDate(DTCellValue52 cell) {
        switch (cell.getDataType()) {
            case DATE: {
                return cell.getDateValue();
            }
            case STRING: {
                Date d = null;
                String text = cell.getStringValue();
                try {
                    if (text != null) {
                        if (DATE_CONVERTOR == null) {
                            throw new IllegalArgumentException("DATE_CONVERTOR has not been initialised.");
                        }
                        d = DATE_CONVERTOR.parse(text);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return d;
            }
        }
        return null;
    }

    public Boolean convertToBoolean(DTCellValue52 cell) {
        switch (cell.getDataType()) {
            case BOOLEAN: {
                return cell.getBooleanValue();
            }
            case STRING: {
                String text = cell.getStringValue();
                if (Boolean.TRUE.toString().equalsIgnoreCase(text)) {
                    return true;
                }
                if (!Boolean.FALSE.toString().equalsIgnoreCase(text)) break;
                return false;
            }
        }
        return null;
    }

    public String convertToString(DTCellValue52 cell) {
        switch (cell.getDataType()) {
            case NUMERIC: 
            case NUMERIC_BIGDECIMAL: {
                if (cell.getNumericValue() == null) {
                    return null;
                }
                return ((BigDecimal)cell.getNumericValue()).toPlainString();
            }
            case NUMERIC_BIGINTEGER: 
            case NUMERIC_BYTE: 
            case NUMERIC_DOUBLE: 
            case NUMERIC_FLOAT: 
            case NUMERIC_INTEGER: 
            case NUMERIC_LONG: 
            case NUMERIC_SHORT: {
                if (cell.getNumericValue() == null) {
                    return null;
                }
                return cell.getNumericValue().toString();
            }
            case DATE: {
                Date d = cell.getDateValue();
                if (d != null) {
                    if (DATE_CONVERTOR == null) {
                        throw new IllegalArgumentException("DATE_CONVERTOR has not been initialised.");
                    }
                    return DATE_CONVERTOR.format(d);
                }
                return null;
            }
            case BOOLEAN: {
                if (cell.getBooleanValue() == null) {
                    return null;
                }
                return cell.getBooleanValue().toString();
            }
        }
        return cell.getStringValue();
    }
}

