/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.utilities;

import com.google.gwt.i18n.shared.DateTimeFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.screens.guided.dtable.client.resources.GuidedDecisionTableResources;
import org.drools.workbench.services.verifier.plugin.client.builders.ColumnUtilitiesBase;
import org.kie.workbench.common.services.shared.preferences.ApplicationPreferences;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.widgets.common.client.common.SmallLabel;

public class ColumnUtilities
extends ColumnUtilitiesBase {
    private final AsyncPackageDataModelOracle oracle;

    public ColumnUtilities(GuidedDecisionTable52 model, AsyncPackageDataModelOracle oracle) {
        super(model);
        this.oracle = (AsyncPackageDataModelOracle)PortablePreconditions.checkNotNull((String)"oracle", (Object)oracle);
    }

    protected String getTypeFromDataOracle(String factType, String fieldName) {
        String type = this.oracle.getFieldType(factType, fieldName);
        return type;
    }

    public static void setColumnLabelStyleWhenHidden(SmallLabel label, boolean isHidden) {
        if (isHidden) {
            label.addStyleName(GuidedDecisionTableResources.INSTANCE.css().columnLabelHidden());
        } else {
            label.removeStyleName(GuidedDecisionTableResources.INSTANCE.css().columnLabelHidden());
        }
    }

    public static boolean canAcceptOtherwiseValues(BaseColumn column) {
        if (!(column instanceof ConditionCol52)) {
            return false;
        }
        ConditionCol52 cc = (ConditionCol52)column;
        if (cc.getConstraintValueType() != 1) {
            return false;
        }
        if (cc.getOperator() == null) {
            return false;
        }
        if (cc.getOperator().equals("==")) {
            return true;
        }
        return cc.getOperator().equals("!=");
    }

    public String[] getValueList(BaseColumn col) {
        if (col instanceof AttributeCol52) {
            return this.getValueList((AttributeCol52)col);
        }
        if (col instanceof ConditionCol52) {
            return this.getValueList((ConditionCol52)col);
        }
        if (col instanceof ActionSetFieldCol52) {
            return this.getValueList((ActionSetFieldCol52)col);
        }
        if (col instanceof ActionInsertFactCol52) {
            return this.getValueList((ActionInsertFactCol52)col);
        }
        return new String[0];
    }

    private String[] getValueList(AttributeCol52 col) {
        if ("no-loop".equals(col.getAttribute()) || "enabled".equals(col.getAttribute())) {
            return new String[]{"true", "false"};
        }
        return new String[0];
    }

    private String[] getValueList(ConditionCol52 col) {
        if (col.getValueList() != null && !"".equals(col.getValueList())) {
            return this.parseValueList(col.getFieldType(), col.getValueList());
        }
        return new String[0];
    }

    private String[] getValueList(ActionSetFieldCol52 col) {
        if (col.getValueList() != null && !"".equals(col.getValueList())) {
            return this.parseValueList(this.getTypeFromDataOracle(this.getBoundFactType(col.getBoundName()), col.getFactField()), col.getValueList());
        }
        return new String[0];
    }

    private String[] getValueList(ActionInsertFactCol52 col) {
        if (col.getValueList() != null && !"".equals(col.getValueList())) {
            return this.parseValueList(this.getTypeFromDataOracle(col.getFactType(), col.getFactField()), col.getValueList());
        }
        return new String[0];
    }

    private String[] parseValueList(String fieldType, String valueList) {
        String[] values = valueList.split(",");
        return (String[])Stream.of(values).filter(value -> this.isValueValidForType((String)value, this.convertToTypeSafeType(fieldType))).toArray(String[]::new);
    }

    private boolean isValueValidForType(String value, DataType.DataTypes type) {
        switch (type) {
            case STRING: {
                return true;
            }
            case NUMERIC: {
                return this.canBeConstructed(input -> new BigDecimal((String)input), value);
            }
            case NUMERIC_BIGDECIMAL: {
                return this.canBeConstructed(input -> new BigDecimal((String)input), value);
            }
            case NUMERIC_BIGINTEGER: {
                return this.canBeConstructed(input -> new BigInteger((String)input), value);
            }
            case NUMERIC_BYTE: {
                return this.canBeConstructed(input -> Byte.valueOf(input), value);
            }
            case NUMERIC_DOUBLE: {
                return this.canBeConstructed(input -> Double.valueOf(input), value);
            }
            case NUMERIC_FLOAT: {
                return this.canBeConstructed(input -> Float.valueOf(input), value);
            }
            case NUMERIC_INTEGER: {
                return this.canBeConstructed(input -> Integer.valueOf(input), value);
            }
            case NUMERIC_LONG: {
                return this.canBeConstructed(input -> Long.valueOf(input), value);
            }
            case NUMERIC_SHORT: {
                return this.canBeConstructed(input -> Short.valueOf(input), value);
            }
            case BOOLEAN: {
                return value.trim().equalsIgnoreCase("true") || value.trim().equalsIgnoreCase("false");
            }
            case DATE: {
                String pattern = ApplicationPreferences.getDroolsDateFormat();
                if (pattern == null) break;
                return this.canBeConstructed(input -> DateTimeFormat.getFormat((String)pattern).parse(input), value);
            }
        }
        return true;
    }

    private boolean canBeConstructed(Function<String, Object> constructFunction, String value) {
        try {
            constructFunction.apply(value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean hasValueList(AttributeCol52 col) {
        return "no-loop".equals(col.getAttribute()) || "enabled".equals(col.getAttribute());
    }
}

