/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasFieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.BaseDecisionTableColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.modals.HasList;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class FieldPage<T extends HasFieldPage & DecisionTableColumnPlugin>
extends BaseDecisionTableColumnPage<T> {
    private View view;

    @Inject
    public FieldPage(View view, TranslationService translationService) {
        super(translationService);
        this.view = view;
    }

    @Override
    protected UberElement<?> getView() {
        return this.view;
    }

    public String getTitle() {
        return this.translate("FieldPage.Field", new Object[0]);
    }

    public void isComplete(Callback<Boolean> callback) {
        boolean isComplete;
        boolean bl = isComplete = !DecisionTableColumnViewUtils.nil(((HasFieldPage)this.plugin()).getFactField()) || this.isConstraintValuePredicate();
        if (!isComplete) {
            this.view.showSelectFieldWarning();
        } else {
            this.view.hideSelectFieldWarning();
        }
        callback.callback((Object)isComplete);
    }

    public void prepareView() {
        this.view.init(this);
        this.setupWarningMessages();
        this.setupField();
    }

    void setupField() {
        this.view.setupFieldList();
        this.forEachFactField(field -> this.view.addItem((String)field, (String)field));
        this.view.selectField(this.getFactField());
    }

    private void setupWarningMessages() {
        if (this.isConstraintValuePredicate()) {
            this.view.showPredicateWarning();
        } else {
            this.view.showPatternWarningWhenItIsNotDefined(this.hasEditingPattern());
        }
    }

    void setEditingCol(String selectedValue) {
        ((HasFieldPage)this.plugin()).setFactField(selectedValue);
    }

    void forEachFactField(Consumer<String> consumer) {
        if (this.hasEditingPattern()) {
            AsyncPackageDataModelOracle oracle = this.presenter.getDataModelOracle();
            oracle.getFieldCompletions(this.factType(), this.getAccessor(), this.fieldsCallback(consumer));
        }
    }

    public FieldAccessorsAndMutators getAccessor() {
        return ((HasFieldPage)this.plugin()).getAccessor();
    }

    Callback<ModelField[]> fieldsCallback(Consumer<String> consumer) {
        AsyncPackageDataModelOracle oracle = this.presenter.getDataModelOracle();
        return modelFields -> {
            List<String> fieldNames = this.collectNames((ModelField[])modelFields);
            if (this.filterEnumFields()) {
                fieldNames.stream().filter(fieldName -> !oracle.hasEnums(this.factType(), fieldName)).forEach(consumer);
            } else {
                fieldNames.forEach(consumer);
            }
        };
    }

    boolean isConstraintValuePredicate() {
        return ((HasFieldPage)this.plugin()).constraintValue() == 5;
    }

    boolean filterEnumFields() {
        return ((HasFieldPage)this.plugin()).filterEnumFields();
    }

    boolean hasEditingPattern() {
        return !DecisionTableColumnViewUtils.nil(this.factType());
    }

    private String factType() {
        return ((HasFieldPage)this.plugin()).patternWrapper().getFactType();
    }

    private List<String> collectNames(ModelField[] modelFields) {
        return Stream.of(modelFields).map(ModelField::getName).collect(Collectors.toList());
    }

    public String getFactField() {
        return ((HasFieldPage)this.plugin()).getFactField();
    }

    public static interface View
    extends HasList,
    UberElement<FieldPage> {
        public void showPredicateWarning();

        public void showPatternWarningWhenItIsNotDefined(boolean var1);

        public void setupFieldList();

        public void selectField(String var1);

        public void showSelectFieldWarning();

        public void hideSelectFieldWarning();
    }
}

