/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.user.client.ui.ListBox;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class FieldPageView
implements IsElement,
FieldPage.View {
    private FieldPage<?> page;
    @DataField(value="fieldsList")
    private ListBox fieldsList;
    @DataField(value="patternWarning")
    private Div patternWarning;
    @Inject
    @DataField(value="fieldWarning")
    private Div fieldWarning;
    @DataField(value="info")
    private Div info;
    private TranslationService translationService;

    @Inject
    public FieldPageView(ListBox fieldsList, Div patternWarning, Div info, TranslationService translationService) {
        this.fieldsList = fieldsList;
        this.patternWarning = patternWarning;
        this.info = info;
        this.translationService = translationService;
    }

    public void init(FieldPage page) {
        this.page = page;
    }

    @EventHandler(value={"fieldsList"})
    public void onFieldSelected(ChangeEvent event) {
        this.page.setEditingCol(this.fieldsList.getSelectedValue());
    }

    @Override
    public void showPredicateWarning() {
        this.info.setHidden(false);
        this.patternWarning.setHidden(true);
        this.fieldsList.setEnabled(false);
    }

    @Override
    public void showPatternWarningWhenItIsNotDefined(boolean hasPattern) {
        this.info.setHidden(true);
        this.patternWarning.setHidden(hasPattern);
        this.fieldsList.setEnabled(hasPattern);
    }

    @Override
    public void setupFieldList() {
        String selectField = this.translate("FieldPageView.SelectField", new Object[0]);
        this.fieldsList.clear();
        this.fieldsList.addItem("-- " + selectField + " --", "");
    }

    @Override
    public void selectField(String factField) {
        this.fieldsList.setSelectedIndex(DecisionTableColumnViewUtils.getCurrentIndexFromList(factField, this.fieldsList));
    }

    private String translate(String key, Object ... args) {
        return this.translationService.format(key, args);
    }

    @Override
    public void addItem(String itemName, String itemKey) {
        this.fieldsList.addItem(itemName, itemKey);
    }

    @Override
    public void showSelectFieldWarning() {
        this.fieldWarning.setHidden(false);
    }

    @Override
    public void hideSelectFieldWarning() {
        this.fieldWarning.setHidden(true);
    }
}

