/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasPatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class PatternPageView
implements IsElement,
PatternPage.View {
    private PatternPage<? extends HasPatternPage> page;
    @Inject
    @DataField(value="patternWarning")
    private Div patternWarning;
    @DataField(value="patternList")
    private ListBox patternList;
    @DataField(value="entryPointName")
    private TextBox entryPointName;
    @DataField(value="createANewFactPattern")
    private Button createANewFactPattern;
    @DataField(value="entryPointContainer")
    private Div entryPointContainer;
    private TranslationService translationService;

    @Inject
    public PatternPageView(ListBox patternList, TextBox entryPointName, Button createANewFactPattern, Div entryPointContainer, TranslationService translationService) {
        this.patternList = patternList;
        this.entryPointName = entryPointName;
        this.createANewFactPattern = createANewFactPattern;
        this.entryPointContainer = entryPointContainer;
        this.translationService = translationService;
    }

    public void init(PatternPage page) {
        this.page = page;
    }

    @Override
    public void setupEntryPointName(String entryPointName) {
        this.entryPointName.setText(entryPointName);
    }

    @EventHandler(value={"createANewFactPattern"})
    public void onCreateANewFactPattern(ClickEvent event) {
        this.page.showNewPatternModal();
    }

    @EventHandler(value={"patternList"})
    public void onEditingPatternSelected(ChangeEvent event) {
        this.page.setSelectedEditingPattern();
    }

    @EventHandler(value={"entryPointName"})
    public void onEntryPointChange(KeyUpEvent event) {
        this.page.setEntryPoint();
    }

    @Override
    public String getSelectedValue() {
        return this.patternList.getSelectedValue();
    }

    @Override
    public String getEntryPointName() {
        return this.entryPointName.getText();
    }

    @Override
    public void disableEntryPoint() {
        this.entryPointContainer.setHidden(true);
    }

    @Override
    public void clearPatternList() {
        String selectPattern = this.translate("PatternPageView.SelectPattern", new Object[0]);
        this.patternList.clear();
        this.patternList.addItem("-- " + selectPattern + " --", "");
    }

    @Override
    public void hidePatternListWhenItIsEmpty() {
        this.patternList.setVisible(this.patternList.getItemCount() > 1);
    }

    @Override
    public void selectPattern(String currentPatternValue) {
        int currentValueIndex = DecisionTableColumnViewUtils.getCurrentIndexFromList(currentPatternValue, this.patternList);
        this.patternList.setSelectedIndex(currentValueIndex);
    }

    private String translate(String key, Object ... args) {
        return this.translationService.format(key, args);
    }

    @Override
    public void addItem(String itemName, String itemKey) {
        this.patternList.addItem(itemName, itemKey);
    }

    @Override
    public void showPatternWarning() {
        this.patternWarning.setHidden(false);
    }

    @Override
    public void hidePatternWarning() {
        this.patternWarning.setHidden(true);
    }

    @Override
    public void disablePatternCreation() {
        this.createANewFactPattern.setVisible(false);
        this.createANewFactPattern.setEnabled(false);
    }
}

