/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.rule.CEPWindow;
import org.drools.workbench.models.datamodel.rule.HasCEPWindow;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasValueOptionsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.BaseDecisionTableColumnPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.rule.client.editor.CEPWindowOperatorsDropdown;
import org.drools.workbench.screens.guided.rule.client.editor.OperatorSelection;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.widget.BindingTextBox;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberElement;

@Dependent
public class ValueOptionsPage<T extends HasValueOptionsPage & DecisionTableColumnPlugin>
extends BaseDecisionTableColumnPage<T> {
    private View view;
    private boolean valueListEnabled = false;
    private boolean cepOperatorsEnabled = false;
    private boolean defaultValueEnabled = false;
    private boolean limitedValueEnabled = false;
    private boolean bindingEnabled = false;

    @Inject
    public ValueOptionsPage(View view, TranslationService translationService) {
        super(translationService);
        this.view = view;
    }

    @Override
    protected UberElement<?> getView() {
        return this.view;
    }

    public String getTitle() {
        return this.translate("ValueOptionsPage.ValueOptions", new Object[0]);
    }

    public void isComplete(Callback<Boolean> callback) {
        callback.callback((Object)((HasValueOptionsPage)this.plugin()).isValueOptionsPageCompleted());
    }

    public void prepareView() {
        this.view.init(this);
        this.markAsViewed();
        this.setupValueList();
        this.setupCepOperators();
        this.setupDefaultValue();
        this.setupLimitedValue();
        this.setupBinding();
    }

    void setupValueList() {
        if (!this.isValueListEnabled()) {
            this.view.hideValueList();
            return;
        }
        if (!this.canSetupValueList()) {
            this.view.disableValueList();
            this.view.setValueListText("");
        } else {
            this.view.enableValueList();
            this.view.setValueListText(this.getValueList());
        }
    }

    private void setupCepOperators() {
        if (!this.isCepOperatorsEnabled()) {
            this.view.hideCepOperators();
            return;
        }
        this.isFactTypeAnEvent((Callback<Boolean>)((Callback)isEvent -> {
            if (this.canSetupCepOperators() && isEvent.booleanValue()) {
                this.view.setupCepOperators((IsWidget)this.newCEPWindowOperatorsDropdown());
            } else {
                this.view.setupCepOperators((IsWidget)this.disabledTextBox());
            }
        }));
    }

    private void setupDefaultValue() {
        if (!this.isDefaultValueEnabled()) {
            this.view.hideDefaultValue();
            return;
        }
        if (this.canSetupDefaultValue()) {
            this.view.setupDefaultValue(this.newDefaultValueWidget());
        } else {
            this.view.setupDefaultValue((IsWidget)this.disabledTextBox());
        }
    }

    private void setupLimitedValue() {
        if (!this.isLimitedValueEnabled()) {
            this.view.hideLimitedValue();
            return;
        }
        if (this.canSetupLimitedValue()) {
            this.view.setupLimitedValue(this.newLimitedValueWidget());
        } else {
            this.view.setupLimitedValue((IsWidget)this.disabledTextBox());
        }
    }

    private void setupBinding() {
        if (!this.isBindingEnabled()) {
            this.view.hideBinding();
            return;
        }
        if (this.canSetupBinding()) {
            this.view.setupBinding((IsWidget)this.newBindingTextBox());
        } else {
            this.view.setupBinding((IsWidget)this.disabledTextBox());
        }
    }

    private TextBox disabledTextBox() {
        return new TextBox(){
            {
                this.getElement().setAttribute("disabled", "disabled");
            }
        };
    }

    boolean isValueListEnabled() {
        return this.valueListEnabled;
    }

    private boolean isCepOperatorsEnabled() {
        return this.cepOperatorsEnabled;
    }

    private boolean isDefaultValueEnabled() {
        return this.defaultValueEnabled;
    }

    private boolean isLimitedValueEnabled() {
        return this.limitedValueEnabled;
    }

    private boolean isBindingEnabled() {
        return this.bindingEnabled;
    }

    public void enableValueList() {
        this.valueListEnabled = true;
    }

    public void enableCepOperators() {
        this.cepOperatorsEnabled = true;
    }

    public void enableDefaultValue() {
        this.defaultValueEnabled = true;
    }

    public void enableLimitedValue() {
        this.limitedValueEnabled = true;
    }

    public void enableBinding() {
        this.bindingEnabled = true;
    }

    IsWidget newDefaultValueWidget() {
        return ((HasValueOptionsPage)this.plugin()).defaultValueWidget();
    }

    IsWidget newLimitedValueWidget() {
        return ((HasValueOptionsPage)this.plugin()).limitedValueWidget();
    }

    private CEPWindowOperatorsDropdown newCEPWindowOperatorsDropdown() {
        final Pattern52 editingPattern = this.editingPattern();
        return new CEPWindowOperatorsDropdown((HasCEPWindow)editingPattern, false){
            {
                super(x0, x1);
                this.addValueChangeHandler(event -> {
                    CEPWindow cepWindow = editingPattern.getWindow();
                    String operator = ((OperatorSelection)event.getValue()).getValue();
                    cepWindow.setOperator(operator);
                });
            }
        };
    }

    private TextBox newBindingTextBox() {
        BindingTextBox bindingTextBox = new BindingTextBox();
        bindingTextBox.setText(((HasValueOptionsPage)this.plugin()).getBinding());
        bindingTextBox.addChangeHandler(event -> ((HasValueOptionsPage)this.plugin()).setBinding(bindingTextBox.getText()));
        return bindingTextBox;
    }

    boolean canSetupCepOperators() {
        return this.isCepOperatorsEnabled() && this.editingPattern() != null;
    }

    boolean canSetupDefaultValue() {
        if (!this.isDefaultValueEnabled()) {
            return false;
        }
        if (this.tableFormat() != GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            return false;
        }
        if (this.doesNotHaveFactTypeOrFactField()) {
            return false;
        }
        return ((HasValueOptionsPage)this.plugin()).doesOperatorNeedValue();
    }

    boolean canSetupLimitedValue() {
        if (!this.isLimitedValueEnabled()) {
            return false;
        }
        if (this.tableFormat() != GuidedDecisionTable52.TableFormat.LIMITED_ENTRY) {
            return false;
        }
        if (this.doesNotHaveFactTypeOrFactField()) {
            return false;
        }
        return ((HasValueOptionsPage)this.plugin()).doesOperatorNeedValue();
    }

    boolean canSetupBinding() {
        return this.isBindingEnabled() && this.isBindable();
    }

    private boolean isBindable() {
        return ((HasValueOptionsPage)this.plugin()).isBindable();
    }

    boolean canSetupValueList() {
        if (!this.isValueListEnabled()) {
            return false;
        }
        if (this.tableFormat() != GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY) {
            return false;
        }
        if (this.doesNotHaveFactTypeOrFactField()) {
            return false;
        }
        if (!this.doesOperatorAcceptValueList()) {
            return false;
        }
        return !this.presenter.getDataModelOracle().hasEnums(this.factType(), ((HasValueOptionsPage)this.plugin()).getFactField());
    }

    private boolean doesOperatorAcceptValueList() {
        return ((HasValueOptionsPage)this.plugin()).doesOperatorAcceptValueList();
    }

    private boolean doesNotHaveFactTypeOrFactField() {
        return DecisionTableColumnViewUtils.nil(((HasValueOptionsPage)this.plugin()).getFactType()) || DecisionTableColumnViewUtils.nil(((HasValueOptionsPage)this.plugin()).getFactField());
    }

    void isFactTypeAnEvent(Callback<Boolean> callback) {
        if (this.canSetupCepOperators()) {
            this.presenter.getDataModelOracle().isFactTypeAnEvent(this.factType(), callback);
        } else {
            callback.callback((Object)false);
        }
    }

    GuidedDecisionTable52.TableFormat tableFormat() {
        return this.presenter.getModel().getTableFormat();
    }

    private Pattern52 editingPattern() {
        return ((HasValueOptionsPage)this.plugin()).editingPattern();
    }

    private String factType() {
        if (this.editingPattern() != null) {
            return this.editingPattern().getFactType();
        }
        return "";
    }

    public String getValueList() {
        return ((HasValueOptionsPage)this.plugin()).getValueList();
    }

    public void setValueList(String valueList) {
        ((HasValueOptionsPage)this.plugin()).setValueList(valueList);
        this.setupDefaultValue();
    }

    private void markAsViewed() {
        ((HasValueOptionsPage)this.plugin()).setValueOptionsPageAsCompleted();
    }

    public static interface View
    extends UberElement<ValueOptionsPage> {
        public void setValueListText(String var1);

        public void enableValueList();

        public void disableValueList();

        public void hideValueList();

        public void setupDefaultValue(IsWidget var1);

        public void hideDefaultValue();

        public void setupLimitedValue(IsWidget var1);

        public void hideLimitedValue();

        public void setupBinding(IsWidget var1);

        public void hideBinding();

        public void hideCepOperators();

        public void setupCepOperators(IsWidget var1);
    }
}

