/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.pages;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ListBox;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.WorkItemPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.widgets.client.workitems.WorkItemParametersWidget;

@Dependent
@Templated
public class WorkItemPageView
implements IsElement,
WorkItemPage.View {
    @DataField(value="workItems")
    private ListBox workItems;
    @DataField(value="workItemParametersContainer")
    private Div workItemParametersContainer;
    private TranslationService translationService;
    private WorkItemPage<?> page;

    @Inject
    public WorkItemPageView(ListBox workItems, Div workItemParametersContainer, TranslationService translationService) {
        this.workItems = workItems;
        this.workItemParametersContainer = workItemParametersContainer;
        this.translationService = translationService;
    }

    @EventHandler(value={"workItems"})
    public void onSelectWorkItem(ChangeEvent event) {
        this.page.selectWorkItem(this.getSelectedWorkItem());
    }

    @Override
    public String getSelectedWorkItem() {
        return this.workItems.getSelectedValue();
    }

    public void init(WorkItemPage page) {
        this.page = page;
    }

    @Override
    public void setupWorkItemList() {
        this.workItems.clear();
        this.workItems.setEnabled(true);
        this.workItems.addItem(this.translate("WorkItemPageView.Choose", new Object[0]), "");
    }

    @Override
    public void setupEmptyWorkItemList() {
        this.workItems.clear();
        this.workItems.setEnabled(false);
        this.workItems.addItem(this.translate("WorkItemPageView.NoWorkItemsAvailable", new Object[0]));
    }

    @Override
    public void selectWorkItem(String currentWorkItem) {
        int currentValueIndex = DecisionTableColumnViewUtils.getCurrentIndexFromList(currentWorkItem, this.workItems);
        this.workItems.setSelectedIndex(currentValueIndex);
    }

    @Override
    public void showParameters(WorkItemParametersWidget parametersWidget) {
        DecisionTableColumnViewUtils.addWidgetToContainer((IsWidget)parametersWidget, this.workItemParametersContainer);
        this.workItemParametersContainer.setHidden(false);
    }

    @Override
    public void hideParameters() {
        this.workItemParametersContainer.setHidden(true);
    }

    @Override
    public int workItemsCount() {
        return this.workItems.getItemCount();
    }

    private String translate(String key, Object ... args) {
        return this.translationService.format(key, args);
    }

    @Override
    public void addItem(String itemName, String itemKey) {
        this.workItems.addItem(itemName, itemKey);
    }
}

