/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasAdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasFieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasPatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasValueOptionsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.ValueOptionsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionInsertFactWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionSetFactWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.AdditionalInfoPageInitializer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.BaseDecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DefaultWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.LimitedWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ValueOptionsPageInitializer;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class ActionSetFactPlugin
extends BaseDecisionTableColumnPlugin
implements HasFieldPage,
HasPatternPage,
HasValueOptionsPage,
HasAdditionalInfoPage {
    private PatternPage patternPage;
    private FieldPage fieldPage;
    private ValueOptionsPage<ActionSetFactPlugin> valueOptionsPage;
    private AdditionalInfoPage<ActionSetFactPlugin> additionalInfoPage;
    private Boolean valueOptionsPageCompleted = Boolean.FALSE;
    private ActionWrapper editingWrapper;
    private PatternWrapper patternWrapper;
    private Pattern52 editingPattern = new Pattern52();

    @Inject
    public ActionSetFactPlugin(PatternPage patternPage, FieldPage fieldPage, ValueOptionsPage<ActionSetFactPlugin> valueOptionsPage, AdditionalInfoPage<ActionSetFactPlugin> additionalInfoPage, Event<WizardPageStatusChangeEvent> changeEvent, TranslationService translationService) {
        super(changeEvent, translationService);
        this.patternPage = patternPage;
        this.fieldPage = fieldPage;
        this.valueOptionsPage = valueOptionsPage;
        this.additionalInfoPage = additionalInfoPage;
    }

    @Override
    public void init(NewGuidedDecisionTableColumnWizard wizard) {
        super.init(wizard);
        this.setupValues();
    }

    void setupValues() {
        if (!this.isNewColumn().booleanValue()) {
            DTColumnConfig52 originalCol = this.getOriginalColumnConfig52();
            this.editingWrapper = this.newActionWrapper(originalCol);
            this.patternWrapper = this.newPatternWrapper(this.editingWrapper());
            this.setValueOptionsPageAsCompleted();
            this.fireChangeEvent(this.patternPage);
            this.fireChangeEvent(this.fieldPage);
            this.fireChangeEvent(this.additionalInfoPage);
        }
    }

    PatternWrapper newPatternWrapper(ActionWrapper actionWrapper) {
        String boundName = actionWrapper.getBoundName();
        String factType = actionWrapper.getFactType();
        PatternWrapper defaultWrapper = new PatternWrapper(factType, boundName, false);
        return this.getPatterns().stream().filter(wrapper -> wrapper.getBoundName().equals(boundName)).findFirst().orElse(defaultWrapper);
    }

    ActionWrapper newActionWrapper(DTColumnConfig52 column) {
        if (column instanceof ActionInsertFactCol52) {
            return new ActionInsertFactWrapper(this, (ActionInsertFactCol52)column);
        }
        if (column instanceof ActionSetFieldCol52) {
            return new ActionSetFactWrapper(this, (ActionSetFieldCol52)column);
        }
        throw new UnsupportedOperationException("Unsupported column type: " + column.getClass().getSimpleName());
    }

    @Override
    public String getTitle() {
        return this.translate("ActionInsertFactPlugin.SetTheValueOfAField", new Object[0]);
    }

    @Override
    public List<WizardPage> getPages() {
        return new ArrayList<WizardPage>(){
            {
                this.add(ActionSetFactPlugin.this.initializedPatternPage());
                this.add(ActionSetFactPlugin.this.fieldPage);
                this.add(ActionSetFactPlugin.this.initializedValueOptionsPage());
                this.add(ActionSetFactPlugin.this.initializedAdditionalInfoPage());
            }
        };
    }

    @Override
    public Boolean generateColumn() {
        if (this.isNewColumn().booleanValue()) {
            this.presenter.appendColumn(this.editingCol());
        } else {
            this.presenter.updateColumn(this.originalCol(), this.editingCol());
        }
        return true;
    }

    ActionCol52 originalCol() {
        return (ActionCol52)this.getOriginalColumnConfig52();
    }

    @Override
    public void setValueOptionsPageAsCompleted() {
        if (!this.isValueOptionsPageCompleted().booleanValue()) {
            this.setValueOptionsPageCompleted();
            this.fireChangeEvent(this.valueOptionsPage);
        }
    }

    void setValueOptionsPageCompleted() {
        this.valueOptionsPageCompleted = Boolean.TRUE;
    }

    @Override
    public Boolean isValueOptionsPageCompleted() {
        return this.valueOptionsPageCompleted;
    }

    @Override
    public PatternWrapper patternWrapper() {
        return Optional.ofNullable(this.patternWrapper).orElse(new PatternWrapper());
    }

    @Override
    public void setEditingPattern(PatternWrapper patternWrapper) {
        this.patternWrapper = patternWrapper;
        this.resetField();
        this.fireChangeEvent(this.patternPage);
        this.fireChangeEvent(this.fieldPage);
        this.fireChangeEvent(this.additionalInfoPage);
    }

    @Override
    public String getEntryPointName() {
        return "";
    }

    @Override
    public void setEntryPointName(String entryPointName) {
    }

    @Override
    public List<PatternWrapper> getPatterns() {
        HashSet<PatternWrapper> patterns = new HashSet<PatternWrapper>();
        if (this.isNewColumn().booleanValue() || !this.isNewFactPattern()) {
            for (Pattern52 pattern52 : this.presenter.getModel().getPatterns()) {
                patterns.add(new PatternWrapper(pattern52));
            }
        }
        if (this.isNewColumn().booleanValue() || this.isNewFactPattern()) {
            for (Object o : this.presenter.getModel().getActionCols()) {
                ActionCol52 col = (ActionCol52)o;
                if (!(col instanceof ActionInsertFactCol52)) continue;
                ActionInsertFactCol52 c = (ActionInsertFactCol52)col;
                patterns.add(new PatternWrapper(c));
            }
        }
        return new ArrayList<PatternWrapper>(patterns);
    }

    @Override
    public int constraintValue() {
        return 0;
    }

    @Override
    public String getFactType() {
        return this.patternWrapper().getFactType();
    }

    @Override
    public FieldAccessorsAndMutators getAccessor() {
        return FieldAccessorsAndMutators.MUTATOR;
    }

    @Override
    public boolean filterEnumFields() {
        return false;
    }

    @Override
    public String getFactField() {
        return this.editingWrapper().getFactField();
    }

    @Override
    public void setFactField(String selectedValue) {
        if (this.isNewColumn().booleanValue()) {
            this.editingWrapper = this.newActionWrapper();
        }
        this.editingWrapper().setFactField(selectedValue);
        this.editingWrapper().setFactType(this.patternWrapper().getFactType());
        this.editingWrapper().setBoundName(this.patternWrapper().getBoundName());
        this.editingWrapper().setType(this.oracle().getFieldType(this.editingWrapper().getFactType(), this.editingWrapper().getFactField()));
        this.fireChangeEvent(this.fieldPage);
    }

    private ActionWrapper newActionWrapper() {
        if (this.isNewFactPattern()) {
            return this.newActionInsertFactWrapper();
        }
        return this.newActionSetFactWrapper();
    }

    ActionSetFactWrapper newActionSetFactWrapper() {
        return new ActionSetFactWrapper(this);
    }

    ActionInsertFactWrapper newActionInsertFactWrapper() {
        return new ActionInsertFactWrapper(this);
    }

    @Override
    public Pattern52 editingPattern() {
        this.editingPattern.setFactType(this.patternWrapper().getFactType());
        this.editingPattern.setBoundName(this.patternWrapper().getBoundName());
        this.editingPattern.setNegated(this.patternWrapper().isNegated());
        this.editingPattern.setEntryPointName(this.patternWrapper().getEntryPointName());
        return this.editingPattern;
    }

    public ActionCol52 editingCol() {
        return this.editingWrapper().getActionCol52();
    }

    @Override
    public String getHeader() {
        return this.editingWrapper().getHeader();
    }

    @Override
    public void setHeader(String header) {
        this.editingWrapper().setHeader(header);
        this.fireChangeEvent(this.additionalInfoPage);
    }

    @Override
    public Set<String> getAlreadyUsedColumnHeaders() {
        return this.presenter.getModel().getActionCols().stream().map(DTColumnConfig52::getHeader).collect(Collectors.toSet());
    }

    @Override
    public void setInsertLogical(Boolean value) {
        this.editingWrapper().setInsertLogical(value);
    }

    @Override
    public void setUpdate(Boolean value) {
        this.editingWrapper().setUpdate(value);
    }

    @Override
    public boolean showUpdateEngineWithChanges() {
        return this.editingWrapper() instanceof ActionSetFactWrapper;
    }

    @Override
    public boolean showLogicallyInsert() {
        return this.editingWrapper() instanceof ActionInsertFactWrapper;
    }

    @Override
    public boolean isLogicallyInsert() {
        return this.editingWrapper.isInsertLogical();
    }

    @Override
    public boolean isUpdateEngine() {
        return this.editingWrapper.isUpdateEngine();
    }

    @Override
    public String getValueList() {
        return this.editingWrapper().getValueList();
    }

    @Override
    public void setValueList(String valueList) {
        this.editingWrapper().setValueList(valueList);
    }

    @Override
    public String getBinding() {
        return this.patternWrapper().getBoundName();
    }

    @Override
    public void setBinding(String binding) {
        this.editingWrapper().setBoundName(binding);
    }

    @Override
    public GuidedDecisionTable52.TableFormat tableFormat() {
        return this.presenter.getModel().getTableFormat();
    }

    @Override
    public boolean doesOperatorNeedValue() {
        return true;
    }

    @Override
    public boolean isBindable() {
        return false;
    }

    @Override
    public boolean doesOperatorAcceptValueList() {
        return true;
    }

    @Override
    public IsWidget defaultValueWidget() {
        return new DefaultWidgetFactory<ActionSetFactPlugin>(this).create();
    }

    @Override
    public IsWidget limitedValueWidget() {
        return new LimitedWidgetFactory<ActionSetFactPlugin>(this).create();
    }

    boolean isNewFactPattern() {
        return !this.presenter.getModel().getPatterns().stream().anyMatch(p -> p.getBoundName().equals(this.getBinding()));
    }

    private AsyncPackageDataModelOracle oracle() {
        return this.presenter.getDataModelOracle();
    }

    ActionWrapper editingWrapper() {
        return Optional.ofNullable(this.editingWrapper).orElse(ActionWrapper.EMPTY_COLUMN);
    }

    PatternPage initializedPatternPage() {
        this.patternPage.disableEntryPoint();
        this.patternPage.disableNegatedPatterns();
        if (this.getOriginalColumnConfig52() instanceof ActionSetFieldCol52) {
            this.patternPage.disablePatternCreation();
        }
        return this.patternPage;
    }

    AdditionalInfoPage<ActionSetFactPlugin> initializedAdditionalInfoPage() {
        return AdditionalInfoPageInitializer.init(this.additionalInfoPage, this);
    }

    ValueOptionsPage<ActionSetFactPlugin> initializedValueOptionsPage() {
        return ValueOptionsPageInitializer.init(this.valueOptionsPage, this);
    }

    @Override
    public DecisionTableColumnPlugin.Type getType() {
        return DecisionTableColumnPlugin.Type.BASIC;
    }

    private void resetField() {
        this.editingWrapper().setFactField("");
        this.editingWrapper().setFactType(this.patternWrapper().getFactType());
        this.editingWrapper().setBoundName(this.patternWrapper().getBoundName());
        this.editingWrapper().setType("");
    }
}

