/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.datamodel.workitems.PortableParameterDefinition;
import org.drools.workbench.models.datamodel.workitems.PortableWorkDefinition;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTColumnConfig52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasAdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasFieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasPatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasWorkItemPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.WorkItemPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionWorkItemInsertWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionWorkItemSetWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ActionWorkItemWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.AdditionalInfoPageInitializer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.BaseDecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class ActionWorkItemSetFieldPlugin
extends BaseDecisionTableColumnPlugin
implements HasFieldPage,
HasPatternPage,
HasWorkItemPage,
HasAdditionalInfoPage {
    private Map<String, WorkItemParameter> workItems = new HashMap<String, WorkItemParameter>();
    private String selectedWorkItemKey;
    private ActionWorkItemWrapper editingWrapper;
    private PatternPage patternPage;
    private FieldPage fieldPage;
    private AdditionalInfoPage additionalInfoPage;
    private WorkItemPage workItemPage;
    private PatternWrapper patternWrapper;
    private Boolean workItemPageCompleted = Boolean.FALSE;

    @Inject
    public ActionWorkItemSetFieldPlugin(PatternPage patternPage, FieldPage fieldPage, AdditionalInfoPage additionalInfoPage, WorkItemPage workItemPage, Event<WizardPageStatusChangeEvent> changeEvent, TranslationService translationService) {
        super(changeEvent, translationService);
        this.patternPage = patternPage;
        this.fieldPage = fieldPage;
        this.additionalInfoPage = additionalInfoPage;
        this.workItemPage = workItemPage;
    }

    @Override
    public void init(NewGuidedDecisionTableColumnWizard wizard) {
        super.init(wizard);
        this.setupValues();
    }

    void setupValues() {
        if (!this.isNewColumn().booleanValue()) {
            this.editingWrapper = this.newActionWorkItemWrapper(this.getOriginalColumnConfig52());
            this.patternWrapper = this.newPatternWrapper(this.editingWrapper());
            this.setupWorkItems(this.editingWrapper());
            this.fireChangeEvent(this.patternPage);
            this.fireChangeEvent(this.fieldPage);
            this.fireChangeEvent(this.additionalInfoPage);
        }
    }

    PatternWrapper newPatternWrapper(ActionWorkItemWrapper actionWrapper) {
        String boundName = actionWrapper.getBoundName();
        String factType = actionWrapper.getFactType();
        PatternWrapper defaultWrapper = new PatternWrapper(factType, boundName, false);
        return this.getPatterns().stream().filter(wrapper -> wrapper.getBoundName().equals(boundName)).findFirst().orElse(defaultWrapper);
    }

    ActionWorkItemWrapper newActionWorkItemWrapper(DTColumnConfig52 column) {
        if (column instanceof ActionWorkItemInsertFactCol52) {
            return new ActionWorkItemInsertWrapper((BaseDecisionTableColumnPlugin)this, (ActionWorkItemInsertFactCol52)column);
        }
        if (column instanceof ActionWorkItemSetFieldCol52) {
            return new ActionWorkItemSetWrapper((BaseDecisionTableColumnPlugin)this, (ActionWorkItemSetFieldCol52)column);
        }
        throw new UnsupportedOperationException("Unsupported column type: " + column.getClass().getSimpleName());
    }

    @Override
    public String getWorkItem() {
        return this.selectedWorkItemKey;
    }

    @Override
    public void setWorkItem(String workItemKey) {
        this.setWorkItem("", "", "");
        this.getWorkItems().forEach((key, workItemParameter) -> {
            if (this.trim((String)key).equals(this.trim(workItemKey))) {
                PortableWorkDefinition workDefinition = workItemParameter.getWorkDefinition();
                PortableParameterDefinition parameterDefinition = workItemParameter.getWorkParameterDefinition();
                this.selectedWorkItemKey = this.trim((String)key);
                this.setWorkItem(workDefinition.getName(), parameterDefinition.getName(), parameterDefinition.getClassName());
                this.fireChangeEvent(this.workItemPage);
            }
        });
    }

    private void setWorkItem(String workItemName, String workItemResultParameterName, String parameterClassName) {
        this.editingWrapper().setWorkItemName(workItemName);
        this.editingWrapper().setWorkItemResultParameterName(workItemResultParameterName);
        this.editingWrapper().setParameterClassName(parameterClassName);
    }

    void setupWorkItems() {
        this.actionWorkItems().forEach(actionCol52 -> {
            PortableWorkDefinition workItemDefinition = ((ActionWorkItemCol52)actionCol52).getWorkItemDefinition();
            workItemDefinition.getResults().stream().filter(this::acceptParameterType).forEach(parameterDefinition -> {
                String key = this.trim(workItemDefinition.getName() + ":" + parameterDefinition.getName());
                this.workItems.put(key, new WorkItemParameter(workItemDefinition, (PortableParameterDefinition)parameterDefinition));
            });
        });
    }

    private String trim(String workItemKey) {
        return workItemKey.replaceAll("\\s", "");
    }

    private void setupWorkItems(ActionWorkItemWrapper wrapper) {
        String workItemKey = wrapper.getWorkItemName() + ":" + wrapper.getWorkItemResultParameterName();
        this.setupWorkItems();
        this.setWorkItem(workItemKey);
        this.setWorkItemPageAsCompleted();
    }

    private boolean acceptParameterType(PortableParameterDefinition ppd) {
        AsyncPackageDataModelOracle oracle = this.presenter.getDataModelOracle();
        if (DecisionTableColumnViewUtils.nil(this.editingWrapper().getFactField())) {
            return false;
        }
        if (DecisionTableColumnViewUtils.nil(ppd.getClassName())) {
            return false;
        }
        String fieldClassName = oracle.getFieldClassName(this.patternWrapper().getFactType(), this.editingWrapper().getFactField());
        return fieldClassName.equals(ppd.getClassName());
    }

    Map<String, WorkItemParameter> getWorkItems() {
        return this.workItems;
    }

    @Override
    public ActionCol52 editingCol() {
        return this.editingWrapper().getActionCol52();
    }

    @Override
    public Boolean isWorkItemSet() {
        return this.isWorkItemPageCompleted();
    }

    @Override
    public PortableWorkDefinition getWorkItemDefinition() {
        return null;
    }

    @Override
    public void forEachWorkItem(BiConsumer<String, String> biConsumer) {
        this.setupWorkItems();
        this.workItems.forEach((key, workItemParameter) -> {
            PortableWorkDefinition workItemDefinition = workItemParameter.getWorkDefinition();
            PortableParameterDefinition parameterDefinition = workItemParameter.getWorkParameterDefinition();
            String name = workItemDefinition.getDisplayName() + " - " + parameterDefinition.getName();
            biConsumer.accept(name, (String)key);
        });
    }

    @Override
    public void setWorkItemPageAsCompleted() {
        if (!this.isWorkItemPageCompleted().booleanValue()) {
            this.setWorkItemPageCompleted();
            this.fireChangeEvent(this.workItemPage);
        }
    }

    Boolean isWorkItemPageCompleted() {
        return this.workItemPageCompleted;
    }

    void setWorkItemPageCompleted() {
        this.workItemPageCompleted = Boolean.TRUE;
    }

    private List<ActionCol52> actionWorkItems() {
        return this.model().getActionCols().stream().filter(actionCol52 -> actionCol52 instanceof ActionWorkItemCol52).collect(Collectors.toList());
    }

    private GuidedDecisionTable52 model() {
        return this.presenter.getModel();
    }

    ActionWorkItemWrapper editingWrapper() {
        return Optional.ofNullable(this.editingWrapper).orElse(this.getEmptyColumn());
    }

    private ActionWorkItemWrapper getEmptyColumn() {
        return ActionWorkItemWrapper.EMPTY_COLUMN;
    }

    @Override
    public String getHeader() {
        return this.editingWrapper().getHeader();
    }

    @Override
    public void setHeader(String header) {
        this.editingWrapper().setHeader(header);
        this.fireChangeEvent(this.additionalInfoPage);
    }

    @Override
    public Set<String> getAlreadyUsedColumnHeaders() {
        return this.presenter.getModel().getActionCols().stream().map(DTColumnConfig52::getHeader).collect(Collectors.toSet());
    }

    @Override
    public void setInsertLogical(Boolean isInsertLogical) {
        this.editingWrapper().setInsertLogical(isInsertLogical);
    }

    @Override
    public void setUpdate(Boolean isUpdate) {
        this.editingWrapper().setUpdate(isUpdate);
    }

    @Override
    public String getTitle() {
        return this.translate("ActionWorkItemSetFieldPlugin.SetValue", new Object[0]);
    }

    @Override
    public List<WizardPage> getPages() {
        return new ArrayList<WizardPage>(){
            {
                this.add(ActionWorkItemSetFieldPlugin.this.initializedPatternPage());
                this.add(ActionWorkItemSetFieldPlugin.this.fieldPage);
                this.add(ActionWorkItemSetFieldPlugin.this.workItemPage);
                this.add(ActionWorkItemSetFieldPlugin.this.initializedAdditionalInfoPage());
            }
        };
    }

    @Override
    public Boolean generateColumn() {
        ActionCol52 actionCol52 = this.editingWrapper().getActionCol52();
        if (this.isNewColumn().booleanValue()) {
            this.presenter.appendColumn(actionCol52);
        } else {
            this.presenter.updateColumn(this.originalCol(), actionCol52);
        }
        return true;
    }

    private ActionCol52 originalCol() {
        return (ActionCol52)this.getOriginalColumnConfig52();
    }

    @Override
    public PatternWrapper patternWrapper() {
        return Optional.ofNullable(this.patternWrapper).orElse(new PatternWrapper());
    }

    @Override
    public void setEditingPattern(PatternWrapper patternWrapper) {
        this.patternWrapper = patternWrapper;
        this.editingWrapper().setFactField(null);
        this.editingWrapper().setFactType(null);
        this.editingWrapper().setBoundName(null);
        this.editingWrapper().setType(null);
        this.fireChangeEvent(this.patternPage);
        this.fireChangeEvent(this.fieldPage);
        this.fireChangeEvent(this.additionalInfoPage);
    }

    @Override
    public String getEntryPointName() {
        return "";
    }

    @Override
    public void setEntryPointName(String entryPointName) {
    }

    @Override
    public List<PatternWrapper> getPatterns() {
        HashSet<PatternWrapper> patterns = new HashSet<PatternWrapper>();
        if (this.isNewColumn().booleanValue() || !this.isNewFactPattern()) {
            for (Pattern52 pattern52 : this.presenter.getModel().getPatterns()) {
                patterns.add(new PatternWrapper(pattern52));
            }
        }
        if (this.isNewColumn().booleanValue() || this.isNewFactPattern()) {
            for (Object o : this.presenter.getModel().getActionCols()) {
                ActionCol52 col = (ActionCol52)o;
                if (!(col instanceof ActionWorkItemInsertFactCol52)) continue;
                patterns.add(new PatternWrapper((ActionInsertFactCol52)((ActionWorkItemInsertFactCol52)col)));
            }
        }
        return new ArrayList<PatternWrapper>(patterns);
    }

    @Override
    public int constraintValue() {
        return 0;
    }

    @Override
    public FieldAccessorsAndMutators getAccessor() {
        return FieldAccessorsAndMutators.ACCESSOR;
    }

    @Override
    public boolean filterEnumFields() {
        return false;
    }

    @Override
    public String getFactField() {
        return this.editingWrapper().getFactField();
    }

    @Override
    public void setFactField(String selectedValue) {
        if (this.isNewColumn().booleanValue()) {
            this.editingWrapper = this.newActionWrapper();
        }
        String factType = this.patternWrapper().getFactType();
        this.editingWrapper().setFactField(selectedValue);
        this.editingWrapper().setFactType(factType);
        this.editingWrapper().setBoundName(this.patternWrapper().getBoundName());
        this.editingWrapper().setType(this.oracle().getFieldType(this.editingWrapper().getFactType(), this.editingWrapper().getFactField()));
        this.fireChangeEvent(this.fieldPage);
    }

    private ActionWorkItemWrapper newActionWrapper() {
        if (this.isNewFactPattern()) {
            return new ActionWorkItemInsertWrapper(this);
        }
        return new ActionWorkItemSetWrapper(this);
    }

    private AsyncPackageDataModelOracle oracle() {
        return this.presenter.getDataModelOracle();
    }

    @Override
    public boolean showUpdateEngineWithChanges() {
        return this.editingWrapper() instanceof ActionWorkItemSetWrapper;
    }

    @Override
    public boolean showLogicallyInsert() {
        return this.editingWrapper() instanceof ActionWorkItemInsertWrapper;
    }

    @Override
    public boolean isLogicallyInsert() {
        return this.editingWrapper.isInsertLogical();
    }

    @Override
    public boolean isUpdateEngine() {
        return this.editingWrapper.isUpdateEngine();
    }

    boolean isNewFactPattern() {
        return !this.presenter.getModel().getPatterns().stream().anyMatch(p -> p.getBoundName().equals(this.patternWrapper().getBoundName()));
    }

    PatternPage initializedPatternPage() {
        this.patternPage.disableEntryPoint();
        this.patternPage.disableNegatedPatterns();
        if (this.getOriginalColumnConfig52() instanceof ActionWorkItemSetFieldCol52) {
            this.patternPage.disablePatternCreation();
        }
        return this.patternPage;
    }

    AdditionalInfoPage initializedAdditionalInfoPage() {
        return AdditionalInfoPageInitializer.init(this.additionalInfoPage, this);
    }

    @Override
    public DecisionTableColumnPlugin.Type getType() {
        return DecisionTableColumnPlugin.Type.ADVANCED;
    }

    static class WorkItemParameter {
        private PortableWorkDefinition workDefinition;
        private PortableParameterDefinition workParameterDefinition;

        WorkItemParameter(PortableWorkDefinition workDefinition, PortableParameterDefinition workParameterDefinition) {
            this.workDefinition = workDefinition;
            this.workParameterDefinition = workParameterDefinition;
        }

        PortableWorkDefinition getWorkDefinition() {
            return this.workDefinition;
        }

        PortableParameterDefinition getWorkParameterDefinition() {
            return this.workParameterDefinition;
        }
    }
}

