/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.models.datamodel.oracle.DataType;
import org.drools.workbench.models.datamodel.oracle.FieldAccessorsAndMutators;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.CompositeColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryCol;
import org.drools.workbench.models.guided.dtable.shared.model.LimitedEntryConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.Validator;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.CellUtilities;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.NewGuidedDecisionTableColumnWizard;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasAdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasFieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasPatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.commons.HasValueOptionsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.AdditionalInfoPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.CalculationTypePage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.FieldPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.OperatorPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.PatternPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.ValueOptionsPage;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.pages.common.DecisionTableColumnViewUtils;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.AdditionalInfoPageInitializer;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.BaseDecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DecisionTableColumnPlugin;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.DefaultWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.LimitedWidgetFactory;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.PatternWrapper;
import org.drools.workbench.screens.guided.dtable.client.wizard.column.plugins.commons.ValueOptionsPageInitializer;
import org.drools.workbench.screens.guided.rule.client.resources.GuidedRuleEditorResources;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class ConditionColumnPlugin
extends BaseDecisionTableColumnPlugin
implements HasFieldPage,
HasPatternPage,
HasValueOptionsPage,
HasAdditionalInfoPage {
    private PatternPage<ConditionColumnPlugin> patternPage;
    private CalculationTypePage calculationTypePage;
    private FieldPage<ConditionColumnPlugin> fieldPage;
    private OperatorPage operatorPage;
    private AdditionalInfoPage<ConditionColumnPlugin> additionalInfoPage;
    private ValueOptionsPage<ConditionColumnPlugin> valueOptionsPage;
    private PatternWrapper patternWrapper;
    private ConditionCol52 editingCol;
    private int constraintValue;
    private Boolean valueOptionsPageCompleted;
    private Pattern52 editingPattern;

    @Inject
    public ConditionColumnPlugin(PatternPage<ConditionColumnPlugin> patternPage, CalculationTypePage calculationTypePage, FieldPage<ConditionColumnPlugin> fieldPage, OperatorPage operatorPage, ValueOptionsPage<ConditionColumnPlugin> valueOptionsPage, AdditionalInfoPage<ConditionColumnPlugin> additionalInfoPage, Event<WizardPageStatusChangeEvent> changeEvent, TranslationService translationService) {
        super(changeEvent, translationService);
        this.patternPage = patternPage;
        this.calculationTypePage = calculationTypePage;
        this.fieldPage = fieldPage;
        this.operatorPage = operatorPage;
        this.valueOptionsPage = valueOptionsPage;
        this.additionalInfoPage = additionalInfoPage;
    }

    @Override
    public String getTitle() {
        return this.translate("ConditionColumnPlugin.AddNewConditionSimpleColumn", new Object[0]);
    }

    @Override
    public void init(NewGuidedDecisionTableColumnWizard wizard) {
        super.init(wizard);
        this.setupDefaultValues();
        this.setupPatternWrapper();
    }

    void setupPatternWrapper() {
        this.patternWrapper = new PatternWrapper(this.getEditingPattern().getFactType(), this.getEditingPattern().getBoundName(), this.getEditingPattern().getEntryPointName(), this.getEditingPattern().isNegated());
    }

    @Override
    public List<WizardPage> getPages() {
        return new ArrayList<WizardPage>(){
            {
                this.add(ConditionColumnPlugin.this.patternPage);
                if (ConditionColumnPlugin.this.isExtendedEntryTable()) {
                    this.add(ConditionColumnPlugin.this.calculationTypePage);
                }
                this.add(ConditionColumnPlugin.this.fieldPage);
                this.add(ConditionColumnPlugin.this.operatorPage);
                this.add(ConditionColumnPlugin.this.initializedValueOptionsPage());
                this.add(ConditionColumnPlugin.this.initializedAdditionalInfoPage());
            }
        };
    }

    @Override
    public Boolean generateColumn() {
        this.prepareValues();
        this.appendColumn();
        return true;
    }

    @Override
    public DecisionTableColumnPlugin.Type getType() {
        return DecisionTableColumnPlugin.Type.BASIC;
    }

    void appendColumn() {
        if (this.isNewColumn().booleanValue()) {
            this.presenter.appendColumn(this.editingPattern(), this.editingCol());
        } else {
            this.presenter.updateColumn(this.getOriginalPattern52(), this.originalCondition(), this.editingPattern(), this.editingCol());
        }
    }

    @Override
    public Pattern52 editingPattern() {
        return this.wrappedPattern();
    }

    private Pattern52 wrappedPattern() {
        this.editingPattern.setFactType(this.patternWrapper().getFactType());
        this.editingPattern.setBoundName(this.patternWrapper().getBoundName());
        this.editingPattern.setNegated(this.patternWrapper().isNegated());
        this.editingPattern.setEntryPointName(this.patternWrapper().getEntryPointName());
        return this.editingPattern;
    }

    public Pattern52 getEditingPattern() {
        return this.editingPattern;
    }

    @Override
    public void setEditingPattern(PatternWrapper patternWrapper) {
        this.setupDefaultValues();
        this.setPatternWrapper(patternWrapper);
        this.fireChangeEvent(this.patternPage);
        this.fireChangeEvent(this.calculationTypePage);
        this.fireChangeEvent(this.fieldPage);
        this.fireChangeEvent(this.operatorPage);
        this.fireChangeEvent(this.valueOptionsPage);
        this.fireChangeEvent(this.additionalInfoPage);
    }

    void setPatternWrapper(PatternWrapper patternWrapper) {
        this.patternWrapper = patternWrapper;
        this.editingPattern = this.extractEditingPattern();
    }

    private Pattern52 extractEditingPattern() {
        String factType = this.patternWrapper().getFactType();
        String boundName = this.patternWrapper().getBoundName();
        Optional<Pattern52> pattern = !this.patternWrapper().isNegated() ? Optional.ofNullable(this.model().getConditionPattern(boundName)) : this.model().getPatterns().stream().filter(Pattern52::isNegated).filter(p -> p.getFactType().equals(factType)).findFirst();
        return pattern.orElse(this.emptyPattern());
    }

    void prepareValues() {
        if (this.constraintValue() == 5) {
            this.editingCol().setOperator(this.operatorPlaceholder());
        }
        if (!this.isBindable()) {
            this.editingCol().setBinding(null);
        }
    }

    @Override
    public PatternWrapper patternWrapper() {
        return Optional.ofNullable(this.patternWrapper).orElse(new PatternWrapper());
    }

    @Override
    public String getEntryPointName() {
        return this.patternWrapper().getEntryPointName();
    }

    @Override
    public void setEntryPointName(String entryPointName) {
        this.patternWrapper().setEntryPointName(entryPointName);
    }

    @Override
    public List<PatternWrapper> getPatterns() {
        HashSet<PatternWrapper> patterns = new HashSet<PatternWrapper>();
        for (Pattern52 pattern52 : this.model().getPatterns()) {
            patterns.add(new PatternWrapper(pattern52));
        }
        return new ArrayList<PatternWrapper>(patterns);
    }

    public ConditionCol52 editingCol() {
        if (DecisionTableColumnViewUtils.nil(this.patternWrapper().getFactType())) {
            this.resetFieldAndOperator();
        }
        return this.editingCol;
    }

    @Override
    public String getHeader() {
        return this.editingCol().getHeader();
    }

    @Override
    public void setHeader(String header) {
        this.editingCol().setHeader(header);
        this.fireChangeEvent(this.additionalInfoPage);
    }

    @Override
    public Set<String> getAlreadyUsedColumnHeaders() {
        List conditions = this.getPresenter().getModel().getConditions();
        HashSet<String> columnNames = new HashSet<String>();
        for (CompositeColumn condition : conditions) {
            List headers = condition.getChildColumns().stream().map(BaseColumn::getHeader).collect(Collectors.toList());
            columnNames.addAll(headers);
        }
        return columnNames;
    }

    @Override
    public void setInsertLogical(Boolean value) {
    }

    @Override
    public void setUpdate(Boolean value) {
    }

    @Override
    public boolean showUpdateEngineWithChanges() {
        return false;
    }

    @Override
    public boolean showLogicallyInsert() {
        return false;
    }

    @Override
    public boolean isLogicallyInsert() {
        return false;
    }

    @Override
    public boolean isUpdateEngine() {
        return false;
    }

    @Override
    public String getFactField() {
        return this.editingCol().getFactField();
    }

    @Override
    public void setFactField(String selectedValue) {
        AsyncPackageDataModelOracle oracle = this.presenter.getDataModelOracle();
        this.editingCol().setFactField(selectedValue);
        this.editingCol().setFieldType(oracle.getFieldType(this.getFactType(), this.getFactField()));
        this.fireChangeEvent(this.fieldPage);
        this.fireChangeEvent(this.operatorPage);
        this.fireChangeEvent(this.additionalInfoPage);
        this.fireChangeEvent(this.valueOptionsPage);
    }

    @Override
    public String getBinding() {
        return this.editingCol().getBinding();
    }

    @Override
    public void setBinding(String binding) {
        this.editingCol().setBinding(binding);
    }

    @Override
    public boolean doesOperatorNeedValue() {
        return this.validator().doesOperatorNeedValue(this.editingCol());
    }

    @Override
    public boolean isBindable() {
        return this.tableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY || this.constraintValue() == 1;
    }

    @Override
    public int constraintValue() {
        boolean factHasEnums = this.presenter.getDataModelOracle().hasEnums(this.getFactType(), this.getFactField());
        if (factHasEnums) {
            this.setConstraintValueFieldAndUpdateEditingCol(1);
        }
        return this.constraintValue;
    }

    @Override
    public FieldAccessorsAndMutators getAccessor() {
        return FieldAccessorsAndMutators.ACCESSOR;
    }

    @Override
    public boolean filterEnumFields() {
        return this.constraintValue() == 3;
    }

    @Override
    public GuidedDecisionTable52.TableFormat tableFormat() {
        return this.model().getTableFormat();
    }

    @Override
    public String getValueList() {
        return this.editingCol().getValueList();
    }

    @Override
    public void setValueList(String valueList) {
        this.editingCol().setValueList(valueList);
        this.assertDefaultValue();
        this.fireChangeEvent(this.valueOptionsPage);
    }

    @Override
    public boolean doesOperatorAcceptValueList() {
        return this.validator().doesOperatorAcceptValueList(this.editingCol());
    }

    @Override
    public IsWidget defaultValueWidget() {
        return new DefaultWidgetFactory<ConditionColumnPlugin>(this).create();
    }

    @Override
    public IsWidget limitedValueWidget() {
        return new LimitedWidgetFactory<ConditionColumnPlugin>(this).create();
    }

    private Validator validator() {
        return new Validator(this.model().getConditions());
    }

    public void setConstraintValue(int constraintValue) {
        this.setConstraintValueFieldAndUpdateEditingCol(constraintValue);
        this.resetFieldAndOperator();
        this.fireChangeEvent(this.calculationTypePage);
        this.fireChangeEvent(this.fieldPage);
        this.fireChangeEvent(this.operatorPage);
    }

    @Override
    public void setValueOptionsPageAsCompleted() {
        if (!this.isValueOptionsPageCompleted().booleanValue()) {
            this.setValueOptionsPageCompleted();
            this.fireChangeEvent(this.valueOptionsPage);
        }
    }

    @Override
    public Boolean isValueOptionsPageCompleted() {
        return this.valueOptionsPageCompleted;
    }

    @Override
    public String getFactType() {
        return this.patternWrapper().getFactType();
    }

    public void setOperator(String operator) {
        this.editingCol().setOperator(operator);
        this.fireChangeEvent(this.operatorPage);
        this.fireChangeEvent(this.additionalInfoPage);
        this.fireChangeEvent(this.valueOptionsPage);
    }

    void setValueOptionsPageCompleted() {
        this.valueOptionsPageCompleted = Boolean.TRUE;
    }

    void setupDefaultValues() {
        if (this.isNewColumn().booleanValue()) {
            this.setupDefaultValuesForANewColumn();
            this.resetConstraintValueAndValueOptionsPageStatus();
            this.resetFieldAndOperator();
        } else {
            this.setupDefaultValuesForAnExistingColumn();
            this.setValueOptionsPageCompleted();
        }
    }

    private void setupDefaultValuesForAnExistingColumn() {
        Pattern52 clonedPattern52 = this.getOriginalPattern52().clonePattern();
        ConditionCol52 clonedConditionCol52 = this.clone(this.originalCondition());
        int constraintValueType = this.originalCondition().getConstraintValueType();
        this.editingPattern = clonedPattern52;
        this.editingCol = clonedConditionCol52;
        this.constraintValue = constraintValueType;
    }

    private void setupDefaultValuesForANewColumn() {
        Pattern52 newPattern52 = this.emptyPattern();
        ConditionCol52 newConditionCol52 = this.newConditionColumn();
        this.editingPattern = newPattern52;
        this.editingCol = newConditionCol52;
    }

    private void resetConstraintValueAndValueOptionsPageStatus() {
        this.constraintValue = 0;
        this.valueOptionsPageCompleted = Boolean.FALSE;
    }

    ConditionCol52 clone(final ConditionCol52 column) {
        Object clone = this.tableFormat() == GuidedDecisionTable52.TableFormat.LIMITED_ENTRY ? new LimitedEntryConditionCol52(){
            {
                this.setValue(ConditionColumnPlugin.this.cloneDTCellValue(((LimitedEntryCol)column).getValue()));
            }
        } : new ConditionCol52();
        clone.setConstraintValueType(column.getConstraintValueType());
        clone.setFactField(column.getFactField());
        clone.setFieldType(column.getFieldType());
        clone.setHeader(column.getHeader());
        clone.setOperator(column.getOperator());
        clone.setValueList(column.getValueList());
        clone.setDefaultValue(this.cloneDTCellValue(column.getDefaultValue()));
        clone.setHideColumn(column.isHideColumn());
        clone.setParameters(column.getParameters());
        clone.setWidth(column.getWidth());
        clone.setBinding(column.getBinding());
        return clone;
    }

    DTCellValue52 cloneDTCellValue(DTCellValue52 dcv) {
        if (dcv == null) {
            return null;
        }
        return new DTCellValue52(dcv);
    }

    ConditionCol52 originalCondition() {
        return (ConditionCol52)this.getOriginalColumnConfig52();
    }

    void resetFieldAndOperator() {
        this.editingCol.setFactField("");
        this.editingCol.setFieldType("");
        this.editingCol.setOperator(this.operatorPlaceholder());
    }

    void setConstraintValueFieldAndUpdateEditingCol(int constraintValue) {
        this.constraintValue = constraintValue;
        this.editingCol().setConstraintValueType(constraintValue);
    }

    void assertDefaultValue() {
        CellUtilities cellUtilities = new CellUtilities();
        AsyncPackageDataModelOracle oracle = this.presenter.getDataModelOracle();
        ColumnUtilities columnUtilities = new ColumnUtilities(this.model(), oracle);
        List<String> valueList = Arrays.asList(columnUtilities.getValueList((BaseColumn)this.editingCol));
        if (valueList.size() > 0) {
            String defaultValue = cellUtilities.asString(this.editingCol().getDefaultValue());
            if (!valueList.contains(defaultValue)) {
                this.editingCol.getDefaultValue().clearValues();
            }
        } else {
            DTCellValue52 defaultValue = this.editingCol().getDefaultValue();
            DataType.DataTypes dataType = columnUtilities.getDataType(this.editingPattern(), this.editingCol());
            cellUtilities.convertDTCellValueType(dataType, defaultValue);
        }
    }

    private AdditionalInfoPage initializedAdditionalInfoPage() {
        return AdditionalInfoPageInitializer.init(this.additionalInfoPage, this);
    }

    private ValueOptionsPage<ConditionColumnPlugin> initializedValueOptionsPage() {
        return ValueOptionsPageInitializer.init(this.valueOptionsPage, this);
    }

    ConditionCol52 newConditionColumn() {
        switch (this.tableFormat()) {
            case EXTENDED_ENTRY: {
                return new ConditionCol52();
            }
            case LIMITED_ENTRY: {
                return new LimitedEntryConditionCol52();
            }
        }
        throw new UnsupportedOperationException("Unsupported table format: " + this.tableFormat());
    }

    private boolean isExtendedEntryTable() {
        return this.tableFormat() == GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY;
    }

    GuidedDecisionTable52 model() {
        return this.presenter.getModel();
    }

    Pattern52 emptyPattern() {
        return new Pattern52().clonePattern();
    }

    public String operatorPlaceholder() {
        return GuidedRuleEditorResources.CONSTANTS.pleaseChoose();
    }
}

