/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.editor.menu;

import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.screens.guided.dtable.client.editor.menu.RadarMenuView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTablePinnedEvent;
import org.drools.workbench.screens.guided.dtable.client.widget.table.events.cdi.DecisionTableSelectedEvent;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@Dependent
public class RadarMenuBuilder
implements MenuFactory.CustomMenuBuilder,
RadarMenuView.Presenter {
    private RadarMenuView view;
    private MenuItem radarMenuItem;
    private GuidedDecisionTableModellerView.Presenter modeller;

    @Inject
    public RadarMenuBuilder(RadarMenuView view) {
        this.view = view;
    }

    @PostConstruct
    public void setup() {
        this.view.init(this);
        this.radarMenuItem = new BaseMenuCustom<IsWidget>(){

            public IsWidget build() {
                return RadarMenuBuilder.this.view;
            }

            public boolean isEnabled() {
                return RadarMenuBuilder.this.view.isEnabled();
            }

            public void setEnabled(boolean enabled) {
                RadarMenuBuilder.this.view.setEnabled(enabled);
            }
        };
    }

    @Override
    public void setModeller(GuidedDecisionTableModellerView.Presenter modeller) {
        this.modeller = modeller;
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return this.radarMenuItem;
    }

    public void onUpdateRadarEvent(@Observes UpdateRadarEvent event) {
        GuidedDecisionTableModellerView.Presenter modeller = event.getModeller();
        if (modeller == null) {
            return;
        }
        if (!modeller.equals(this.modeller)) {
            return;
        }
        this.onClick();
    }

    public void onDecisionTablePinnedEvent(@Observes DecisionTablePinnedEvent event) {
        GuidedDecisionTableModellerView.Presenter modeller = event.getPresenter();
        if (modeller == null) {
            return;
        }
        if (!modeller.equals(this.modeller)) {
            return;
        }
        this.view.enableDrag(!event.isPinned());
    }

    public void onDecisionTableSelectedEvent(@Observes DecisionTableSelectedEvent event) {
        this.radarMenuItem.setEnabled(event.getPresenter().isPresent());
    }

    @Override
    public void onClick() {
        this.view.reset();
        this.view.setModellerBounds(this.modeller.getView().getBounds());
        this.view.setAvailableDecisionTables(this.modeller.getAvailableDecisionTables());
        this.view.setVisibleBounds(this.modeller.getView().getGridLayerView().getVisibleBounds());
    }

    @Override
    public void onDragVisibleBounds(double canvasX, double canvasY) {
        double _canvasX = -canvasX;
        double _canvasY = -canvasY;
        Transform oldTransform = this.modeller.getView().getGridLayerView().getViewport().getTransform();
        double scaleX = oldTransform.getScaleX();
        double scaleY = oldTransform.getScaleY();
        double translateX = oldTransform.getTranslateX();
        double translateY = oldTransform.getTranslateY();
        double dx = _canvasX - translateX / scaleX;
        double dy = _canvasY - translateY / scaleY;
        Transform newTransform = oldTransform.copy().translate(dx, dy);
        this.modeller.getView().getGridLayerView().getViewport().setTransform(newTransform);
        this.modeller.getView().getGridLayerView().batch();
        this.modeller.getView().refreshScrollPosition();
    }

    public static class UpdateRadarEvent {
        private final GuidedDecisionTableModellerView.Presenter modeller;

        public UpdateRadarEvent(GuidedDecisionTableModellerView.Presenter modeller) {
            this.modeller = modeller;
        }

        public GuidedDecisionTableModellerView.Presenter getModeller() {
            return this.modeller;
        }
    }
}

