/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.models.guided.dtable.shared.model.ActionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BRLConditionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.Pattern52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableModellerView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.GuidedDecisionTableView;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.ColumnLabelWidget;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.DeleteColumnManagementAnchorWidget;
import org.drools.workbench.screens.guided.dtable.client.widget.table.columns.control.EditColumnManagementAnchorWidget;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.utilities.ColumnUtilities;
import org.jboss.errai.ioc.client.api.ManagedInstance;

@Dependent
public class ColumnManagementView
extends VerticalPanel {
    private ManagedInstance<DeleteColumnManagementAnchorWidget> deleteColumnManagementAnchorWidgets;
    private GuidedDecisionTableModellerView.Presenter presenter;

    public ColumnManagementView() {
    }

    @Inject
    public ColumnManagementView(ManagedInstance<DeleteColumnManagementAnchorWidget> deleteColumnManagementAnchorWidgets) {
        this.deleteColumnManagementAnchorWidgets = deleteColumnManagementAnchorWidgets;
    }

    public void init(GuidedDecisionTableModellerView.Presenter presenter) {
        this.presenter = presenter;
    }

    public void renderColumns(Map<String, List<BaseColumn>> columnGroups) {
        this.clear();
        for (String groupLabel : columnGroups.keySet()) {
            VerticalPanel columnGroup = new VerticalPanel();
            HorizontalPanel columnGroupHeader = new HorizontalPanel();
            VerticalPanel columnGroupColumns = new VerticalPanel();
            columnGroupHeader.add((Widget)new Label(groupLabel));
            columnGroup.add((Widget)columnGroupHeader);
            columnGroup.add((Widget)columnGroupColumns);
            this.add((Widget)columnGroup);
            for (BaseColumn column : columnGroups.get(groupLabel)) {
                if (column instanceof ActionCol52) {
                    columnGroupColumns.add((Widget)this.renderColumn((ActionCol52)column));
                    continue;
                }
                if (column instanceof BRLConditionColumn) {
                    columnGroupColumns.add((Widget)this.renderColumn((BRLConditionColumn)column));
                    continue;
                }
                if (!(column instanceof Pattern52)) continue;
                this.renderColumn((Pattern52)column).forEach(arg_0 -> ((VerticalPanel)columnGroupColumns).add(arg_0));
            }
        }
    }

    HorizontalPanel renderColumn(final ActionCol52 actionColumn) {
        HorizontalPanel action = this.newHorizontalPanel();
        ColumnLabelWidget actionLabel = this.makeColumnLabel(actionColumn);
        action.add((Widget)actionLabel);
        FlowPanel buttons = new FlowPanel(){
            {
                this.add((Widget)ColumnManagementView.this.editAnchor(clickEvent -> ColumnManagementView.this.presenter.getActiveDecisionTable().ifPresent(dt -> dt.editAction(actionColumn))));
                if (ColumnManagementView.this.presenter.isActiveDecisionTableEditable()) {
                    this.add((Widget)ColumnManagementView.this.deleteAnchor(actionColumn.getHeader(), () -> {
                        try {
                            Optional<GuidedDecisionTableView.Presenter> dtPresenter = ColumnManagementView.this.presenter.getActiveDecisionTable();
                            if (dtPresenter.isPresent()) {
                                dtPresenter.get().deleteColumn(actionColumn);
                            }
                        }
                        catch (ModelSynchronizer.VetoDeletePatternInUseException veto) {
                            ColumnManagementView.this.presenter.getView().showUnableToDeleteColumnMessage(actionColumn);
                        }
                        catch (ModelSynchronizer.VetoException veto) {
                            ColumnManagementView.this.presenter.getView().showGenericVetoMessage();
                        }
                    }));
                }
            }
        };
        action.add((Widget)buttons);
        return action;
    }

    List<HorizontalPanel> renderColumn(final Pattern52 pattern) {
        ArrayList<HorizontalPanel> conditions = new ArrayList<HorizontalPanel>();
        for (final ConditionCol52 conditionColumn : pattern.getChildColumns()) {
            HorizontalPanel condition = this.newHorizontalPanel();
            ColumnLabelWidget conditionLabel = this.makeColumnLabel(conditionColumn);
            condition.add((Widget)conditionLabel);
            FlowPanel buttons = new FlowPanel(){
                {
                    this.add((Widget)ColumnManagementView.this.editAnchor(clickEvent -> ColumnManagementView.this.presenter.getActiveDecisionTable().ifPresent(dt -> dt.editCondition(pattern, conditionColumn))));
                    if (ColumnManagementView.this.presenter.isActiveDecisionTableEditable()) {
                        this.add(ColumnManagementView.this.removeCondition(conditionColumn));
                    }
                }
            };
            condition.add((Widget)buttons);
            conditions.add(condition);
        }
        return conditions;
    }

    HorizontalPanel renderColumn(final BRLConditionColumn conditionColumn) {
        HorizontalPanel condition = this.newHorizontalPanel();
        ColumnLabelWidget columnLabel = this.makeColumnLabel((ConditionCol52)conditionColumn);
        condition.add((Widget)columnLabel);
        FlowPanel buttons = new FlowPanel(){
            {
                this.add((Widget)ColumnManagementView.this.editAnchor(clickEvent -> ColumnManagementView.this.presenter.getActiveDecisionTable().ifPresent(dt -> dt.editCondition(conditionColumn))));
                if (ColumnManagementView.this.presenter.isActiveDecisionTableEditable()) {
                    this.add(ColumnManagementView.this.removeCondition((ConditionCol52)conditionColumn));
                }
            }
        };
        condition.add((Widget)buttons);
        return condition;
    }

    ColumnLabelWidget makeColumnLabel(ConditionCol52 conditionColumn) {
        StringBuilder labelBuilder = new StringBuilder();
        if (conditionColumn.isBound()) {
            labelBuilder.append(conditionColumn.getBinding()).append(" : ");
        }
        labelBuilder.append(conditionColumn.getHeader());
        ColumnLabelWidget label = this.newColumnLabelWidget(labelBuilder.toString());
        ColumnUtilities.setColumnLabelStyleWhenHidden(label, conditionColumn.isHideColumn());
        return label;
    }

    ColumnLabelWidget makeColumnLabel(ActionCol52 actionColumn) {
        ColumnLabelWidget label = this.newColumnLabelWidget(actionColumn.getHeader());
        ColumnUtilities.setColumnLabelStyleWhenHidden(label, actionColumn.isHideColumn());
        return label;
    }

    EditColumnManagementAnchorWidget editAnchor(ClickHandler clickHandler) {
        return new EditColumnManagementAnchorWidget(clickHandler);
    }

    Widget removeCondition(ConditionCol52 column) {
        return this.deleteAnchor(column.getHeader(), () -> {
            try {
                Optional<GuidedDecisionTableView.Presenter> dtPresenter = this.presenter.getActiveDecisionTable();
                if (dtPresenter.isPresent()) {
                    dtPresenter.get().deleteColumn(column);
                }
            }
            catch (ModelSynchronizer.VetoDeletePatternInUseException veto) {
                this.presenter.getView().showUnableToDeleteColumnMessage(column);
            }
            catch (ModelSynchronizer.VetoException veto) {
                this.presenter.getView().showGenericVetoMessage();
            }
        });
    }

    HorizontalPanel newHorizontalPanel() {
        return new HorizontalPanel();
    }

    ColumnLabelWidget newColumnLabelWidget(String text) {
        return new ColumnLabelWidget(text);
    }

    DeleteColumnManagementAnchorWidget deleteAnchor(String columnHeader, Command command) {
        DeleteColumnManagementAnchorWidget widget = (DeleteColumnManagementAnchorWidget)((Object)this.deleteColumnManagementAnchorWidgets.get());
        widget.init(columnHeader, command);
        return widget;
    }
}

