/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BRLActionVariableColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumnFieldDiff;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.ModelSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.Synchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseColumnSynchronizer;
import org.drools.workbench.screens.guided.dtable.client.widget.table.model.synchronizers.impl.BaseSynchronizer;

@Dependent
public class BRLActionColumnSynchronizer
extends BaseColumnSynchronizer<BaseColumnSynchronizer.ColumnMetaData, BaseColumnSynchronizer.ColumnMetaData, BaseColumnSynchronizer.ColumnMetaData> {
    @Override
    public int priority() {
        return 3;
    }

    @Override
    public boolean handlesAppend(Synchronizer.MetaData metaData) throws ModelSynchronizer.VetoException {
        return this.handlesUpdate(metaData);
    }

    @Override
    public void append(BaseColumnSynchronizer.ColumnMetaData metaData) throws ModelSynchronizer.VetoException {
        if (!this.handlesAppend(metaData)) {
            return;
        }
        BRLActionColumn column = (BRLActionColumn)metaData.getColumn();
        this.model.getActionCols().add(column);
        for (BRLActionVariableColumn childModelColumn : column.getChildColumns()) {
            this.synchroniseAppendColumn((BaseColumn)childModelColumn);
        }
    }

    @Override
    public boolean handlesUpdate(Synchronizer.MetaData metaData) throws ModelSynchronizer.VetoException {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof BRLActionColumn;
    }

    @Override
    public List<BaseColumnFieldDiff> update(BaseColumnSynchronizer.ColumnMetaData originalMetaData, BaseColumnSynchronizer.ColumnMetaData editedMetaData) throws ModelSynchronizer.VetoException {
        ArrayList<DTCellValue52> originalColumnData;
        if (!this.handlesUpdate(originalMetaData) || !this.handlesUpdate(editedMetaData)) {
            return Collections.emptyList();
        }
        BRLActionColumn originalColumn = (BRLActionColumn)originalMetaData.getColumn();
        BRLActionColumn editedColumn = (BRLActionColumn)editedMetaData.getColumn();
        List diffs = originalColumn.diff((BaseColumn)editedColumn);
        HashMap originalColumnsData = new HashMap();
        for (BRLActionVariableColumn variable : originalColumn.getChildColumns()) {
            int iColumnIndex = this.model.getExpandedColumns().indexOf(variable);
            originalColumnData = new ArrayList();
            String key = this.makeUpdateBRLActionColumnKey(variable);
            for (List row : this.model.getData()) {
                originalColumnData.add((DTCellValue52)row.get(iColumnIndex));
            }
            originalColumnsData.put(key, originalColumnData);
        }
        this.model.getActionCols().add(this.model.getActionCols().indexOf(originalColumn), editedColumn);
        for (BRLActionVariableColumn childModelColumn : editedColumn.getChildColumns()) {
            String key = this.makeUpdateBRLActionColumnKey(childModelColumn);
            if (originalColumnsData.containsKey(key)) {
                originalColumnData = (List)originalColumnsData.get(key);
                this.synchroniseAppendColumn((BaseColumn)childModelColumn, originalColumnData);
                continue;
            }
            this.synchroniseAppendColumn((BaseColumn)childModelColumn);
        }
        this.delete(originalMetaData);
        return diffs;
    }

    @Override
    public boolean handlesDelete(Synchronizer.MetaData metaData) throws ModelSynchronizer.VetoException {
        if (!(metaData instanceof BaseColumnSynchronizer.ColumnMetaData)) {
            return false;
        }
        return ((BaseColumnSynchronizer.ColumnMetaData)metaData).getColumn() instanceof BRLActionColumn;
    }

    @Override
    public void delete(BaseColumnSynchronizer.ColumnMetaData metaData) throws ModelSynchronizer.VetoException {
        if (!this.handlesDelete(metaData)) {
            return;
        }
        BRLActionColumn column = (BRLActionColumn)metaData.getColumn();
        if (column.getChildColumns().size() > 0) {
            int iFirstColumnIndex = this.model.getExpandedColumns().indexOf(column.getChildColumns().get(0));
            for (int iColumnIndex = 0; iColumnIndex < column.getChildColumns().size(); ++iColumnIndex) {
                this.synchroniseDeleteColumn(iFirstColumnIndex);
            }
        }
        this.model.getActionCols().remove(column);
    }

    @Override
    public boolean handlesMoveColumnsTo(List<? extends Synchronizer.MetaData> metaData) throws ModelSynchronizer.VetoException {
        return this.isBRLFragment(metaData);
    }

    private boolean isBRLFragment(List<? extends Synchronizer.MetaData> metaData) {
        if (!metaData.stream().allMatch(c -> c instanceof BaseSynchronizer.MoveColumnToMetaData)) {
            return false;
        }
        if (!metaData.stream().allMatch(c -> ((BaseSynchronizer.MoveColumnToMetaData)c).getColumn() instanceof BRLActionVariableColumn)) {
            return false;
        }
        BaseSynchronizer.MoveColumnToMetaData md = (BaseSynchronizer.MoveColumnToMetaData)metaData.get(0);
        BRLActionVariableColumn srcModelColumn = (BRLActionVariableColumn)md.getColumn();
        BRLActionColumn srcModelPattern = this.model.getBRLColumn(srcModelColumn);
        return srcModelPattern.getChildColumns().size() == metaData.size();
    }

    @Override
    public void moveColumnsTo(List<BaseSynchronizer.MoveColumnToMetaData> metaData) throws ModelSynchronizer.VetoException {
        if (!this.handlesMoveColumnsTo(metaData)) {
            return;
        }
        if (!this.isBRLFragment(metaData)) {
            throw new ModelSynchronizer.MoveVetoException();
        }
        this.doMoveBRLFragment(metaData);
    }

    private void doMoveBRLFragment(List<BaseSynchronizer.MoveColumnToMetaData> metaData) throws ModelSynchronizer.VetoException {
        BaseSynchronizer.MoveColumnToMetaData md = metaData.get(0);
        BRLActionVariableColumn srcModelColumn = (BRLActionVariableColumn)md.getColumn();
        BRLActionColumn srcModelBRLFragment = this.model.getBRLColumn(srcModelColumn);
        if (srcModelBRLFragment == null) {
            throw new ModelSynchronizer.MoveVetoException();
        }
        List srcModelBRLFragmentColumns = srcModelBRLFragment.getChildColumns();
        int srcModelBRLFragmentColumnsCount = srcModelBRLFragmentColumns.size();
        if (srcModelBRLFragmentColumnsCount == 0) {
            throw new ModelSynchronizer.MoveVetoException();
        }
        if (srcModelBRLFragmentColumnsCount != metaData.size()) {
            throw new ModelSynchronizer.MoveVetoException();
        }
        int tgtColumnIndex = md.getTargetColumnIndex();
        int tgtActionIndex = this.findTargetActionIndex(md);
        List allModelColumns = this.model.getExpandedColumns();
        this.moveModelData(tgtColumnIndex, allModelColumns.indexOf(srcModelBRLFragmentColumns.get(0)), allModelColumns.indexOf(srcModelBRLFragmentColumns.get(0)) + srcModelBRLFragmentColumnsCount - 1);
        this.model.getActionCols().remove(srcModelBRLFragment);
        this.model.getActionCols().add(tgtActionIndex, srcModelBRLFragment);
    }

    private String makeUpdateBRLActionColumnKey(BRLActionVariableColumn variable) {
        StringBuilder key = new StringBuilder(variable.getVarName()).append(":").append(variable.getFieldType()).append(":").append(variable.getFactField()).append(":").append(variable.getFactType());
        return key.toString();
    }
}

